
/* cmapmedianmultistage.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	Median Multi Stage Filter.
 * Author: 	Jim GEUTHER
 * Date:    	26-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This Gimp plugin will perform a median running filter on a colormap
 * indexed image.
 *
 * Processing options:
 *
 * Y window - Specifies the Y window.
 * X window - Specifies the X window.
 *
 * Notes: for optimum results, you should first remap the colormap from
 * dark to light or from light to dark.
 *
 *
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"

/*#define	_DEBUG */

#undef	DOPROGRESS	/* For some reason the progress window
			 * results into invalid results being
			 * displayed
			 */

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

/*
 * Macros to to convert array [][] to offset 
 */

#ifdef	OBSOLETE
unsigned char *apos(
unsigned char	*image_start,
int	rowstride,
int	channels,
int	y1,
int	x1
)
{

unsigned char	*pos;

pos = image_start + rowstride * y1 +  (x1 * channels);

return(pos);
}
#else
#define apos( a,b,c, yy, xx )	(a)+(b)*(yy)+((xx)*(c))
#endif


/* Declare a local function.
 */
 
static void scale_callback (int, void *, void *);
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);
static void median(Image, Image);

static char *prog_name;
static long ywindow=2, xwindow=2;

typedef struct {
	int	ywindow;
	int	xwindow;
} Data;

static Data	*data = NULL;
	
int dialog_ID;

int
main (argc, argv)
     int argc;
     char **argv;
{

Image input, output;
int 	yw_scale_ID, xw_scale_ID, group_ID;
long	process, diff;
long	type;

static int one=1;

 /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = output = 0;
      data=gimp_get_params();
      if( ! data ) {
      	if( data = calloc(sizeof(Data),1)) {
      		data->ywindow = 3;
      		data->xwindow = 3;
      	}
      }
      /* This is a regular filter. What that means is that it operates
       *  on the input image. Output is put into the ouput image. The
       *  filter should not worry, or even care where these images come
       *  from. The only guarantee is that they are the same size and
       *  depth.
       */
      input = gimp_get_input_image (0);

      /* If input image is available and the input is color, then do some
       *  work. (Bleed). Then update the output image.
       */
      if (input)
	{
		type = gimp_image_type( input );
	  switch ( type )
	    {

    	    case GRAY_IMAGE:
    	    case RGB_IMAGE:	   
		gimp_message ("median: can only operate on indexed image types");    	 
	    	break;
	    case INDEXED_IMAGE :
		dialog_ID = gimp_new_dialog ("Median filter windows");
		group_ID = gimp_new_row_group( dialog_ID, DEFAULT, NORMAL, "" );
	      	yw_scale_ID = gimp_new_scale( dialog_ID, group_ID, 1, 8, data->ywindow,0 );
	      	gimp_new_label( dialog_ID, yw_scale_ID, "Y Window");
		xw_scale_ID = gimp_new_scale( dialog_ID, group_ID, 1, 8, data->xwindow, 0 );
	      	gimp_new_label( dialog_ID, xw_scale_ID, "X Window");		
		gimp_add_callback( dialog_ID, yw_scale_ID, scale_callback, &data->ywindow);
		gimp_add_callback( dialog_ID, xw_scale_ID, scale_callback, &data->xwindow );
	      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
	      	gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
	      
	      if (gimp_show_dialog (dialog_ID))
		{
			gimp_set_params(sizeof(Data),data);
#ifdef	_DEBUG		
		  if( output = gimp_new_image( 0, gimp_image_width(input),
		  		gimp_image_height(input), gimp_image_type(input) ) ) {
		      gimp_set_image_colors(output,gimp_image_cmap(input),
		      				gimp_image_colors(input));
#else
		if( output = gimp_get_output_image( 0 ) ) {
#endif			

#ifdef	DOPROGRESS
			gimp_init_progress("Median");
#endif

		      	gimp_display_image( output );
		      	median(input,output);
		      	
#ifdef	DOPROGRESS		      	
		      	gimp_do_progress(1,1);
#endif		      	
		      	
		      	gimp_update_image (output);
		    }

		}

	      break;
	    default:
	      gimp_message ("median: cannot operate on unknown image types");
	      break;
	    }
	}

      /* Free both images.
       */
      if (input)
	gimp_free_image (input);
      if (output)
	gimp_free_image (output);

      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

static void
scale_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}


static void
median(input, output)
     Image input, output;
{
  long width, height;
  long channels, rowstride, colors;
  unsigned char *src_row, *dest_row;
  unsigned char *src, *dest, *cmap;
int x1, y1, x2, y2;
  int row, col, ix;
 
unsigned char *src1,*src2,*src3,*src4;
long	N1, M1, N2, M2, i,j,k, l, NM,NM2,NW2,MW2;

int	NW,MW;
long	*q,*s,*r,*t,loop,loop1,tmp,isave,mdn,ltmdn,g,*leftcol,*rightcol,*hist;
int size;
long p[5];
#ifdef	DOPROGRESS
int	cur_progress,max_progress;
#endif

  /* Get the input area. This is the bounding box of the selection in 
   *  the image (or the entire image if there is no selection). Only
   *  operating on the input area is simply an optimization. It doesn't
   *  need to be done for correct operation. (It simply makes it go
   *  faster, since fewer pixels need to be operated on).
   *
   * This filter will use only x1 and y1 as starting coordinates.
   *
   */
gimp_image_area (input, &x1, &y1, &x2, &y2);
colors   = gimp_image_colors( input ); 
cmap	 = gimp_image_cmap( input );
width    = gimp_image_width (input);
height   = gimp_image_height (input);
channels = gimp_image_channels (input);
rowstride = width * channels;

src_row = gimp_image_data( input );
dest_row = gimp_image_data( output );

NW = data->ywindow;
MW = data->xwindow;

#ifdef	_DEBUG
printf("%s.%ld: yw=%ld, xw=%ld\n",__FILE__,__LINE__,NW,MW);
#endif

#ifdef	OBSOLETE
for( row = y1; row < y2; row++ ) {
	for( col = x1; col < x2; col++ ) {
		dest = apos( dest_row, rowstride, channels, row, col );
		src  = apos( src_row, rowstride, channels, row, col );
		for( ix = 0; ix < channels; ix++ ) {
			*dest++ = *src++;
		}
	}
}
#endif

N1 = y1;
M1 = x1;
N2 = y2;
M2 = x2;


if(t=(long *)calloc( NW * MW * sizeof(long),1 ) )
{

   if(leftcol=(long *)calloc(NW*sizeof(long),1))
   {

      if(rightcol=(long *)calloc(NW*sizeof(long),1))
      {
         if(hist=(long *)calloc(256*sizeof(long),1))
         {
         
         NM=NW*MW;
         NM2=NM/2;
         NW2=NW/2;
         MW2=MW/2;
         
         /*
	 ** Perform running median filtering
	 */
	 for(k=N1+NW2;k<N2-NW2;/*k++*/)
	 {
	    /* Initialize histogram */
	    for(i=0;i<256;i++) hist[i]=0;
	    /*
	    ** Calculate the histogram and the median of the
	    ** first window.
	    */
	    for(i=0;i<NW;i++)
	    {
	       for(j=0;j<MW;j++)
	       {
#ifdef	OBSOLETE	       
	          t[MW*i+j]=a_info->data_cm[k+i-NW2][M1+MW2+j-MW2];
	          g=a_info->data_cm[k+i-NW2][M1+MW2+j-MW2];
#else
			src = apos( src_row, rowstride, channels, k+i-NW2, M1+MW2+j-MW2 );
			t[ MW*i+j ] = *src;
			src = apos( src_row,rowstride,channels, k+i-NW2, M1+MW2+j-MW2 );
			g=*src;					
#endif	          
	          hist[g]++;
	       }
	    }

	    for(loop=0;loop<NM-1;loop++)
	    {
	       isave=loop;
	       for(loop1=loop+1;loop1<NM;loop1++)
	       {
	          if(t[isave]>t[loop1])
	          {
	             isave=loop1;
	          }
	       }
	       if(isave!=loop)	            
	       {
	             tmp=t[loop];
	             t[loop]=t[isave];
	             t[isave]=tmp;
	       }
	    }



	    mdn=t[NM2];
#ifdef	OBSOLETE	    
	    b_info->data_cm[k][M1+MW2]=mdn;
#else
		dest = apos( dest_row, rowstride, channels,k,M1+MW2);
		*dest = mdn;
#endif	    
	    /*
	    ** Calculate ltmdn
	    */
	    ltmdn=0;
	    for(i=0;i<mdn;i++) ltmdn+=hist[i];
	    
	    /* Calculate the median for the rest of this line */
	    for(l=M1+MW2+1;l<M2-MW2;l++)
	    {
	       /* Update histogram and calculate ltmdn */
	       for(i=0;i<NW;i++)
	       {
#ifdef	OBSOLETE	       
	          leftcol[i]=a_info->data_cm[k+i-NW2][l-MW2-1];
	          rightcol[i]=a_info->data_cm[k+i-NW2][l+MW2];
#else
			src = apos( src_row,rowstride,channels,k+i-NW2,l-MW2-1);
			leftcol[i] = *src;
			src = apos( src_row,rowstride,channels,k+i-NW2,l+MW2);
			rightcol[i] = *src;
#endif	          
	       }
	       for(i=0;i<NW;i++)
	       {
	          g=leftcol[i];
	          hist[g]--;
	          if(g<mdn) ltmdn--;
	          g=rightcol[i];
	          hist[g]++;
	          if(g<mdn) ltmdn++;
	       }
	       /* calculate the median */
	       if(ltmdn>NM2)
	       do
	       {
	          mdn--;
	          ltmdn-=hist[mdn];
	       } while(ltmdn>NM2);
	       else while(ltmdn+hist[mdn]<=NM2)
	          {
	             ltmdn+=hist[mdn];
	             mdn++;
	          }
#ifdef OBSOLETE	          
	       b_info->data_cm[k][l]=mdn;
#else
			dest = apos( dest_row, rowstride,channels,k,l);
			*dest = mdn;
#endif	       
	    }
	    ++k;
	 	}
	 	free(hist);
	 }
	 free(rightcol);
      }

      free(leftcol);
   }

   free(t);
}


if(NW<2)
{
	size=2*sizeof(long);
}
else
{
	size=NW*sizeof(long);
}



if(t=(long *)calloc(size,1))
{
 if(r=(long *)calloc(size,1))
 {
  if(s=(long *)calloc(size,1))
  {
   if(q=(long *)calloc(size,1))
   {
   	NW2=NW/2;
   	MW2=MW/2;

   	for(k=N1+NW2;k<N2-NW2;/*k++*/)
   	{
   	 for(l=M1+MW2;l<M2-MW2;l++)
   	 {
   	 	/* Compute median sub-filters	*/
   	 	for(j=0;j<NW/*MW*/;j++)
   	 	{
#ifdef	OBSOLETE   	 	
   	 		t[j]=a_info->data_cm[k][l+j-MW2];
   	 		s[j]=a_info->data_cm[k+j-NW2][l];
   	 		r[j]=a_info->data_cm[k-j+NW2][l-j+MW2];
   	 		q[j]=a_info->data_cm[k-j+NW2][l+j-MW2];
#else
			src = apos( src_row,rowstride,channels,k,l+j-MW2);
			t[j] = *src;
			src = apos( src_row, rowstride, channels, k+j-NW2, l );
			s[j] = *src;
			src = apos( src_row, rowstride, channels, k-j+NW2, l-j+MW2 );
			r[j] = *src;
			src = apos( src_row,rowstride,channels, k-j+NW2,l+j-MW2);
			q[j] = *src;
#endif
   	 		
   	 	}
   	 	
   	 	for(loop=0;loop<NW-1;loop++)
   	 	{
   	 	 for(loop1=loop+1;loop1<NW;loop1++)
   	 	 {
   	 	 	if(t[loop]>t[loop1])
   	 	 	{
   	 	 		tmp=t[loop];
   	 	 		t[loop]=t[loop1];
   	 	 		t[loop1]=tmp;
   	 	 	}

   	 	 	if(s[loop]>s[loop1])
   	 	 	{
   	 	 		tmp=s[loop];
   	 	 		s[loop]=s[loop1];
   	 	 		s[loop1]=tmp;
   	 	 	}

   	 	 	if(r[loop]>r[loop1])
   	 	 	{
   	 	 		tmp=r[loop];
   	 	 		r[loop]=r[loop1];
   	 	 		r[loop1]=tmp;
   	 	 	}

   	 	 	if(q[loop]>q[loop1])
   	 	 	{
   	 	 		tmp=q[loop];
   	 	 		q[loop]=q[loop1];
   	 	 		q[loop1]=tmp;
   	 	 	}
   	 	 }
   	 	}
			
		p[0]=t[NW2];
		p[1]=s[NW2];
		p[2]=r[NW2];
		p[3]=q[NW2];
#ifdef	OBSOLETE		
		p[4]=a_info->data_cm[k][l];
#else
		src = apos( src_row, rowstride,channels,k,l);
		p[4] = *src;
#endif							
   	 	for(loop=0;loop<NW-1;loop++)
   	 	{
   	 	 for(loop1=loop+1;loop1<NW;loop1++)
   	 	 {
   	 	 	if(p[loop]>p[loop1])
   	 	 	{
   	 	 		tmp=p[loop];
   	 	 		p[loop]=p[loop1];
   	 	 		p[loop1]=tmp;
   	 	 	}
   	 	 }
   	 	}
#ifdef	OBSOLETE   	 	
   	 	b_info->data_cm[k][l]=p[2];
#else
		dest = apos( dest_row, rowstride,channels,k,l);
		*dest = p[2];
#endif   	 	
	 }   	 	
	 ++k;
	}
  	free(q);
   }
   free(s);
  }
  free(r);
 }
 free(t);
}

return;    	
}

/* Agree, I don't like my coding style? either 	*/
/* Feel free to optimize this code!		*/





