#if !defined( lint ) && !defined( SABER )
static const char sccsid[] = "@(#)visual.c	4.06 97/10/15 xlockmore";

#endif

/*-
 * visual.c - separated out of utils.c for no good reason
 *
 * Copyright (c) 1991 by Patrick J. Naughton.
 *
 * Revision History:
 * 15-Oct-97: Separated out and modified.
 *
 */

#include "xlock.h"

#if defined(__cplusplus) || defined(c_plusplus)
#define CLASS c_class
#else
#define CLASS class
#endif

void
showVisualInfo(XVisualInfo * Vis)
{
	(void) fprintf(stderr, "Visual info: ");
	(void) fprintf(stderr, "screen %d, ", Vis->screen);
	(void) fprintf(stderr, "class %s, ", nameOfVisualClass(Vis->CLASS));
	(void) fprintf(stderr, "depth %d\n", Vis->depth);
}

extern perscreen Scr[MAXSCREENS];

Bool
fixedColors(ModeInfo * mi)
{

#ifdef FORCEFIXEDCOLORS
	/* pretending a fixed colourmap */
	return TRUE;
#else
	/* get information about the default visual */
	return (!((MI_NPIXELS(mi) > 2) &&
		  (MI_VISUALCLASS(mi) != StaticGray) &&
		  (MI_VISUALCLASS(mi) != StaticColor) &&
		  (MI_VISUALCLASS(mi) != TrueColor) &&
#if 0
/*-
 * This may fix wrong colors (possibly unreadable text) in password window
 */
		  !MI_WIN_IS_ICONIC(mi) &&
#endif
		  !MI_WIN_IS_INROOT(mi) &&
		  MI_WIN_IS_INSTALL(mi)));
#endif
}

static struct visual_class_name {
	int         visualclass;
	char       *name;
} VisualClassName[] = {

	{
		StaticGray, "StaticGray"
	},
	{
		GrayScale, "GrayScale"
	},
	{
		StaticColor, "StaticColor"
	},
	{
		PseudoColor, "PseudoColor"
	},
	{
		TrueColor, "TrueColor"
	},
	{
		DirectColor, "DirectColor"
	},
	{
		-1, NULL
	},
};

int
visualClassFromName(char *name)
{
	int         a;
	char       *s1, *s2;
	int         visualclass = -1;

	for (a = 0; VisualClassName[a].name; a++) {
		for (s1 = VisualClassName[a].name, s2 = name; *s1 && *s2; s1++, s2++)
			if ((isupper(*s1) ? tolower(*s1) : *s1) !=
			    (isupper(*s2) ? tolower(*s2) : *s2))
				break;

		if ((*s1 == '\0') || (*s2 == '\0')) {

			if (visualclass != -1) {
				(void) fprintf(stderr,
					       "%s does not uniquely describe a visual class (ignored)\n", name);
				return (-1);
			}
			visualclass = VisualClassName[a].visualclass;
		}
	}
	if (visualclass == -1)
		(void) fprintf(stderr, "%s is not a visual class (ignored)\n", name);
	return (visualclass);
}

char       *
nameOfVisualClass(int visualclass)
{
	int         a;

	for (a = 0; VisualClassName[a].name; a++)
		if (VisualClassName[a].visualclass == visualclass)
			return (VisualClassName[a].name);
	return ("[Unknown Visual Class]");
}

/*- 
 * setupColormap
 *
 * Create a read/write colourmap to use
 *
 */

Bool
setupColormap(ModeInfo * mi, int *colors, Bool * truecolor,
   unsigned long *redmask, unsigned long *bluemask, unsigned long *greenmask)
{
	/* how many colours are there altogether? */
	*colors = MI_NPIXELS(mi);
	if (*colors > MI_COLORMAPSIZE(mi)) {
		*colors = MI_COLORMAPSIZE(mi);
	}
	if (*colors < 2)
		*colors = 2;

	*truecolor = (MI_VISUALCLASS(mi) == TrueColor);

	*redmask = MI_REDMASK(mi);
	*greenmask = MI_GREENMASK(mi);
	*bluemask = MI_BLUEMASK(mi);

	return !fixedColors(mi);
}

#ifdef USE_GL

#include <GL/gl.h>
#include <GL/glx.h>

static GLXContext *glXContext = NULL;

/*-
 * NOTE WELL:  We _MUST_ destroy the glXContext between each mode
 * in random mode, otherwise OpenGL settings and paramaters from one
 * mode will affect the default initial state for the next mode.
 * BUT, we are going to keep the visual returned by glXChooseVisual,
 * because it will still be good (and because Mesa must keep track
 * of each one, even after XFree(), causing a small memory leak).
 */

XVisualInfo *
getGLVisual(Display * display, int screen, XVisualInfo * wantVis, int mono)
{
	if (wantVis) {
		/* Use glXGetConfig() to see if wantVis has what we need already. */
		int         depthBits, doubleBuffer;

		/* I don't check up on RGBA mode... we might want MONO */
		/* glXGetConfig(display, wantVis, GLX_RGBA, &rgbaMode); */

		glXGetConfig(display, wantVis, GLX_DEPTH_SIZE, &depthBits);
		glXGetConfig(display, wantVis, GLX_DOUBLEBUFFER, &doubleBuffer);

		if ((depthBits > 0) && doubleBuffer) {
			return wantVis;
		}
	}
	/* If wantVis is useless, try glXChooseVisual() */
	if (mono) {
		/* Monochrome display - use color index mode */
		int         attribList[] =
		{GLX_DOUBLEBUFFER, None};

		return glXChooseVisual(display, screen, attribList);
	} else {
		int         attribList[] =
#if 1
		{GLX_RGBA, GLX_RED_SIZE, 1, GLX_GREEN_SIZE, 1, GLX_BLUE_SIZE, 1,
		 GLX_DOUBLEBUFFER, GLX_DEPTH_SIZE, 1, None};

#else
		{GLX_RGBA, GLX_DOUBLEBUFFER, GLX_DEPTH_SIZE, 1, None};

#endif
		return glXChooseVisual(display, screen, attribList);
	}
}

/*-
 * The following function should be called on startup of any GL mode.
 * It returns a GLXContext for the calling mode to use with
 * glXMakeCurrent().
 */
GLXContext *
init_GL(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	int         screen = MI_SCREEN(mi);
  XVisualInfo xvi_in, *xvi_out;
  int         num_vis;
	GLboolean   rgbaMode;

	if (!glXContext) {
		glXContext = (GLXContext *) calloc(MAXSCREENS, sizeof (GLXContext));
		if (!glXContext)
			return NULL;
	}
	if (glXContext[screen]) {
		glXDestroyContext(display, glXContext[screen]);
		glXContext[screen] = NULL;
	}

  xvi_in.screen = screen;
  xvi_in.visualid = XVisualIDFromVisual(MI_VISUAL(mi));
  xvi_out = XGetVisualInfo (display, VisualScreenMask|VisualIDMask,
         &xvi_in, &num_vis);
  if (!xvi_out) {
		(void) fprintf(stderr, "Could not get XVisualInfo\n");
    return NULL;
  }

/*-
 * PURIFY 4.0.1 on SunOS4 and on Solaris 2 reports a 104 byte memory leak on
 * the next line each time that a GL mode is run in random mode when using
 * MesaGL 2.2.  This cumulative leak can cause xlock to eventually crash if
 * available memory is depleted.  This bug is fixed in MesaGL 2.3. */
	glXContext[screen] = glXCreateContext(display, xvi_out, 0, GL_TRUE);

  XFree((char *) xvi_out);

	if (!glXContext[screen]) {
		(void) fprintf(stderr, "GL could not create rendering context\n");
		return (NULL);
	}
/*-
 * PURIFY 4.0.1 on Solaris2 reports an uninitialized memory read on the next
 * line. PURIFY 4.0.1 on SunOS4 does not report this error. */
	if (!glXMakeCurrent(display, window, glXContext[screen])) {
		if (MI_WIN_IS_DEBUG(mi)) {
			(void) fprintf(stderr, "GLX error\n");
			(void) fprintf(stderr, "If using MesaGL, XGetWindowAttributes is\n");
			(void) fprintf(stderr, "probably returning a null colormap in\n");
			(void) fprintf(stderr, "XMesaCreateWindowBuffer in xmesa1.c .\n");
		}
		return (NULL);
	}
	/* True Color junk */
	glGetBooleanv(GL_RGBA_MODE, &rgbaMode);
	if (!rgbaMode) {
		glIndexi(MI_WIN_WHITE_PIXEL(mi));
		glClearIndex(MI_WIN_BLACK_PIXEL(mi));
	}
	return (&(glXContext[screen]));
}

void
FreeAllGL(Display * display)
{
	int         scr;

	if (glXContext) {
		for (scr = 0; scr < MAXSCREENS; scr++) {
			if (glXContext[scr]) {
				glXDestroyContext(display, glXContext[scr]);
				glXContext[scr] = NULL;
			}
		}
		(void) free((void *) glXContext);
		glXContext = NULL;
	}
}

#endif

/*- 
 * default_visual_info
 *
 * Gets a XVisualInfo structure that refers to a given visual or the default
 * visual.
 *
 * -      mi is the ModeInfo
 * -      visual is the visual to look up NULL => look up the default visual
 * -      default_info is set to point to the member of the returned list
 *          that corresponds to the default visual.
 *
 * Returns a list of XVisualInfo structures or NULL on failure. Free the list
 *   with XFree.
 */

#ifndef USE_GL
static int  depths[] =
{
	24, 16, 12, 8, 6, 4, 2
};

#define NUMDEPTHS (sizeof(depths)/sizeof(int))
#endif

extern Bool mono;
extern Bool verbose;

void
defaultVisualInfo(Display * display, int screen)
{
	XVisualInfo *info_list;

	/* get a complete list of visuals */
	/*info_list = XGetVisualInfo(display, VisualNoMask, NULL, &n); */
	XVisualInfo vTemplate;
	int         n;
	extern int  VisualClassWanted;

	vTemplate.screen = screen;
	vTemplate.depth = DisplayPlanes(display, screen);
	{
#if defined( USE_GL )		/* go with what init_GL found */
		XVisualInfo *wantVis;

		if (VisualClassWanted == -1) {

			wantVis = NULL;		/* NULL means use the default in getVisual() */

		} else {
   		vTemplate.CLASS = VisualClassWanted;
			wantVis = XGetVisualInfo(display,
			VisualScreenMask | VisualDepthMask | VisualClassMask,
						 &vTemplate, &n);

			if (n == 0) {
				/* Wanted visual not found so use default */
				wantVis = NULL;
			}
		}

		/* if User asked for color, try that first, then try mono */
		/* if User asked for mono.  Might fail on 16/24 bit displays,
		   so fall back on color, but keep the mono "look & feel". */
		if (!(info_list = getGLVisual(display, screen, wantVis, mono))) {
			if (!(info_list = getGLVisual(display, screen, wantVis, !mono))) {
				(void) fprintf(stderr, "GL can not render with root visual\n");
			}
		}
#else
		int         i, j;

		if (VisualClassWanted == -1) {
   		vTemplate.CLASS = DefaultVisual(display, screen)->CLASS;
		} else {
   		vTemplate.CLASS = VisualClassWanted;
		}
		info_list = XGetVisualInfo(display,
			VisualScreenMask | VisualDepthMask | VisualClassMask,
					   &vTemplate, &n);
		if (VisualClassWanted != -1 && n == 0) {
			/* Wanted visual not found so use default */
   		vTemplate.CLASS = DefaultVisual(display, screen)->CLASS;
			info_list = XGetVisualInfo(display,
			VisualScreenMask | VisualDepthMask | VisualClassMask,
						   &vTemplate, &n);
		}
/*-
  vTemplate.CLASS = VisualClassWanted;
	 if (VisualClassWanted == -1)
		info_list = XGetVisualInfo(display, VisualScreenMask | VisualDepthMask,
			&vTemplate, &n);
	 else
		 info_list = XGetVisUalInfo(display,
			 VisualScreenMask | VisualDepthMask | VisualClassMask,
			 &vTemplate, &n);
 */
		if ((info_list == NULL) || (n == 0)) {
			if (verbose)
				(void) fprintf(stderr, "Could not get any Visuals, numvisuals = %d.\n",
					       n);
			return;
		}
		if (VisualClassWanted == -1) {
			/* search through the list for the default visual */
			for (i = 0; i < n; i++, info_list++)
				if (info_list->visual == DefaultVisual(display, screen) &&
				    info_list->screen == screen)
					break;
		} else {
			for (j = 0; j < NUMDEPTHS; j++) {
				/* search through the list for the requested visual
				 * with the greatest color depth */
				for (i = 0; i < n; i++, info_list++) {
					if (info_list->depth >= depths[j] &&
					    info_list->screen == screen &&
							info_list->CLASS == VisualClassWanted)
						break;
				}
				if (i != n)
					break;
			}
			if (i == n) {
				for (i = 0; i < n; i++, info_list++)
					if (info_list->screen == screen &&
							info_list->CLASS == VisualClassWanted)
						break;
			}
		}
#endif
	}
	if (verbose) {
		showVisualInfo(info_list);
	}
	Scr[screen].depth = info_list->depth;
	Scr[screen].visual = info_list->visual;
	Scr[screen].visualclass = info_list->CLASS;
	Scr[screen].colormapsize = info_list->colormap_size;
	Scr[screen].redmask = info_list->red_mask;
	Scr[screen].greenmask = info_list->green_mask;
	Scr[screen].bluemask = info_list->blue_mask;
  XFree((char *) info_list);
}
