/* $Id: lib.h,v 1.11 1997/03/31 23:16:51 dps Exp $ */

#ifndef __word2x_lib_h__
#define __word2x_lib_h__
#include "tblock.h"
#include "interface.h"

typedef struct
{
    int wd[2];
    int dot_pos;
    int has_sign;
} num_info;

typedef enum { ALIGN_LEFT, ALIGN_CENTER, ALIGN_RIGHT, ALIGN_DP } align_t;
struct wd_info
{
    int width;
    int dp_col;
    int has_sign;
    align_t align;
};


#ifndef N
#define N(a) (sizeof(a)/sizeof(a[0]))
#endif

#ifndef __EXCLUDE_READER_CLASSES
extern void null_proc(const tok_seq::tok *, const docfmt *, FILE *, void *);
#endif
extern tblock *word_wrap(const char *, const char *,const char *, const int,
			 const int=0);
extern num_info scan_num(const char *);
extern tblock *__map_string(const char *, const cmap *, int);
#define map_string(a,b) __map_string(a, b, N(b));    
extern struct wd_info find_width(int, const char *const *);

/* Date formats */
#include <time.h>
extern char *uk_date(time_t);
extern char *us_date(time_t);

#endif /* __word2x_lib_h__ */
