/****************************************************************************
** $Id: qchkbox.h,v 2.3 1997/09/29 11:34:51 eiriken Exp $
**
** Definition of QCheckBox class
**
** Created : 940222
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.33.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QCHKBOX_H
#define QCHKBOX_H

#include "qbutton.h"


class QCheckBox : public QButton
{
    Q_OBJECT
public:
    QCheckBox( QWidget *parent=0, const char *name=0 );
    QCheckBox( const char *text, QWidget *parent, const char *name=0 );

    bool    isChecked() const;
    void    setChecked( bool check );

    QSize sizeHint() const;

protected:
    void    drawButton( QPainter * );
    void    drawButtonLabel( QPainter * );

private:	// Disabled copy constructor and operator=
    QCheckBox( const QCheckBox & ) {}
    QCheckBox &operator=( const QCheckBox & ) { return *this; }
};


inline bool QCheckBox::isChecked() const
{ return isOn(); }

inline void QCheckBox::setChecked( bool check )
{ setOn( check ); }


#endif // QCHKBOX_H
