/*
 * ProFTPD - ftpwho/ftpcount
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Shows "who" is online via proftpd.  Uses the /var/run/proftpd*
 * log files
 * $Id: ftpcount.c,v 1.6 1997/06/28 12:58:13 flood Exp $
 */

#include "conf.h"

char *idle_time(time_t *i)
{
  time_t now;
  long l;
  static char sbuf[7];

  if(!i || !*i)
    return "-";
  else {
    time(&now);
    l = now - *i;

    if(l < 3600) 
      sprintf(sbuf,"%ldm%lds",(l / 60),(l % 60));
    else
      sprintf(sbuf,"%ldh%ldm",(l / 3600),
      ((l - (l / 3600) * 3600) / 60));
  }

  return sbuf;
}

int main(int argc, char **argv)
{
  logrun_t *l;
  pid_t oldpid = 0,mpid;
  int c = 0,tot = 0;

  char *cp,*progname = *argv;

  if((cp = rindex(progname,'/')) != NULL)
    progname = cp+1;

  while((l = log_read_run(&mpid)) != NULL) {
    if(errno)
      break;

    if(!c++ || oldpid != mpid) {
      if(tot)
        printf("   -  %d users\n\n",tot);
      if(!mpid)
        printf("inetd FTP connections:\n");
      else
        printf("Master proftpd process %d:\n",(int)mpid);
      oldpid = mpid; tot = 0;
    }

    if(!strcmp(progname,"ftpwho"))
      printf("%5d %-6s %s\n",(int)l->pid,idle_time(&l->idle_since),l->op);
    tot++;
  }
  if(tot)
    printf("   -  -      %d users\n\n",tot);
  return 0;
}

