/* Copyright (C) 1979-1997 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Convert tables between different charactersets */


#include <global.h>
#include "mysql_priv.h"

/****************************************************************************
** Convert tables
****************************************************************************/

/* CP1251->koi8 and back conversion * Alex Povolotaky <tarkhil@aha.ru> */

static unsigned char win2koitab[256] = {
0,
1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,
17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,
97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,
113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
161,162,165,163,168,179,169,170,180,171,172,173,174,175,183,176,
177,178,182,166,181,184,185,164,186,187,188,189,190,167,191,225,
226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,242,
243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,193,
194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,210,
211,212,213,198,200,195,222,219,221,223,217,216,220,192,209
};

static unsigned char koi2wintab[256] = {
0,
1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,
17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,
97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,
113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
161,162,168,186,165,179,191,168,169,170,171,172,173,174,175,176,
177,178,168,170,181,178,175,184,185,186,187,188,189,190,191,254,
224,225,246,228,229,244,227,245,232,233,234,235,236,237,238,239,
255,240,241,242,243,230,226,252,251,231,248,253,249,247,250,222,
192,193,214,196,197,212,195,213,200,201,202,203,204,205,206,207,
223,208,209,210,211,198,194,220,219,199,216,221,217,215,218
};

/****************************************************************************
** Declare mapping variables
****************************************************************************/


CONVERT conv_win2koi("cp1251_koi8", win2koitab, koi2wintab);

CONVERT *convert_tables[]= {
  &conv_win2koi,
  NULL
};


CONVERT *get_convert_set(const char *name)
{
  for (CONVERT **ptr=convert_tables ; *ptr ; ptr++)
  {
    if (!my_strcasecmp((*ptr)->name,name))
      return (*ptr);
  }
  return 0;
}


void CONVERT::convert_array(const uchar *map, uchar * buf, uint len)
{
  for (uchar *end=buf+len ; buf != end ; buf++)
    *buf= map[*buf];
}


/* This is identical as net_store_data, but with a conversion */

bool CONVERT::store(String *packet,const char *from,uint length)
{
  uint packet_length=packet->length();
  if (packet_length+5+length > packet->alloced_length() &&
      packet->realloc(packet_length+5+length))
    return 1;
  char *to=(char*) net_store_length((byte*) packet->ptr()+packet_length,
				    (ulong) length);

  for (const char *end=from+length ; from != end ; from++)
    *to++= to_map[(uchar) *from];
  packet->length((uint) (to-packet->ptr()));
  return 0;
}
