/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

enum
{
  DT_BOOL, /* boolean option */
  DT_NUM,  /* a number */
  DT_STR,  /* a string */
  DT_PATH, /* a pathname */
  DT_QUAD, /* quad-option (yes/no/ask-yes/ask-no) */
  DT_SORT, /* sorting methods */
  DT_RX,   /* regular expressions */
  DT_MAGIC /* mailbox type */
};

/* flags to parse_set() */
#define M_SET_INV	1	/* default is to invert all vars */
#define M_SET_UNSET	2	/* default is to unset all vars */

struct option_t
{
  char *option;
  short type;
  short bit;   /* DT_BOOL and DT_QUAD only */
  short redraw;
  void *data;
  size_t size; /* DT_STR and DT_PATH */
};

#define S_DECL(x) x,sizeof(x)

struct option_t MuttVars[] = {
  { "abort_nosubject",	DT_QUAD, OPT_SUBJECT,	R_NONE, NULL,	0 },
  { "abort_unmodified",	DT_QUAD, OPT_ABORT,	R_NONE, NULL,	0 },
  { "alias_file",	DT_PATH, 0,		R_NONE, S_DECL(AliasFile) },
  { "allow_8bit",	DT_BOOL, OPTALLOW8BIT,	R_NONE, NULL,	0 },
  { "alternates",	DT_RX,	 0,		R_BOTH, &Alternates },
  { "arrow_cursor",	DT_BOOL, OPTARROWCURSOR,	R_BOTH, NULL,	0 },
  { "ascii_chars",	DT_BOOL, OPTASCIICHARS,	R_BOTH, NULL,	0 },
  { "askbcc",		DT_BOOL, OPTASKBCC,	R_NONE, NULL,	0 },
  { "askcc",		DT_BOOL, OPTASKCC,	R_NONE, NULL,	0 },
  { "attach_split",	DT_BOOL, OPTATTACHSPLIT,	R_NONE, NULL,	0 },
  { "attach_sep",	DT_STR,	 0,		R_NONE, S_DECL(AttachSep) },
  { "attribution",	DT_STR,	 0,		R_NONE, S_DECL(Attribution) },
  { "autoedit",		DT_BOOL, OPTAUTOEDIT,	R_NONE, NULL,	0 },
  { "auto_tag",		DT_BOOL, OPTAUTOTAG,	R_NONE, NULL,	0 },
  { "beep",		DT_BOOL, OPTBEEP,	R_NONE, NULL,	0 },
  { "charset",		DT_STR,	 0,		R_NONE, S_DECL(Charset) },
  { "check_new",	DT_BOOL, OPTCHECKNEW,	R_NONE, NULL,	0 },
  { "confirmappend",	DT_BOOL, OPTCONFIRMAPPEND, R_NONE, NULL,	0 },
  { "confirmcreate",	DT_BOOL, OPTCONFIRMCREATE, R_NONE, NULL,	0 },
  { "copy",		DT_QUAD, OPT_COPY,	R_NONE, NULL,	0 },
  { "date_format",	DT_STR,	 0,		R_BOTH, S_DECL(DateFmt) },
  { "decode_format",	DT_STR,	 0,		R_NONE, S_DECL(DecodeFmt) },
  { "delete",		DT_QUAD, OPT_DELETE,	R_NONE, NULL,	0 },
  { "dsn_notify",	DT_STR,	 0,		R_NONE, S_DECL (DsnNotify) },
  { "dsn_return",	DT_STR,	 0,		R_NONE, S_DECL (DsnReturn) },
  { "edit_hdrs",	DT_BOOL, OPTEDITHDRS,	R_NONE, NULL,	0 },
  { "editor",		DT_PATH, 0,		R_NONE, S_DECL(Editor) },
  { "escape",		DT_STR,	 0,		R_NONE, S_DECL(EscChar) },
  { "fast_reply",	DT_BOOL, OPTFASTREPLY,	R_NONE, NULL,	0 },
  { "fcc_attach",	DT_BOOL, OPTFCCATTACH,	R_NONE, NULL,	0 },
  { "folder",		DT_PATH, 0,		R_NONE, S_DECL(Maildir) },
  { "force_name",	DT_BOOL, OPTFORCENAME,	R_NONE, NULL,	0 },
  { "forw_decode",	DT_BOOL, OPTFORWDECODE,	R_NONE, NULL,	0 },
  { "forw_format",	DT_STR,	 0,		R_NONE, S_DECL(ForwFmt) },
  { "hdr_format",	DT_STR,	 0,		R_BOTH, S_DECL(HdrFmt) },
  { "hdrs",		DT_BOOL, OPTHDRS,	R_NONE, NULL,	0 },
  { "header",		DT_BOOL, OPTHEADER,	R_NONE, NULL,	0 },
  { "help",		DT_BOOL, OPTHELP,	R_BOTH, NULL,	0 },
  { "history",		DT_NUM,	 0,		R_NONE, &HistSize },
  { "hold",		DT_BOOL, OPTHOLD,	R_NONE, NULL,	0 },
  { "hostname",		DT_STR,	 0,		R_NONE, S_DECL(Fqdn) },
  { "in_reply_to",	DT_STR,	 0,		R_NONE, S_DECL(InReplyTo) },
  { "include",		DT_QUAD, OPT_INCLUDE,	R_NONE, NULL,	0 },
  { "indent_str",	DT_STR,	 0,		R_NONE, S_DECL(Prefix) },
  { "ignore_list_reply_to",	DT_BOOL, OPTIGNORELISTREPLYTO,	R_NONE, NULL,	0 },
  { "ispell",		DT_PATH, 0,		R_NONE, S_DECL(Ispell) },
  { "local_sig",	DT_PATH, 0,		R_NONE, S_DECL(LocalSig) },
  { "local_site",	DT_RX,   0,		R_NONE, &Localsites },
  { "locale",		DT_STR,  0,		R_BOTH, S_DECL(Locale) },
  { "mailcap_path",	DT_STR,	 0,		R_NONE, S_DECL(MailcapPath) },
  { "mark_old",		DT_BOOL, OPTMARKOLD,	R_BOTH, NULL,	0 },
  { "markers",		DT_BOOL, OPTMARKERS,	R_PAGER, NULL,	0 },
  { "mask",		DT_RX,	 0,		R_NONE, &Mask },
  { "mbox",		DT_PATH, 0,		R_BOTH, S_DECL(Inbox) },
  { "mbox_type",	DT_MAGIC,0,		R_NONE, &DefaultMagic },
  { "metoo",		DT_BOOL, OPTMETOO,	R_NONE, NULL,	0 },
  { "mime_fwd",		DT_BOOL, OPTMIMEFWD,	R_NONE, NULL,	0 },
  { "move",		DT_QUAD, OPT_MOVE,	R_NONE, NULL,	0 },
  { "msg_format",	DT_STR,	 0,		R_NONE, S_DECL(MsgFmt) },
  { "pager",		DT_PATH, 0,		R_NONE, S_DECL(Pager) },
  { "pager_context",	DT_NUM,	 0,		R_NONE, &PagerContext },
  { "pager_format",	DT_STR,	 0,		R_PAGER, S_DECL(PagerFmt) },
  { "pager_index_lines",DT_NUM,	 0,		R_PAGER, &PagerIndexLines },
  { "pager_stop",	DT_BOOL, OPTPAGERSTOP,	R_NONE, NULL,	0 },
#ifdef _PGPPATH
  { "pgp",		DT_PATH, 0,		R_NONE, S_DECL(Pgp) },
  { "pgp_autosign",	DT_BOOL, OPTPGPAUTOSIGN, R_NONE, NULL,	0 },
  { "pgp_autoencrypt",	DT_BOOL, OPTPGPAUTOENCRYPT, R_NONE, NULL, 0},
  { "pgp_encryptself",	DT_BOOL, OPTPGPENCRYPTSELF, R_NONE, NULL,	0 },
  { "pgp_replyencrypt",	DT_BOOL, OPTPGPREPLYENCRYPT, R_NONE, NULL,0 },
  { "pgp_replysign",	DT_BOOL, OPTPGPREPLYSIGN, R_NONE, NULL,	0 },
  { "pgp_sign_as",	DT_STR,	 0,		R_NONE, S_DECL(PgpSignAs) },
  { "pgp_strict_enc",	DT_BOOL, OPTPGPSTRICTENC, R_NONE, NULL,	0 },
  { "pgp_timeout",	DT_NUM,	 0,		R_NONE, &PgpTimeout },
#endif /* _PGPPATH */
  { "pipe_split",	DT_BOOL, OPTPIPESPLIT,	R_NONE, NULL,	0 },
  { "pipe_decode",	DT_BOOL, OPTPIPEDECODE,	R_NONE, NULL,	0 },
  { "pipe_sep",		DT_STR,	 0,		R_NONE, S_DECL(PipeSep) },
  { "point_new",	DT_BOOL, OPTPOINTNEW,	R_NONE, NULL,	0 },
#ifdef USE_POP
  { "pop_delete",	DT_BOOL, OPTPOPDELETE,	R_NONE, NULL,	0 },
  { "pop_host",		DT_STR,	 0,		R_NONE, S_DECL(PopHost) },
  { "pop_port",		DT_NUM,	 0,		R_NONE, &PopPort },
  { "pop_pass",		DT_STR,	 0,		R_NONE, S_DECL(PopPass) },
  { "pop_user",		DT_STR,	 0,		R_NONE, S_DECL(PopUser) },
#endif /* USE_POP */
  { "post_indent_str",	DT_STR,	 0,		R_NONE, S_DECL(PostIndentString) },
  { "postpone",		DT_QUAD, OPT_POSTPONE,	R_NONE, NULL,	0 },
  { "postponed",	DT_PATH, 0,		R_NONE, S_DECL(Postponed) },
  { "print",		DT_QUAD, OPT_PRINT,	R_NONE, NULL,	0 },
  { "print_cmd",	DT_PATH, 0,		R_NONE, S_DECL(PrintCmd) },
  { "prompt_after",	DT_BOOL, OPTPROMPTAFTER, R_NONE, NULL,	0 },
  { "quote_regexp",	DT_RX,	 0,		R_PAGER, &QuoteRegexp },
  { "reply_regexp",	DT_RX,	 0,		R_INDEX, &ReplyRegexp },
  { "read_inc",		DT_NUM,	 0,		R_NONE, &ReadInc },
  { "read_only",	DT_BOOL, OPTREADONLY,	R_NONE, NULL,	0 },
  { "realname",		DT_STR,	 0,		R_BOTH, S_DECL(Realname) },
  { "recall",		DT_QUAD, OPT_RECALL,	R_NONE, NULL,	0 },
  { "record",		DT_PATH, 0,		R_NONE, S_DECL(Outbox) },
  { "references",	DT_NUM,	 0,		R_NONE, &TrimRef },
  { "remote_sig",	DT_PATH, 0,		R_NONE, S_DECL(RemoteSig) },
  { "reply_to",		DT_QUAD, OPT_REPLYTO,	R_NONE, NULL,	0 },
  { "resolve",		DT_BOOL, OPTRESOLVE,	R_NONE, NULL,	0 },
  { "reverse_alias",	DT_BOOL, OPTREVALIAS,	R_BOTH, NULL,	0 },
  { "reverse_name",	DT_BOOL, OPTREVNAME,	R_BOTH, NULL,	0 },
  { "save_address",	DT_BOOL, OPTSAVEADDRESS,	R_NONE, NULL, 0 },
  { "save_empty",	DT_BOOL, OPTSAVEEMPTY,	R_NONE, NULL,	0 },
  { "save_name",	DT_BOOL, OPTSAVENAME,	R_NONE, NULL,	0 },
  { "sendmail",		DT_PATH, 0,		R_NONE, S_DECL(Sendmail) },
  { "sendmail_bounce",	DT_PATH, 0,		R_NONE, S_DECL(SendmailBounce) },
  { "shell",		DT_PATH, 0,		R_NONE, S_DECL(Shell) },
  { "sig_dashes",	DT_BOOL, OPTSIGDASHES,	R_NONE, NULL,	0 },
  { "signature",	DT_PATH, 0,		R_NONE, S_DECL(Signature) },
  { "simple_search",	DT_STR,	 0,		R_NONE, S_DECL (SimpleSearch) },
  { "smart_wrap",	DT_BOOL, OPTWRAP,	R_PAGER, NULL, 0 },
  { "sort",		DT_SORT, 0,		R_INDEX, &Sort,	0 },
  { "sort_aux",		DT_SORT, 0,		R_INDEX, &SortAux, 0 },
  { "sort_browser",	DT_SORT, 0,		R_NONE, &BrowserSort, 0 },
  { "sort_re",		DT_BOOL, OPTSORTRE,	R_NONE, NULL, 0 },
  { "spoolfile",	DT_PATH, 0,		R_NONE, S_DECL(Spoolfile) },
  { "status_chars",	DT_STR,	 0,		R_BOTH, S_DECL(StChars) },
  { "status_format",	DT_STR,	 0,		R_BOTH, S_DECL(Status) },
  { "status_on_top",	DT_BOOL, OPTSTATUSONTOP,	R_BOTH, NULL, 0 },
  { "strict_threads",	DT_BOOL, OPTSTRICTTHREADS, R_INDEX, NULL,	0 },
  { "suspend",		DT_BOOL, OPTSUSPEND,	R_NONE,	NULL,	0 },
  { "thorough_search",	DT_BOOL, OPTTHOROUGHSRC, R_NONE, NULL,	0 },
  { "tilde",		DT_BOOL, OPTTILDE,	R_PAGER, NULL,	0 },
  { "timeout",		DT_NUM,	 0,		R_NONE, &Timeout },
  { "tmpdir",		DT_PATH, 0,		R_NONE, S_DECL(Tempdir) },
  { "to_chars",		DT_STR,	 0,		R_BOTH, S_DECL(Tochars) },
  { "url_regexp",	DT_RX,	 0,		R_NONE, &UrlRegexp },
  { "use_8bitmime",	DT_BOOL, OPTUSE8BITMIME,R_NONE,	NULL,	0 },
  { "use_domain",	DT_BOOL, OPTUSEDOMAIN,	R_NONE, NULL,	0 },
  { "use_from",		DT_BOOL, OPTUSEFROM,	R_NONE, NULL,	0 },
  { "use_mailcap",	DT_QUAD, OPT_USEMAILCAP, R_NONE, NULL,	0 },
#ifdef _PGPPATH
  { "verify_sig",	DT_QUAD, OPT_VERIFYSIG,	R_NONE, NULL,	0 },
#endif /* _PGPPATH */
  { "visual",		DT_PATH, 0,		R_NONE, S_DECL(Visual) },
  { "wait_key",		DT_BOOL, OPTWAITKEY,	R_NONE, NULL,	0 },
  { "web_browser",	DT_PATH, 0,		R_NONE, S_DECL(WebBrowser) },
  { "write_inc",	DT_NUM,	 0,		R_NONE, &WriteInc },
  { NULL,		0,	 0,		R_NONE, NULL,	0 }
};

const struct mapping_t SortMethods[] = {
  { "date",		SORT_DATE },
  { "date-sent",	SORT_DATE },
  { "date-received",	SORT_RECEIVED },
  { "mailbox-order",	SORT_ORDER },
  { "subject",		SORT_SUBJECT },
  { "alpha",		SORT_SUBJECT }, /* alphabetic sort */
  { "from",		SORT_FROM },
  { "size",		SORT_SIZE },
  { "threads",		SORT_THREADS },
  { NULL,		0 }
};

/* functions used to parse commands in a rc file */

static int parse_list (const char *, void *, char *, size_t);
static int parse_unlist (const char *, void *, char *, size_t);
static int parse_alias (const char *, void *, char *, size_t);
static int parse_unalias (const char *, void *, char *, size_t);
static int parse_ignore (const char *, void *, char *, size_t);
static int parse_unignore (const char *, void *, char *, size_t);
static int parse_source (const char *, void *, char *, size_t);
static int parse_set (const char *, void *, char *, size_t);
static int parse_my_hdr (const char *, void *, char *, size_t);
static int parse_unmy_hdr (const char *, void *, char *, size_t);

struct command_t
{
  char *name;
  int (*func) (const char *, void *, char *, size_t);
  void *data;
};

struct command_t Commands[] = {
  { "alias",		parse_alias,		NULL },
  { "auto_view",	parse_list,		&AutoViewList },
  { "bind",		mutt_parse_bind,	NULL },
#ifdef HAVE_COLOR
  { "color",		mutt_parse_color,	NULL },
#endif
  { "fcc-hook",		mutt_parse_hook,	(void *) M_FCCHOOK },
  { "folder-hook",	mutt_parse_hook,	(void *) M_FOLDERHOOK },
  { "hdr_order",	parse_list,		&HeaderOrderList },
  { "ignore",		parse_ignore,		NULL },
  { "lists",		parse_list,		&MailLists },
  { "macro",		mutt_parse_macro,	NULL },
  { "mailboxes",	mutt_parse_mailboxes,	NULL },
  { "mbox-hook",	mutt_parse_hook,	(void *) M_MBOXHOOK },
  { "mono",		mutt_parse_mono,	NULL },
  { "my_hdr",		parse_my_hdr,		NULL },
  { "push",		mutt_parse_push,	NULL },
  { "save-hook",	mutt_parse_hook,	(void *) M_SAVEHOOK },
  { "send-hook",	mutt_parse_hook,	(void *) M_SENDHOOK },
  { "set",		parse_set,		NULL },
  { "source",		parse_source,		NULL },
  { "toggle",		parse_set,		(void *) M_SET_INV },
  { "unalias",		parse_unalias,		NULL },
  { "unignore",		parse_unignore,		NULL },
  { "unlists",		parse_unlist,		&MailLists },
  { "unmy_hdr",		parse_unmy_hdr,		NULL },
  { "unset",		parse_set,		(void *) M_SET_UNSET },
  { NULL,		NULL,			NULL }
};
