//   -*- mode: c++; -*-
#include <String.h>
#include <Regex.h>
#include <iostream.h>
#include <fstream.h>
#include <vector.h>

#define MAX_LINE 1024  //this isn't actually used by adString 

class parsestream;
class parseinfo{
public:
  vector<int> lineno;
  String buffer;
  int pos;
  vector<String> fname;
public:
  int    linenumber(){return lineno[lineno.size()-1];}
  void set_linenumber(int l){
    lineno[lineno.size()-1]=l;
  }
  String filename(){  
    return fname [fname.size()-1];
  }
  void set_filename(const String &s){
    fname[fname.size()-1]=s;
  }
};
class parseerror:public parseinfo{
public:
  parseerror(parsestream *p);
  void report(ostream &o);
  virtual const char *errormsg()=NULL;
};
class endoffile:public parseerror{
public:
  endoffile(parsestream *p):parseerror(p){};
  const char *errormsg(){return "Unexpected end of file";}
};
class endofline: public parseerror{
public:
  endofline(parsestream *p):parseerror(p){};
  const char *errormsg(){return "Unexpected end of line";}
};
class ident_expected:public parseerror{
public:
  ident_expected(parsestream *p):parseerror(p){};
  const char *errormsg(){return "Identifier expected";}
};
class char_expected:public parseerror{
public:
  char c;
  char_expected(parsestream *p,char ch):parseerror(p){
    c=ch;
  };
  const char *errormsg(){
    static char err[]="\".\" expected";
    err[1]=c;
    return err;
  }
};
class char_unexpected:public parseerror{ //an unexpected char occured
public:
  char c;
  char_unexpected(parsestream *p,char ch):parseerror(p){
    c=ch; 
  };
  const char *errormsg(){return  "Unexpected character";}
};  
class ferror_open:public parseerror{
public:
  ferror_open(parsestream *p):parseerror(p){};
  const char *errormsg(){return "Unable to open file";}
};

class parsestream:public parseinfo{
  vector<istream *> i;
  bool in_constructor;
  void new_line();
  void preprocess(String &s);
  istream *current_istr(){return i[i.size()-1];};
  void close_file();
  void new_file(const String &s);
public:
  init(istream &in){
    i.push_back(&in); 
    lineno.push_back(0);
    fname.push_back("");
    if(!in||!in.good())
      throw ferror_open(this);
    new_line();
  }
  parsestream(istream &in){
    in_constructor=true;
    init(in);
    filename()="(probably) stdin";
    in_constructor=false;
  };
  parsestream(const String &s){
    ifstream *f=new ifstream(s);
    in_constructor=true;
    init(*f);
    if(fname.size())
      fname[fname.size()-1]=s;
    in_constructor=false;
  };
  ~parsestream(){
    //delete i;
  };
  bool good(){
    return i.size()&&current_istr() && (*current_istr());
  };
  char get_char();
  char put_back(char);
  String get_name();
  String get_name(const Regex &);
  String get_Stringconst();
  String get_eq_name();
  String get_eq_Stringconst();
  String get_line();
  void skip_line();
  void skip_space();
  void skip_char(char expect);
  //int linenumber(){return linenumber();};
  //String filename(){return fname;};
};

extern String rmtrailingspace(String &s);
extern String escape_doublequotes(const String &s);
extern String escape_String(const String &s, const String &esc);
extern String escapewith_String(const String &s, 
				const String &esc, 
				const String &with);
extern String tolower_String(const String &s);
extern String toupper_String(const String &s);
extern String replacewith_String(const String &s, 
				 const String &replace, 
				 const String &with);
extern String cppesc_String(const String &s);
extern String replace(String s,char match, char replace);
extern int Stringtoi(const String &s);
extern String itoString(int i);
extern String itohexString(int i);
extern String sort_hotkey(String s);
extern String String_parent(String s);

