/*
 * window.h: header file for window.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: window.h,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _WINDOW_H_
#define _WINDOW_H_
#define IN_WINDOW_H

struct WindowStru; /*XXXX*/

#include "irc_std.h"

#include "edit.h"
#include "hold.h"
#include "lastlog.h"
#include "menu.h"

/*
 * Define this if you want to play with the new window feature, 
 * CREATE, that allows you to start new iscreen or xterm windows
 * connected to the ircII client.
 */
#define	WINDOW_CREATE

#ifdef M_UNIX
#undef WINDOW_CREATE
#endif /* M_UNIX */

/*
 * Define this if you want ircII to scroll after printing a line,
 * like it used to (2.1.5 and back era), not before printing the line.  
 * Thanks to Veggen for telling me what to do for this.
 */
#undef SCROLL_AFTER_DISPLAY

/* used by the update flag to determine what needs updating */
#define REDRAW_DISPLAY_FULL 1
#define REDRAW_DISPLAY_FAST 2
#define UPDATE_STATUS 4
#define REDRAW_STATUS 8

struct	WindowMenuTag
{
	Menu	*menu;
	int	lines;
	int	items_per_line;
	int	cursor;
};

typedef	struct	WindowMenuTag	WindowMenu;

/* NickList: structure for the list of nicknames of people on a channel */
typedef struct nick_stru
{
	struct	nick_stru	*next;	/* pointer to next nickname entry */
	char	*nick;			/* nickname of person on channel */
	int	chanop;			/* True if the given nick has chanop */
}	NickList;

typedef	struct	DisplayStru
{
	char	*line;
	int	linetype;
	struct	DisplayStru	*next;
}	Display;

#define	LT_UNLOGGED	0
#define	LT_LOGHEAD	1
#define	LT_LOGTAIL	2

struct	ScreenStru;	/* ooh! */

typedef	struct	WindowStru
{
	unsigned int	refnum;		/* the unique reference number,
					 * assigned by IRCII */
	char	*name;			/* window's logical name */
	int	server;			/* server index */
	int	top;			/* The top line of the window, screen
					 * coordinates */
	int	bottom;			/* The botton line of the window, screen
					 * coordinates */
	int	cursor;			/* The cursor position in the window, window
					 * relative coordinates */
	int	line_cnt;		/* counter of number of lines displayed in
					 * window */
	int	scroll;			/* true, window scrolls... false window wraps */
	int	display_size;		/* number of lines of window - menu lines */
	int	old_size;		/* if new_size != display_size,
					 * resize_display is called */
	int	visible;		/* true, window is drawn... false window is
					 * hidden */
	int	update;			/* window needs updating flag */
	unsigned miscflags;		/* Miscellaneous flags. */
	int	beep_always;		/* Beep even when hidden */

	char	*prompt;		/* A prompt string, usually set by EXEC'd process */
	char	*status_line[2];	/* The status line string */
	int	double_status;		/* Whether to display the 2nd status */

	Display	*top_of_display,	/* Pointer to first line of display structure */
		*display_ip;		/* Pointer to insertiong point of display
					 * structure */

	char	*current_channel;	/* Window's current channel */
        char    *waiting_channel;       /* The channel that you _want_ to be on
                                         * this window .. derived from a real
                                         * fix for the phone bug */
        char    *bind_channel;          /* the window's bound channel */
	char	*query_nick;		/* User being QUERY'ied in this window */
	NickList	*nicks;		/* List of nicks that will go to window */
	int	window_level;		/* The LEVEL of the window, determines what
					 * messages go to it */

	/* hold stuff */
	int	hold_mode;		/* true, hold mode is on for window...
					 * false it isn't */
	int	hold_on_next_rite;	/* true, the next call to rite() will
					 * activate a hold */
	int	held;			/* true, the window is currently being
					 * held */
	int	last_held;		/* Previous value of hold flag.  Used
					 * for various updating needs */
	Hold	*hold_head,		/* Pointer to first entry in hold
					 * list */
		*hold_tail;		/* Pointer to last entry in hold list */
	int	held_lines;		/* number of lines being held */
	int	scrolled_lines;		/* number of lines scrolled back */
	int	new_scrolled_lines;	/* number of lines since scroll back
					 * keys where pressed */
	WindowMenu	menu;		/* The menu (if any) */

	/* lastlog stuff */
	Lastlog	*lastlog_head;		/* pointer to top of lastlog list */
	Lastlog	*lastlog_tail;		/* pointer to bottom of lastlog list */
	int	lastlog_level;		/* The LASTLOG_LEVEL, determines what
					 * messages go to lastlog */
	int	lastlog_size;		/* Max number of messages for the window
					 * lastlog */

	int	notify_level;		/* the notify level.. */
	char	*logfile;		/* window's logfile name */
	/* window log stuff */
	int	log;			/* true, file logging for window is on */
	FILE	*log_fp;		/* file pointer for the log file */

	struct	ScreenStru	*screen;

	struct	WindowStru	*next;	/* pointer to next entry in window list (null
					 * is end) */
	struct	WindowStru	*prev;	/* pointer to previous entry in window list
					 * (null is end) */
}	Window;

/*
 * WindowStack: The structure for the POP, PUSH, and STACK functions. A
 * simple linked list with window refnums as the data 
 */
typedef	struct	window_stack_stru
{
	unsigned int	refnum;
	struct	window_stack_stru	*next;
}	WindowStack;

extern	Window	*to_window;

extern	Window	*invisible_list;
extern	char	underline;
extern	int	who_level;
extern	char	*who_from;
extern	int	in_window_command;

typedef	struct
{
	int	top;
	int	bottom;
	int	position;
}	ShrinkInfo;

extern	void	set_scroll_lines _((int));
extern	void	set_scroll _((int));
extern	void	reset_line_cnt _((int));
extern	void	set_continued_line _((char *));
extern	void	set_underline_video _((int));
extern	int	rite _((Window *, char *, int, int, int, int));
extern	void	erase_display _((Window *));
extern	ShrinkInfo	resize_display _((Window *));
extern	void	redraw_all_windows _((void));
extern	void	add_to_screen _((char *));
extern	int	unhold_windows _((void));
extern	Window	*traverse_all_windows _((int *));
extern	void	add_to_invisible_list _((Window *));
extern	void	delete_window _((Window *));

/* var_settings indexes */
#define OFF 0
#define ON 1
#define TOGGLE 2

extern	Window	*add_to_window_list _((Window *));
extern	void	erase_display _((Window *));
extern	void	set_scroll _((int));
extern	void	set_menu _((char *));
extern	void	set_scroll_lines _((int));
extern	void	update_all_status _((void));
extern	void	set_query_nick _((char *));
extern	char	*query_nick _((void));
extern	void	update_window_status _((Window *, int));
extern	void	window _((char *, char *, char *));
extern	void	redraw_window _((Window *, int));
extern	void	redraw_all_windows _((void));
extern	void	next_window _((char, char *));
extern	void	swap_last_window _((char, char *));
extern	void	swap_next_window _((char, char *));
extern	void	previous_window _((char, char *));
extern	void	swap_previous_window _((char, char *));
extern	void	unstop_all_windows _((char, char *));
extern	void	back_window _((void));
extern	void	window_kill_swap _((void));
extern	int	is_current_channel _((char *, char));
extern	void	redraw_all_status _((void));
extern	void	message_to _((u_int));
extern	void	message_from _((char *, int));
extern	int	get_visible_by_refnum _((char *));
extern	unsigned int	window_display;

extern	int	is_main_screen _((struct ScreenStru *));
extern	void	kill_screen _((struct ScreenStru *));

extern	void	set_prompt_by_refnum _((u_int, char *));
extern	int	number_of_windows _((void));
extern	void	clear_window_by_refnum _((u_int));
extern	unsigned int	current_refnum _((void));
extern	Window	*get_window_by_refnum _((u_int));
extern	char	*get_target_by_refnum _((u_int));
extern	char	*get_prompt_by_refnum _((u_int));
extern	char	*set_channel_by_refnum _((unsigned int, char *));
extern	char	*get_channel_by_refnum _((u_int));
extern	void	set_window_server _((int, int, int));
extern	Window	*get_window_by_name _((char *));
extern	void	window_redirect _((char *, int));
extern	int	get_window_server _((unsigned int));
extern	int	message_from_level _((int));
extern	void	restore_message_from _((void));
extern	void	save_message_from _((void));
extern	void	window_check_servers _((void));
extern	void	set_current_window _((Window *));
extern	void	set_level_by_refnum _((u_int, int));
extern  int     is_bound _((char *, int));
extern  void    unbind_channel _((char *, int));
extern  char    *get_bound_channel _((Window *));

extern	int	is_bound_to_window _((Window *, char *));
extern	int	is_bound_anywhere _((char *));

#define WINDOW_NOTIFY	((unsigned) 0x0001)
#define WINDOW_NOTIFIED	((unsigned) 0x0002)

#undef IN_WINDOW_H
#endif /* _WINDOW_H_ */
