;; hilit-LaTeX.el V1.05
;; Enhancements for LaTeX highlighting using hilit19.el or hl319.el
;;
;; Author: Peter Galbraith (rhogee@bathybius.meteo.mcgill.ca)
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; V1.00 01Mar94 PSG - Created
;; V1.01 14Mar94 PSG - Added {\sc } 
;;                   - Added fix for \[ ]\ excluding \\[len]
;; V1.02 15Mar94 PSG - Real dollar sign \$ won't hilit like math mode.
;; V1.03 16Mar94     - lateX2e-mode, \documentclass, \usepackage
;;                     Jonathan Katz <jkatz@weber.ucsd.edu>
;; V1.04 16Mar94 PSG - Added \sc as a declaration.
;; V1.05 17Mar94     - ams-latex-mode, \eqref , \title[]{}, \numberwithin
;;                     Andrew Swann <swann@imada.ou.dk>
;;               PSG - \{any}cite command that user make up.
(provide 'hilit-LaTeX)

(defun hilit-bracket-region (open)
  "Find region within curly brackets for hilit pattern.
ARG is pattern for beginning of pattern and ends with {.
It cannot be white space.  
Patterns ends simply at the matching closing bracket.

Used for patterns like:
 \\chapter{stuff with matching {} ending with }"
  (if (re-search-forward open nil t)
      (let ((here (point))
            (the-start (match-beginning 0)))
        (backward-char 1)               ; point is on bracket
        (forward-sexp 1)
        (cons the-start (point)))))

(defun hilit-bracket-wysiwyg (open)
  "Find region within curly brackets for hilit pattern.
ARG is pattern for beginning of pattern and starts with {.
Patterns ends simply at the matching closing bracket.

Used for patterns like:
 {\em stuff with matching {} ending with }"
  (if (re-search-forward open nil t)
      (let ((the-start (match-beginning 0)))
        (goto-char the-start)
        (forward-sexp 1)
        (cons the-start (point)))))

(hilit-set-mode-patterns
 '(
   LaTeX-mode japanese-LaTeX-mode SliTeX-mode
   japanese-SliTeX-mode FoilTeX-mode latex-mode latex2e-mode ams-latex-mode
   )
 '(
   ("[^\\]%.*$" nil comment)            ;; comments
   ("\\\\\\(sc\\|bf\\|em\\|it\\|rm\\|sf\\|sl\\|ss\\|tt\\)\\b" nil decl)
   ("``" "''" string)
   ("\\\\\\(raggedright\\|makeindex\\|makeglossary\\|maketitle\\)\\b" nil
    decl)
   ;; label-like things
   ("\\\\item\\(\\[[^]]*\\]\\)?" nil label)
   ;; formulas
   ("\\\\("  "\\\\)" formula)           ; \( \)
   ("[^\\\\]\\\\\\[" "\\\\\\]" formula) ; \[ \] but not \\[len] (PS Galbraith)
   ("[^$\\]\\($\\($[^$]*\\$\\|[^$]*\\)\\$\\)" 1 formula) ; '$...$' or '$$...$$'
   ;;   ^^ but not \$102.54 is expensive for a car wash.
   ;; various declarations/definitions
   ("\\\\\\(setlength\\|settowidth\\|addtolength\\|setcounter\\|addtocounter\\)" nil define)
   ("\\\\\\(normalsize\\|small\\|footnotesize\\|scriptsize\\|tiny\\|large\\|Large\\|LARGE\\|huge\\|Huge\\)\\b" nil decl)
   ("\\\\\\(appendix\\|tableofcontents\\|listoffigures\\|listoftables\\)\\b"
    nil decl)
   ("\\\\[a-z]+box" nil keyword)
   ;; "wysiwyg" emphasis
   (hilit-bracket-wysiwyg "{\\\\\\(em\\|it\\|sl\\)" italic)
   (hilit-bracket-wysiwyg "{\\\\bf" bold)
   (hilit-bracket-wysiwyg "{\\\\sc" label)
   (hilit-bracket-region 
   ;       (\\(no\\)?cite  -> changed to any cite commands that users make up.
    "\\\\\\([^ ]*cite\\|\\(page\\)?ref\\|eqref\\|label\\|index\\|glossary\\){"
    crossref)
   (hilit-bracket-region "\\\\\\(v\\|h\\)space\\(\*\\)?{" keyword)
   (hilit-bracket-region "\\\\footnote\\(mark\\|text\\)?{" keyword)
   ;; things that do some sort of cross-reference
   (hilit-bracket-region 
    "\\\\\\(pagestyle\\|thispagestyle\\|pagenumbering\\|numberwithin\\){" decl)
   ;; things that bring in external files
   (hilit-bracket-region  "\\\\\\(include\\|input\\|bibliography\\){" include)
   ;; (re-)define new commands/environments/counters
   (hilit-bracket-region "\\\\\\(re\\)?new\\(environment\\|command\\){" defun)
   (hilit-bracket-region "\\\\new\\(length\\|theorem\\|counter\\){" defun)
   ;; the following two match \foo[xx]{xx} or \foo*{xx} or \foo{xx}
   (hilit-bracket-region 
    "\\\\\\(sub\\)*\\(paragraph\\|section\\)\\(\*\\|\\[.*\\]\\)?{" keyword)
   (hilit-bracket-region 
    "\\\\\\(chapter\\|part\\)\\(\*\\|\\[.*\\]\\)?{" keyword)
   (hilit-bracket-region 
    "\\(\\\\document\\(style\\|class\\)\\|\\\\usepackage\\)\\(\\[.*\\]\\)?{" 
    decl)
   (hilit-bracket-region "\\\\title\\(\\[.*\\]\\)?{" define)
   (hilit-bracket-region "\\\\\\(author\\|date\\|thanks\\){" define)
   (hilit-bracket-region "\\\\caption\\(\\[[^]]*\\]\\)?{" label)
   (hilit-bracket-region "\\\\\\(begin\\|end\\|nofiles\\|includeonly\\){" 
                         decl)))

