# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Browse from a set of strings

class StringBrowser {name title {scrollpos right}} {
    set slot(window) $name

    frame $name -bd 0

    label $name.title -text $title -relief raised -bd 1

    listbox $name.box -relief raised -bd 1 -exportselection false\
	-yscrollcommand [list $name.scroll set]\
	-geometry 20x15
    tk_listboxSingleSelect $name.box

    scrollbar $name.scroll -orient vertical -relief raised -bd 1\
	-command [list $name.box yview]

    pack $name.title  -side top -fill x
    pack $name.scroll -side $scrollpos -fill y
    pack $name.box    -side left -expand 1 -fill both
}

method StringBrowser destructor {} {
    destroy $slot(window)
}

method StringBrowser clear {} {
    $slot(window).box delete 0 end
}

method StringBrowser add {entry} {
    $slot(window).box insert end $entry
}

method StringBrowser selection {} {
    set sel [$slot(window).box curselection]
    if {[llength $sel] != 1} {
	error {no selection}
    } else {
	return [lindex $sel 0]
    }
}

method StringBrowser fetch {index} {
    return [$slot(window).box get $index]
}
