#if !defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: args.c,v 4.38 1994/08/18 17:18:21 hubert Exp $";
#endif
/*----------------------------------------------------------------------

            T H E    P I N E    M A I L   S Y S T E M

   Laurence Lundblade and Mike Seibel
   Networks and Distributed Computing
   Computing and Communications
   University of Washington
   Administration Builiding, AG-44
   Seattle, Washington, 98195, USA
   Internet: lgl@CAC.Washington.EDU
             mikes@CAC.Washington.EDU

   Please address all bugs and comments to "pine-bugs@cac.washington.edu"

   Copyright 1989-1994  University of Washington

    Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee to the University of
   Washington is hereby granted, provided that the above copyright notice
   appears in all copies and that both the above copyright notice and this
   permission notice appear in supporting documentation, and that the name
   of the University of Washington not be used in advertising or publicity
   pertaining to distribution of the software without specific, written
   prior permission.  This software is made available "as is", and
   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  
   Pine and Pico are trademarks of the University of Washington.
   No commercial use of these trademarks may be made without prior
   written permission of the University of Washington.

   Pine is in part based on The Elm Mail System:
    ***********************************************************************
    *  The Elm Mail System  -  Revision: 2.13                             *
    *                                                                     *
    * 			Copyright (c) 1986, 1987 Dave Taylor              *
    * 			Copyright (c) 1988, 1989 USENET Community Trust   *
    ***********************************************************************
 

  ----------------------------------------------------------------------*/

/*======================================================================
      args.c
      Command line argument parsing functions 

  ====*/

#include "headers.h"

void args_help();


/*
 *  Parse the command line args.
 *
 *  Args: pine_state -- The pine_state structure to put results in
 *        argc, argv -- The obvious
 *        addrs      -- Pointer to address list that we set for caller
 *
 * Result: command arguments parsed
 *       possible printing of help for command line
 *       various flags in pine_state set
 *       returns the string name of the first folder to open
 *       addrs is set
 */
char *
pine_args(pine_state, argc, argv, addrs)
     struct pine  *pine_state;
     int           argc;
     char        **argv;
     char       ***addrs;
{
    register int    ac;
    register char **av;
    int   a0_len, c;
    char *str;
    char *folder              = NULL;
    char *cmd_list            = NULL;
    char *sort                = NULL;
    char *pinerc_file         = NULL;
    char *addrbook_file       = NULL;
    char *ab_sort_descrip     = NULL;
    int   do_help             = 0;
    int   do_conf             = 0;
    int   anonymous           = 0;
    int   usage               = 0;
    int   do_use_fk           = 0;
    int   do_can_suspend      = 0;
    int   do_expanded_folders = 0;
    struct variable *vars     = pine_state->vars;

    
    ac = argc;
    av = argv;

#ifdef	DOS
    sprintf(tmp_20k_buf, "%.*s", last_cmpnt(argv[0]) - argv[0], argv[0]);
    pine_state->pine_dir = cpystr(tmp_20k_buf);
#endif

      /* while more arguments with leading - */
Loop: while(--ac > 0 && **++av == '-'){
	 /* while more chars in this argument */
	 while(*++*av){
	    /* check for pinerc options */
	    if(pinerc_cmdline_opt(*av)){
	       goto Loop;  /* done with this arg, go to next */
	    /* then other multi-char options */
	    }else if(strcmp(*av, "conf") == 0){
	       do_conf = 1;
	       goto Loop;  /* done with this arg, go to next */
	    }else if(strcmp(*av, "pinerc") == 0){
	       if(--ac){
		   pinerc_file = *++av;
	       }else{
	           fprintf(stderr,
   "Error: missing argument for option \"-pinerc\" (use - for standard out)\n");
		   ++usage;
	       }
	       goto Loop;
	    }else if(strcmp(*av, "create_lu") == 0){
	       if(ac > 2){
	          ac -= 2;
		  addrbook_file   = *++av;
		  ab_sort_descrip = *++av;
	       }else{
		  fprintf(stderr,
		     "Error: missing argument for option \"-create_lu\"\n");
		  fprintf(stderr,
	     "Usage: pine -create_lu <addrbook_file> <addrbook_sort_type>\n");
		  exit(-1);
	       }
	       goto Loop;
	    }else if(strcmp(*av, "nr") == 0){
	       pine_state->nr_mode = 1;
	       goto Loop;
	    }else if(strcmp(*av, "sort") == 0){
	       if(--ac){
		   sort = *++av;
		   vars[V_SORT_KEY].command_line_val.p = cpystr(sort);
	       }else{
	           fprintf(stderr,
			    "Error: missing argument for option \"-sort\"\n");
		   ++usage;
	       }
	       goto Loop;

	    /* single char flags */
	    }else{
	       switch(c = **av) {
		 case 'h':
		   do_help = 1;
		   break;  /* break back to inner-while */
		 case 'k':
		   do_use_fk = 1;
		   break;
		 case 'a':
		   anonymous = 1;
		   break;
		 case 'z':
		   do_can_suspend = 1;
		   break;
		 case 'r':
		   pine_state->restricted = 1;
		   break;
		 case 'o':
		   pine_state->open_readonly_on_startup = 1;
		   break;
		 case 'i':
		   pine_state->start_in_index = 1;
		   break;
		 case 'l':
		   do_expanded_folders = 1;
		   break;
		 /* these take arguments */
		 case 'f' : case 'F': case 'p': case 'I':  /* string args */
#ifndef DOS
		 case 'P':  /* also a string */
#endif
		 case 'd': case 'n':  /* integer args */
		   if(*++*av){
		      str = *av;
		   }else if(--ac){
		      str = *++av;
		   }else{
		      fprintf(stderr,
			"Error: missing argument for flag \"%c\"\n", c);
		      ++usage;
		      goto Loop;
		   }
		   switch(c){
		     case 'f':
		       folder = str;
		       break;
		     case 'F':
		       folder = str;
		       pine_state->more_mode = 1;
		       break;
		     case 'I':
		       cmd_list = str;
		       break;
		     case 'p':
		       if(str != NULL)
			  pine_state->pinerc = cpystr(str);
		       break;
#ifndef DOS
		     case 'P':
		       if(str != NULL)
			  pine_state->pine_conf = cpystr(str);
		       break;
#endif
#ifdef	DEBUG
		     case 'd':
		       if(!isdigit(str[0])){
			   fprintf(stderr,
			  "Error: Non numeric argument for flag \"%c\"\n", c);
			   ++usage;
			   break;
		       }

		       debug = atoi(str);
		       break;
#endif
		     case 'n':
		       if(!isdigit(str[0])){
			   fprintf(stderr,
			  "Error: Non numeric argument for flag \"%c\"\n", c);
			   ++usage;
			   break;
		       }

		       pine_state->start_entry = atoi(str);
		       if (pine_state->start_entry < 1)
			  pine_state->start_entry = 1;
		       break;
		   }
		   goto Loop;

		 default:
		   fprintf(stderr, "Error: unknown flag \"%c\"\n", c);
		   ++usage;
		   break;
	       }
	    }
	 }
      }

    if(cmd_list){
	int    commas         = 0;
	char  *p              = cmd_list;
	char  *error          = NULL;

	while(*p++)
	    if(*p == ',')
		++commas;
	vars[V_INIT_CMD_LIST].command_line_val.l =
			parse_list(cmd_list, commas+1, &error);
	if(error){
	    fprintf(stderr, "Error in -I argument \"%s\": %s\n", cmd_list,
								    error);
	    exit(-1);
	}
    }

#define PINEF_LEN 5
    a0_len = strlen(argv[0]);
    if(a0_len >= PINEF_LEN && strcmp(argv[0]+a0_len-PINEF_LEN, "pinef") == 0)
        do_use_fk = 1;

    if(do_use_fk || do_can_suspend || do_expanded_folders){
	char   list[500];
	int    commas         = 0;
	char  *p              = list;
	char  *error          = NULL;

        list[0] = '\0';

        if(do_use_fk){
	    if(list[0])
	        (void)strcat(list, ",");
	    (void)strcat(list, "use-function-keys");
	}
	if(do_can_suspend){
	    if(list[0])
	        (void)strcat(list, ",");
	    (void)strcat(list, "enable-suspend");
	}
	if(do_expanded_folders){
	    if(list[0])
	        (void)strcat(list, ",");
	    (void)strcat(list, "expanded-view-of-folders");
	}

	while(*p++)
	    if(*p == ',')
		++commas;
	pine_state->feat_list_back_compat = parse_list(list, commas+1, &error);
	if(error){
	    fprintf(stderr, "Internal error %s\n", error);
	    exit(-1);
	}
    }

    if(anonymous){
      if(pine_state->nr_mode){
        pine_state->anonymous = 1;
      }else{
	fprintf(stderr, "Can't currently use -a without -nr\n");
	exit(-1);
      }
    }

    if(do_conf && pinerc_file){
      fprintf(stderr, "Can't have both -conf and -pinerc\n");
      exit(-1);
    }
    if(do_conf && addrbook_file){
      fprintf(stderr, "Can't have both -conf and -create_lu\n");
      exit(-1);
    }
    if(pinerc_file && addrbook_file){
      fprintf(stderr, "Can't have both -pinerc and -create_lu\n");
      exit(-1);
    }

    if(do_help || usage) 
      args_help(); 
    if(usage)
      exit(-1);
    if(do_conf)
      dump_global_conf();
    if(pinerc_file)
      dump_new_pinerc(pinerc_file);
    if(addrbook_file)
      just_update_lookup_file(addrbook_file, ab_sort_descrip);

    pine_state->show_folders_dir = 0;

    if(ac <= 0)
      *av = NULL;
    *addrs = av;

    return(folder);
}


/*----------------------------------------------------------------------
    print a few lines of help for command line arguments

  Args:  none

 Result: prints help messages
  ----------------------------------------------------------------------*/
void
args_help()
{
	/**  print out possible starting arguments... **/

	printf("\nPossible Starting Arguments for Pine program:\n\n");
	printf("\tArgument\t\tMeaning\n");
        printf("\t <addrs>...\tGo directly into composer sending to given address\n");
#ifdef	DEBUG
	printf("\t -d n\t\tDebug - set debug level to 'n'\n");
#endif
	printf("\t -f <folder>\tFolder - give folder name to open\n");
	printf("\t -F <file>\tFile - give file name to open and page thru\n");
	printf("\t -h \t\tHelp - give this list of options\n");
	printf("\t -k \t\tKeys - Force use of function keys\n");
	printf("\t -z \t\tSuspend - allow use of ^Z suspension\n");
        printf("\t -r \t\tRestricted - can only send mail to one self\n");
        printf("\t -sort <sort> \tSort - Specify sort order of folder:\n");
        printf("\t\t\t        subject, arrival, date, from, size, /reverse\n");
        printf("\t -i\t\tIndex - Go directly to index, bypassing main menu\n");
        printf("\t -I <keystroke_list>\tInitial keystrokes to be executed\n");
        printf("\t -n <number>\tEntry in index to begin on\n");
	printf("\t -o \t\tReadOnly - Open first folder read-only\n");
        printf("\t -conf\t\tConfiguration - Print out fresh global configuration\n");
        printf("\t -pinerc <file>\tConfiguration - Put fresh pinerc configuration in <file>\n");
        printf("\t -p <pinerc>\tUse alternate .pinerc file\n");
#ifndef DOS
        printf("\t -P <pine.conf>\tUse alternate pine.conf file\n");
#endif
        printf("\t -create_lu <abook_file> <ab_sort_type>   create .lu from script\n");
        printf("\t -nr\t\tSpecial mode for UWIN\n");
        printf("\t -a\t\tSpecial anonymous mode for UWIN\n");
/* WHILE TESTING FOLDERS */
printf("\t -l\t\tList - Expand List of folder collections by default\n");
        printf("\t -<option>=<value>\tAssign <value> to the pinerc option <option>\n");
        printf("\t\t\t        e.g. -signature-file=sig1\n");
        printf("\t\t\t        (Note: feature-list is additive)\n");
	exit(1);
}
