/* prb_node.c  94.03.20
 * Copyright 1983-1992   Albert Davis
 * node probes
 */
#include "ecah.h"
#include "branch.h"
#include "mode.h"
#include "nodestat.h"
#include "probh.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	double	probe_node(probe_t);
static	double	trprobe_node(probe_t);
static	double	acprobe_node(probe_t);
/*--------------------------------------------------------------------------*/
extern const struct status stats;
extern const struct nodestat *nstat;
extern const struct nodestuff ns;
extern const double genout;
extern const double temp;
extern const double trtime0;
extern const int sim_mode;
/*--------------------------------------------------------------------------*/
double probe_node(probe_t prb)
{
 if (sim_mode == sAC){
    return acprobe_node(prb);
 }else{
    return trprobe_node(prb);
 }
}
/*--------------------------------------------------------------------------*/
static double trprobe_node(probe_t prb)
{
 node_t nn;
 node_t ground;
 int dummy = 0;

 ground.e = ground.m = ground.t = 0;
 nn.e = prb.node;
 nn.t = nn.e;
 nn.m = ns.nm[nn.t];
 
 setmatch(prb.what,&dummy);
 if (rematch("ITer")  &&  prb.node < iCOUNT){
    return (double)stats.iter[prb.node];
 }else if (rematch("Control")  &&  prb.node < cCOUNT){
    return (double)stats.control[prb.node];
 }else if (rematch("GEnerator")){
    return genout;
 }else if (rematch("Temperature")){
    return temp + ABS_ZERO;
 }else if (rematch("TIme")){
    return trtime0;
 }else if (prb.node > stats.total_nodes){
    return NOT_VALID;

 }else if (rematch("V")){
    return tr_volts(&nn,&ground);
 }else if (rematch("Z")){
    return trz(nn,ground,0.);
 }else if (rematch("Logic")){
    return logicval(&nn);
 }else if (rematch("LAstchange")){
    return nstat[nn.m].lastchange;
 }else if (rematch("FInaltime")){
    return nstat[nn.m].finaltime;
 }else if (rematch("DIter")){
    return (double)nstat[nn.m].diter;
 }else if (rematch("AIter")){
    return (double)nstat[nn.m].aiter;
 }else if (rematch("COUNT")){
    return (double)nstat[nn.m].needsanalog;
 }else{ /* bad parameter */
    return NOT_VALID;
 }
}
/*--------------------------------------------------------------------------*/
static double acprobe_node(probe_t prb)
{
 node_t nn;
 node_t ground;
 complex_t zero;
 int dummy = 0;

 zero.x = zero.y = 0.;
 ground.e = ground.m = ground.t = 0;
 nn.e = prb.node;
 nn.t = nn.e;
 nn.m = ns.nm[nn.t];

 setmatch(prb.what,&dummy);
 if (rematch("Temperature")){
    return temp + ABS_ZERO;
 }else if (rematch("TIme")){
    return trtime0;
 }else if (prb.node > stats.total_nodes){
    return NOT_VALID;

 }else if (rematch("Vm")){			/* volts, magnitude */
    return hypot(ns.acx[nn.m],ns.acy[nn.m]);
 }else if (rematch("VDB")){			/* volts, db re 1v */
    double v = hypot(ns.acx[nn.m],ns.acy[nn.m]);
    return (v > VOLTMIN)  ?  20. * log10(v)  :  DBVOLTMIN;
 }else if (rematch("VP")){			/* voltage phase */
    return phase(ns.acx[nn.m],ns.acy[nn.m]);
 }else if (rematch("Zm")){			/* port impedance magnitude */
    complex_t zz;
    zz = acz(nn,ground,zero);
    return CABS(zz);
 }else if (rematch("ZP")){			/* port impedance phase */
    complex_t zz;
    zz = acz(nn,ground,zero);
    return phase(zz.x,zz.y);
 }else if (rematch("ZR")){			/* port impedance real part */
    complex_t zz;
    zz = acz(nn,ground,zero);
    return zz.x;
 }else if (rematch("ZI")){			/* port impedance imag part */
    complex_t zz;
    zz = acz(nn,ground,zero);
    return zz.y;
 }else{ /* bad parameter */
    return NOT_VALID;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
