#!/bin/sh

umask 022

echo Expect some cache has wrong version warnings if upgrading
echo to version 1.7.x for the first time.

. Version.mk

PREFIX=

#if [ -f /etc/ld.so.cache ] ; then
#	echo Deleting old /etc/ld.so.cache
#	rm -f /etc/ld.so.cache
#fi

if [ ! -f /etc/ld.so.conf ] ; then
	echo Creating new /etc/ld.so.conf
	for dir in /usr/local/lib /usr/X11R6/lib /usr/X386/lib /usr/openwin/lib /lib/elf ; do
		if [ -d $dir ] ; then
			echo $dir >> /etc/ld.so.conf
		fi
	done
fi

if [ -f ld-so/ld.so ] ; then
	echo Installing ld.so
	install -c ld-so/ld.so $PREFIX/lib/ld.so.$VERSION
	mv -f $PREFIX/lib/ld.so.$VERSION $PREFIX/lib/ld.so
	ln -f $PREFIX/lib/ld.so $PREFIX/lib/ld.so.$VERSION

	echo Installing libldso.a
	if [ -d $PREFIX/usr/i486-linuxaout/lib ] ; then
		install -c -m 644 ld-so/libldso.a $PREFIX/usr/i486-linuxaout/lib
	else
		install -c -m 644 ld-so/libldso.a $PREFIX/usr/lib
	fi
else
	echo Not installing a.out support
fi

if [ -f d-link/ld-linux.so ] ; then
	echo Installing ld-linux.so
	install -c d-link/ld-linux.so $PREFIX/lib/ld-linux.so.$VERSION
	mv -f $PREFIX/lib/ld-linux.so.$VERSION $PREFIX/lib/ld-linux.so.$VMAJOR
	ln -f $PREFIX/lib/ld-linux.so.$VMAJOR $PREFIX/lib/ld-linux.so.$VERSION
	if [ -d $PREFIX/lib/elf ] ; then
		ln -sf ../ld-linux.so.$VMAJOR $PREFIX/lib/elf/ld-linux.so.$VMAJOR
	fi

	echo Installing libdl.so
	install -c d-link/libdl/libdl.so $PREFIX/lib/libdl.so.$VERSION
else
	echo Not installing ELF support
fi

echo Installing ldd
install -c util/ldd $PREFIX/usr/bin

echo Installing and running ldconfig
if [ -d $PREFIX/sbin ] ; then
	install -c util/ldconfig $PREFIX/sbin
	$PREFIX/sbin/ldconfig
else
	install -c util/ldconfig $PREFIX/etc
	$PREFIX/etc/ldconfig
fi

echo Installing manual pages
install -c -m 644 man/ldd.1 $PREFIX/usr/man/man1
install -c -m 644 man/ldconfig.8 man/ld.so.8 $PREFIX/usr/man/man8
install -c -m 644 man/dlopen.3 $PREFIX/usr/man/man3
ln -sf dlopen.3 $PREFIX/usr/man/man3/dlsym.3
ln -sf dlopen.3 $PREFIX/usr/man/man3/dlerror.3
ln -sf dlopen.3 $PREFIX/usr/man/man3/dlclose.3

echo Installation complete
