/* uid_hash.c
 *
 * routines used by lastcomm and sa to hash data by uids
 */

#include <stdio.h>
#include <pwd.h>
#include <strings.h>

#include "common.h"
#define __UID_HASH_H_NO_EXTERNS__ /* so we don't get the externs */
#include "uid_hash.h"

struct uid_entry *uid_list[TABLE_SIZE];	/* the hash table */

static char rcsid[] = "$Id: uid_hash.c,v 1.2 1993/11/16 05:37:10 noel Exp $";

/* look up UID in the hash table of uids.  If it's not there, get it
 * from the password database and add it to the hash table.
 */
char *
uid_name (int uid)
{
  struct uid_entry *ue;
  struct passwd *thispw;

  for (ue = uid_list[HASH (uid)]; ue != NULL; ue = ue->next)
    {
      if (uid == ue->uid)            /* found it! */
	return ue->name;
    }

  /* it wasn't there, so add it */

  thispw = getpwuid (uid);

  ue = (struct uid_entry *) xmalloc (sizeof (struct uid_entry));

  if (thispw != NULL)
    strncpy (ue->name, thispw->pw_name, NAME_LEN);
  else
    sprintf (ue->name, "%d", uid);

  ue->uid = uid;
  ue->next = uid_list[HASH (uid)];
  uid_list[HASH (uid)] = ue;

  return ue->name;
}

void
clear_uid_table (void)
{
  int a;

  for (a = 0; a < TABLE_SIZE; a++)
    uid_list[a] = NULL;
}
