/* -*-mode: flex-*- */

/*
 * We don't use input, so don't generate code for it.
 */
%option noinput

/*
 * We don't use unput, so don't generate code for it.
 */
%option nounput

%{

/********************************************************************************
 *
 * text2pcap-scanner.l
 *
 * Utility to convert an ASCII hexdump into a libpcap-format capture file
 *
 * (c) Copyright 2001 Ashok Narayanan <ashokn@cisco.com>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *******************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "text2pcap.h"

/*
 * Flex (v 2.5.35) uses this symbol to "exclude" unistd.h
 */
#ifdef _WIN32
#define YY_NO_UNISTD_H
#endif

#ifdef _WIN32
/* disable Windows VC compiler warning "signed/unsigned mismatch" associated  */
/* with YY_INPUT code generated by flex versions such as 2.5.35.              */
#pragma warning (disable:4018)
#endif

%}

hexdigit [0-9A-Fa-f]
directive #TEXT2PCAP.*
comment #[^W].*
byte [0-9A-Fa-f][0-9A-Fa-f][ \t]
byte_eol [0-9A-Fa-f][0-9A-Fa-f]\r?\n
offset [0-9A-Fa-f]+[: \t]
offset_eol [0-9A-Fa-f]+\r?\n
text [^ \n\t]+
mailfwd >
eol \r?\n\r?

%%

{byte}            { parse_token(T_BYTE, yytext); }
{byte_eol}        { parse_token(T_BYTE, yytext); parse_token(T_EOL, NULL); }
{offset}          { parse_token(T_OFFSET, yytext); }
{offset_eol}      { parse_token(T_OFFSET, yytext); parse_token(T_EOL, NULL); }
{mailfwd}{offset} { parse_token(T_OFFSET, yytext+1); }
{eol}             { parse_token(T_EOL, NULL); }
[ \t]             ; /* ignore whitespace */
{directive}       { parse_token(T_DIRECTIVE, yytext); }
{comment}         ; /* ignore comments */
{text}            { parse_token(T_TEXT, yytext); }

%%

int yywrap(void)
{
    return 1;
}
