/*
 * i18n.c: Internationalization
 *
 * See the main source file 'vdr.c' for copyright information and
 * how to reach the author.
 *
 * $Id: i18n.c 1.79 2002/04/06 09:49:19 kls Exp $
 *
 * Slovenian  translations provided by Miha Setina <mihasetina@softhome.net> and Matjaz Thaler <matjaz.thaler@guest.arnes.si>
 * Italian    translations provided by Alberto Carraro <bertocar@tin.it>
 * Dutch      translations provided by Arnold Niessen <niessen@iae.nl> <arnold.niessen@philips.com>
 * Portuguese translations provided by Paulo Lopes <pmml@netvita.pt>
 * French     translations provided by Jean-Claude Repetto <jc@repetto.org>
 * Norwegian  translations provided by Jrgen Tvedt <pjtvedt@online.no> and Truls Slevigen <truls@slevigen.no>
 * Finnish    translations provided by Hannu Savolainen <hannu@opensound.com>
 * Polish     translations provided by Michael Rakowski <mrak@gmx.de>
 * Spanish    translations provided by Ruben Nunez Francisco <ruben.nunez@tang-it.com>
 *
 */

/*
 * How to add a new language:
 *
 * 1. Announce your translation action on the Linux-DVB mailing
 *    list to avoid duplicate work.
 * 2. Increase the value of 'NumLanguages'.
 * 3. Insert a new line in every member of the 'Phrases[]' array,
 *    containing the translated text for the new language.
 *    For example, assuming you want to add the Italian language,
 *
 *       { "English",
 *         "Deutsch",
 *       },
 *
 *    would become
 *
 *       { "English",
 *         "Deutsch",
 *         "Italiano",
 *       },
 *
 *    and so on. Append your language after the last existing language
 *    and write the name of your language in your language (not in English,
 *    which means that it should be 'Italiano', not 'Italian').
 *    Note that only the characters defined in 'fontosd.c' will
 *    be available!
 * 4. Compile VDR and test the new language by switching to it
 *    in the "Setup" menu.
 * 5. Send the modified 'i18n.c' file to <kls@cadsoft.de> to have
 *    it included in the next version of VDR.
 *
 * In case an English phrase is used in more than one context (and might need
 * different translations in other languages) it can be preceeded with an
 * arbitrary string to describe its context, separated from the actual phrase
 * by a '$' character (see for instance "Button$Stop" vs. "Stop").
 * Of course this means that no English phrase may contain the '$' character!
 * If this should ever become necessary, the existing '$' would have to be
 * replaced with something different...
 */

#include "i18n.h"
#include <stdio.h>
#include "config.h"
#include "tools.h"

const int NumLanguages = 11;

typedef const char *tPhrase[NumLanguages];

const tPhrase Phrases[] = {
  // The name of the language (this MUST be the first phrase!):
  { "English",
    "Deutsch",
    "Slovenski",
    "Italiano",
    "Nederlands",
    "Portugus",
    "Franais",
    "Norsk",
    "Suomi",
    "Polski",
    "Espaol",
  },
  // Menu titles:
  { "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
  },
  { "Schedule",
    "Programm",
    "Urnik",
    "Programmi",
    "Gids",
    "Programao",
    "Programmes",
    "Programmer",
    "Ohjelmat",
    "Program",
    "Programa",
  },
  { "Channels",
    "Kanle",
    "Kanali",
    "Canali",
    "Kanalen",
    "Canais",
    "Chanes",
    "Kanaler",
    "Kanavat",
    "Kanaly",
    "Canales",
  },
  { "Timers",
    "Timer",
    "Termini",
    "Timer",
    "Timers",
    "Timers",
    "Programmation",
    "Timere",
    "Ajastin",
    "Timery",
    "Timer",
  },
  { "Recordings",
    "Aufzeichnungen",
    "Posnetki",
    "Registrazioni",
    "Opnames",
    "Gravaes",
    "Enregistrements",
    "Opptak",
    "Nauhoitteet",
    "Nagrania",
    "Grabaciones",
  },
  { "Setup",
    "Einstellungen",
    "Nastavitve",
    "Opzioni",
    "Instellingen",
    "Configurar",
    "Configuration",
    "Konfigurasjon",
    "Asetukset",
    "Nastawy",
    "Configuracin",
  },
  { "Commands",
    "Befehle",
    "Ukazi",
    "Comandi",
    "Commando's",
    "Comandos",
    "Commandes",
    "Kommandoer",
    "Komennot",
    "Rozkazy",
    "rdenes",
  },
  { "Edit channel",
    "Kanal editieren",
    "Uredi kanal",
    "Modifica canale",
    "Kanaal aanpassen",
    "Modificar canal",
    "Modifier une chane",
    "Editer kanal",
    "Muokkaa kanavaa",
    "Ustawienie kanalu",
    "Modificar canal",
  },
  { "Edit timer",
    "Timer editieren",
    "Uredi termin",
    "Modifica timer",
    "Timer veranderen",
    "Modificar timer",
    "Changer la programmation",
    "Editer timer",
    "Muokkaa ajastusta",
    "Ustawienie timerow",
    "Modificar timer",
  },
  { "Event",
    "Sendung",
    "Oddaja",
    "Eventi",
    "Uitzending",
    "Evento",
    "Evnement",
    "Hendelse",
    "Tapahtuma",
    "Audycja",
    "Evento",
  },
  { "Summary",
    "Inhalt",
    "Vsebina",
    "Sommario",
    "Inhoud",
    "Resumo",
    "Rsum",
    "Sammendrag",
    "Yhteenveto",
    "Zawartosc",
    "Resmen",
  },
  { "Schedule - %s",
    "Programm - %s",
    "Urnik - %s",
    "Programma - %s",
    "Programma - %s",
    "Programa - %s",
    "Programmes - %s",
    "Program Guide - %s",
    "Ohjelma - %s",
    "Program - %s",
    "Programa - %s",
  },
  { "What's on now?",
    "Was luft jetzt?",
    "Kaj je na sporedu?",
    "In programmazione",
    "Wat is er nu?",
    "Programa actual?",
    "Programmes en cours",
    "Hvilket program sendes n?",
    "Nykyinen ohjelma",
    "Program biezacy",
    "Qu hay ahora?",
  },
  { "What's on next?",
    "Was luft als nchstes?",
    "Kaj sledi?",
    "Prossimi programmi",
    "Wat komt er hierna?",
    "Prximo Programa?",
    "Prochains programmes",
    "Hvilket program er neste?",
    "Seuraava ohjelma",
    "Program nastepny",
    "Qu hay proximo?",
  },
  // Button texts (should not be more than 10 characters!):
  { "Edit",
    "Editieren",
    "Uredi",
    "Modifica",
    "Verander",
    "Modificar",
    "Modifier",
    "Editer",
    "Muuta",
    "Edycja",
    "Modificar",
  },
  { "New",
    "Neu",
    "Novo",
    "Nuovo",
    "Nieuw",
    "Novo",
    "Nouveau",
    "Ny",
    "Uusi",
    "Nowy",
    "Nuevo",
  },
  { "Delete",
    "Lschen",
    "Odstrani",
    "Cancella",
    "Verwijder",
    "Apagar",
    "Supprimer",
    "Slett",
    "Poista",
    "Usunac",
    "Borrar",
  },
  { "Mark",
    "Markieren",
    "Oznaci",
    "Marca",
    "Verplaats",
    "Marcar",
    "Marquer",
    "Marker",
    "Merkitse",
    "Zaznaczyc",
    "Marcar",
  },
  { "On/Off",
    "Ein/Aus",
    "Vklop/Izklop",
    "On/Off",
    "Aan/Uit",
    "On/Off",
    "Marche/Arr",
    "Av/P",
    "Pll/Pois",
    "Zal./ Wyl.",
    "On/Off",
  },
  { "Record",
    "Aufnehmen",
    "Posnemi",
    "Registra",
    "Opnemen",
    "Gravar",
    "Enregistre",
    "Ta opp",
    "Nauhoita",
    "Nagrywac",
    "Grabar",
  },
  { "Play",
    "Wiedergabe",
    "Predavajaj",
    "Riproduci",
    "Afspelen",
    "Play",
    "Lire",
    "Spill av",
    "Toista",
    "Odtwarzac",
    "Play",
  },
  { "Rewind",
    "Anfang",
    "Zacetek",
    "Da inizio",
    "Naar begin",
    "Rebobinar",
    "Retour",
    "Spol tilbake",
    "Takaisinkel.",
    "Poczatek",
    "Rebobinar",
  },
  { "Button$Stop",
    "Beenden",
    "Ustavi",
    "Stop",
    "Eindigen",
    "Parar",
    "Arrt",
    "Stopp",
    "Pysyt",
    "Zakonczyc",
    "Parar",
  },
  { "Resume",
    "Weiter",
    "Nadaljuj",
    "Riprendi",
    "Verder",
    "Continuar",
    "Reprendre",
    "Fortsett",
    "Jatka",
    "Dalej",
    "Continuar",
  },
  { "Summary",
    "Inhalt",
    "Vsebina",
    "Sommario",
    "Inhoud",
    "Resumo",
    "Rsum",
    "Sammendrag",
    "Yhteenveto",
    "Zawartosc",
    "Resumen",
  },
  { "Open",
    "ffnen",
    "Odpri",
    "Apri",
    "Openen",
    "Abrir",
    "Ouvrir",
    "pne",
    "Avaa",
    "Otworzyc",
    "Abrir",
  },
  { "Switch",
    "Umschalten",
    "Preklopi",
    "Cambia",
    "Selecteer",
    "Seleccionar",
    "Regarder",
    "Skift til",
    "Valitse",
    "Przelaczyc",
    "Cambiar",
  },
  { "Now",
    "Jetzt",
    "Sedaj",
    "Adesso",
    "Nu",
    "Agora",
    "Maintenant",
    "N",
    "Nyt",
    "Teraz",
    "Ahora",
  },
  { "Next",
    "Nchste",
    "Naslednji",
    "Prossimo",
    "Hierna",
    "Proximo",
    "Aprs",
    "Neste",
    "Seuraava",
    "Nastepny",
    "Siguiente",
  },
  { "Button$Schedule",
    "Programm",
    "Urnik",
    "Programma",
    "Programma",
    "Programao",
    "Programme",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Programa",
  },
  { "Language",
    "Sprache",
    "Jezik",
    "Linguaggio",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jezyk",
    "Lengua",
  },
  { "Eject",
    "Auswerfen",
    "Izvrzi",
    "Eject",
    "Eject",
    "Ejectar",
    "Ejection",
    "Eject",
    "Avaa",
    "Wyrzucenie",
    "Eyectar",
  },
  // Confirmations:
  { "Delete channel?",
    "Kanal lschen?",
    "Odstrani kanal?",
    "Cancello il canale?",
    "Kanaal verwijderen?",
    "Apagar o canal?",
    "Supprimer la chane?",
    "Slette kanal?",
    "Poistetaanko kanava?",
    "Usunac kanal?",
    "Eliminar canal?",
  },
  { "Delete timer?",
    "Timer lschen?",
    "Odstani termin?",
    "Cancello il timer?",
    "Timer verwijderen?",
    "Apagar o timer?",
    "Supprimer la programmation?",
    "Slette timer?",
    "Poistetaanko ajastus?",
    "Usunac timer?",
    "Eliminar timer?",
  },
  { "Delete recording?",
    "Aufzeichnung lschen?",
    "Odstrani posnetek?",
    "Cancello la registrazione?",
    "Opname verwijderen?",
    "Apagar a gravao?",
    "Supprimer l'enregistrement?",
    "Slette opptak?",
    "Poistetaanko nauhoitus?",
    "Usunac nagranie?",
    "Eliminar grabacion?",
  },
  { "Timer still recording - really delete?",
    "Timer zeichnet auf - trotzdem lschen?",
    "Snemanje po terminu - zares odstrani?",
    "Timer in regestazione - cancello?",
    "Timer neemt nog op - toch verwijderen?"
    "Timer activo - tm a certeza que quer apagar?",
    "Enregistrement en cours - confirmez la suppression",
    "Timer gjr opptak - vil du slette likevel?",
    "Ajastin nauhoittaa - poistetaanko silti?",
    "Nagrywanie w trakcie - napewno usunac?",
    "Timer activo - de verdad eliminarlo?",
  },
  { "Stop recording?",
    "Aufzeichnung beenden?",
    "Koncaj snemanje?",
    "Fermo la registrazione?",
    "Opname stoppen?",
    "Parar Gravao?",
    "Arrter l'enregistrement?",
    "Stoppe opptak?",
    "Pysytetnk nauhoitus?",
    "Zakonczyc nagranie?",
    "Parar grabacin?",
  },
  { "on primary interface",
    "auf dem primren Interface",
    "na primarni napravi",
    "su interfaccia primaria",
    "op eerste interface",
    "no interface primrio",
    "sur la carte primaire",
    "p frste enhet",
    "pvastaanottimella",
    "na pierwszym interfejsie",
    "en interface primario",
  },
  { "Cancel editing?",
    "Schneiden abbrechen?",
    "Zelite prekiniti urejanje?",
    "Annullo la modifica?",
    "Bewerken afbreken?",
    "Cancelar Modificaes?",
    "Annuler les modifications?",
    "Avbryte redigering?",
    "Peruutetaanko muokkaus?",
    "Zakonczyc montaz?",
    "Cancelar modificacin?",
  },
  { "Really restart?",
    "Wirklich neu starten?",
    "Zares ponoven zagon",
    "Eseguo un restart?",
    "Werkelijk opnieuw starten?",
    "Tem a certeza que quer reiniciar?",
    "Redmarrer?",
    "Vil du virkelig starte p nytt?",
    "Aloitetaanko varmasti alusta?",
    "Rzeczywiscie nowy start?",
    "De verdad reiniciar?",
  },
  { "Recording - restart anyway?",
    "Aufnahme luft - trotzdem neu starten?",
    "Snemanje - zares ponoven zagon",
    "In registrazione - restart comunque?",
    "Opname loopt - toch opnieuw starten?",
    "Em gravao - quer mesmo reiniciar?",
    "Enregistrement en cours - redmarrer?",
    "Gjr opptak - starte p nytt likevel?",
    "Nauhoitus kynniss - aloitetaanko alusta?",
    "Nagrywanie w trakcie - rzeczywiscie nowy start?",
    "Grabando - reiniciar?",
  },
  { "Recording - shut down anyway?",
    "Aufnahme luft - trotzdem ausschalten?",
    "Snemanje - zares izklopi?",
    "In registrazione - spengo comunque?",
    "Opname loopt - toch uitschakelen?",
    "Em gravao - quer mesmo desligar?",
    "Enregistrement en cours - confirmez l'arrt",
    "Gjr opptak - sl av likevel?",
    "Nauhoitus kesken - lopetetaanko se?",
    "Nagrywanie w trakcie - mimo to wylaczyc?",
    "Grabando - apagar?",
  },
  { "Recording in %d minutes, shut down anyway?",
    "Aufnahme in %d Minuten - trotzdem ausschalten?",
    "Snemanje cez %d minut, zares izklopi?",
    "Registrazione fra %d minuti - spengo comunque?",
    "Opname in %d minuten - toch uitschakelen?",
    "Em gravao dentro de %d minutos - quer mesmo desligar?",
    "Enregistrement dans %d minutes - confirmez l'arrt",
    "Skal gjre opptak om %d minutter - sl av likevel?",
    "Nauhoitus alkaisi %d min. kuluttua - sammutetaanko silti?",
    "Nagrywanie za %d minut - mimo to wylaczyc?",
    "Grabando en %d minutos, de verdad cortar?",
  },
  { "Press any key to cancel shutdown",
    "Taste drcken um Shutdown abzubrechen",
    "Pritisni katerikoli gumb za preklic izklopa",
    "Un tasto per annullare lo spegnimento",
    "Druk een toets om shutdown af te breken",
    "Pressione qualquer tecla para cancelar",
    "Appuyez sur une touche pour annuler l'arrt",
    "Trykk en tast for ikke  sl av",
    "Peruuta pysytys painamalla jotakin nppint",
    "Dowolny przycisk zatrzyma wylaczanie",
    "Pulse una tecla para interrumpir corte",
  },
  // Channel parameters:
  { "Name",
    "Name",
    "Naziv",
    "Nome",
    "Naam",
    "Nome",
    "Nom",
    "Navn",
    "Nimi",
    "Nazwa",
    "Nombre",
  },
  { "Frequency",
    "Frequenz",
    "Frekvenca",
    "Frequenza",
    "Frequentie",
    "Frequncia",
    "Frquence",
    "Frekvens",
    "Taajuus",
    "Czestotliwosc",
    "Frecuencia",
  },
  { "Polarization",
    "Polarisation",
    "Polarizacija",
    "Polarizzazione",
    "Polarisatie",
    "Polarizao",
    "Polarisation",
    "Polarisasjon",
    "Polarisaatio",
    "Polaryzacja",
    "Polarizacin",
  },
  { "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
    "DiSEqC",
  },
  { "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Frq. Symbole",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
  },
  { "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
    "PID de Vdeo",
    "PID Vido",
    "Vpid",
    "Kuva PID",
    "Vpid",
    "Vpid",
  },
  { "Apid1",
    "Apid1",
    "Apid1",
    "Apid1",
    "Apid1",
    "PID udio (1)",
    "PID Audio (1)",
    "Apid1",
    "ni PID1",
    "Apid1",
    "Apid1",
  },
  { "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "PID udio (2)",
    "Apid2",
    "ni PID2",
    "Apid2",
    "Apid2",
  },
  { "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "PID AC3 (1)",
    "PID AC3 (1)",
    "AC3pid1",
    "AC3 PID1",
    "Dpid1",
    "Dpid1",
  },
  { "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "PID AC3 (2)",
    "PID AC3 (2)",
    "AC3pid2",
    "AC3 PID2",
    "Dpid2",
    "Dpid2",
  },
  { "Tpid",
    "Tpid",
    "Tpid",
    "Tpid",
    "Tpid",
    "PID Teletexto",
    "PID Tltexte",
    "Tekst-TV pid",
    "TekstiTV PID",
    "Tpid",
    "Tpid",
  },
  { "CA",
    "CA",
    "CA",
    "CA",
    "CA",
    "Encriptao",
    "Cryptage",
    "Kortleser",
    "Salauskortti",
    "CA",
    "CA",
  },
  { "Pnr",
    "Pnr",
    "Pnr",
    "Pnr",
    "Pnr",
    "Nm. Progr.",
    "Num. Progr.",
    "Program Id",
    "Ohjelmatunnus",
    "Pnr",
    "Pnr",
  },
  // Timer parameters:
  { "Active",
    "Aktiv",
    "Aktivno",
    "Attivo",
    "Actief",
    "Activo",
    "Actif",
    "Aktiv",
    "Aktiivinen",
    "Aktywny",
    "Activo",
  },
  { "Channel",
    "Kanal",
    "Kanal",
    "Canale",
    "Kanaal",
    "Canal",
    "Chane",
    "Kanal",
    "Kanava",
    "Kanal",
    "Canal",
  },
  { "Day",
    "Tag",
    "Dan",
    "Giorno",
    "Dag",
    "Dia",
    "Jour",
    "Dag",
    "Piv",
    "Dzien",
    "Da",
  },
  { "Start",
    "Anfang",
    "Zacetek",
    "Inizio",
    "Begin",
    "Inicio",
    "Dbut",
    "Start",
    "Aloitus",
    "Poczatek",
    "Comienzo",
  },
  { "Stop",
    "Ende",
    "Konec",
    "Fine",
    "Einde",
    "Fim",
    "Fin",
    "Slutt",
    "Lopetus",
    "Koniec",
    "Fin",
  },
  { "Priority",
    "Prioritt",
    "Prioriteta",
    "Priorita",
    "Prioriteit",
    "Prioridade",
    "Priorit",
    "Prioritet",
    "Prioriteetti",
    "Priorytet",
    "Prioridad",
  },
  { "Lifetime",
    "Lebensdauer",
    "Veljavnost",
    "Durata",
    "Bewaarduur",
    "Durao",
    "Dure de vie",
    "Levetid",
    "Voimassaolo",
    "Trwalosc dni",
    "Durabilidad",
  },
  { "File",
    "Datei",
    "Datoteka",
    "Nome",
    "Filenaam",
    "Ficheiro",
    "Fichier",
    "Filnavn",
    "Tiedosto",
    "Plik",
    "Fichero",
  },
  { "First day",
    "Erster Tag",
    "Prvi dan",
    "Primo giorno",
    "Eerste dag",
    "Primeiro dia",
    "Premier jour",
    "Frste dag",
    "1. piv",
    "Pierwszy dzien",
    "Primer da",
  },
  // Error messages:
  { "Channel is being used by a timer!",
    "Kanal wird von einem Timer benutzt!",
    "Urnik zaseda kanal!",
    "Canale occupato da un timer!",
    "Kanaal wordt gebruikt door een timer!",
    "Canal a ser utilizador por um timer!",
    "Cette chane est en cours d'utilisation!",
    "Kanalen er i bruk av en timer!",
    "Kanava on ajastimen kytss!",
    "Kanal jest zajety przez timer nagran",
    "Canal est ocupado por un timer!",
  },
  { "Can't switch channel!",
    "Kanal kann nicht umgeschaltet werden!",
    "Ne morem preklopiti kanala!",
    "Impossibile cambiare canale!",
    "Kan geen kanaal wisselen!",
    "No pode mudar de canal!",
    "Impossible de changer de chane!",
    "Ikke mulig  skifte kanal!",
    "Kanavan vaihtaminen ei mahdollista!",
    "Kanal nie moze byc teraz przelaczony!",
    "No puedo cambiar canal!",
  },
  { "Timer is recording!",
    "Timer zeichnet gerade auf!",
    "Snemanje po urniku!",
    "Registrazione di un timer in corso!",
    "Timer is aan het opnemen!",
    "Timer a gravar!",
    "Enregistrement en cours!",
    "Timer gjr opptak!",
    "Ajastinnauhoitus kynniss!",
    "Timer nagrywa!",
    "Timer esta grabando!",
  },
  { "Error while accessing recording!",
    "Fehler beim Ansprechen der Aufzeichnung!",
    "Napaka pri dostopu do posnetka",
    "Errore nel tentativo di acc alla registrazione",
    "Fout bij lezen opname!",
    "Erro ao aceder  gravao",
    "Impossible d'accder  l'enregistrement",
    "Feil under lesing av opptak!",
    "Nauhoituksen toistaminen eponnistui!",
    "Blad - brak dostepu do nagrania!",
    "Error al accesar la grabacin!",
  },
  { "Error while deleting recording!",
    "Fehler beim Lschen der Aufzeichnung!",
    "Napaka pri odstranjevanju posnetka!",
    "Errore durante la canc del filmato!",
    "Fout bij verwijderen opname!",
    "Erro enquanto apagava uma gravao!",
    "Erreur de suppression de l'enregistrement!",
    "Feil under sletting av opptak!",
    "Nauhoituksen poistaminen eponnistui!",
    "Blad przy usuwaniu nagrania!",
    "Error al borrar la grabacin!",
  },
  { "*** Invalid Channel ***",
    "*** Ungltiger Kanal ***",
    "*** Neznan kanal ***",
    "*** CANALE INVALIDO ***",
    "*** Ongeldig kanaal ***",
    "*** Canal Invlido! ***",
    "*** Chane invalide! ***",
    "*** Ugyldig Kanal! ***",
    "*** Virheellinen kanavavalinta! ***",
    "*** Niewazny kanal ***",
    "*** Canal invlido ***",
  },
  { "No free DVB device to record!",
    "Keine freie DVB-Karte zum Aufnehmen!",
    "Ni proste DVB naprave za snemanje!",
    "Nessuna card DVB disp per registrare!",
    "Geen vrije DVB kaart om op te nemen!",
    "Nenhuma placa DVB disponivel para gravar!",
    "Pas de carte DVB disponible pour l'enregistrement!",
    "Ingen ledige DVB enheter for opptak!",
    "Ei vapaata vastaanotinta nauhoitusta varten!",
    "Brak wolnej karty DVB do nagrywania!",
    "No hay dispositivo DVB disponible para grabar!",
  },
  { "Channel locked (recording)!",
    "Kanal blockiert (zeichnet auf)!",
    "Zaklenjen kanal (snemanje)!",
    "Canale bloccato (in registrazione)!",
    "Kanaal geblokkeerd (neemt op)!",
    "Canal bloqueado (a gravar)!",
    "Chane verrouille (enregistrement en cours)!",
    "Kanalen er lst (opptak)!",
    "Kanava lukittu (nauhoitusta varten)!",
    "Kanal zablokowany (nagrywanie w toku)!",
    "Canal bloqueado (grabando)!",
  },
  { "Can't start Transfer Mode!",
    "Transfer-Mode kann nicht gestartet werden!",
    "Ne morem zaceti z prenosnim nacinom",
    "Impossibile iniziare la modalita' di trasferimento!",
    "Kan Transfer-Mode niet starten",
    "Impossvel iniciar modo de transferncia!",
    "Impossible d'utiliser le mode transfert!",
    "Kan ikke starte transfer modus!",
    "Ksittmttmi teknisi ongelmia!",
    "Tryb transferowy jest niemozliwy!",
    "No puedo iniciar modo de transferencia!",
  },
  { "Can't start editing process!",
    "Schnitt kann nicht gestartet werden!",
    "Ne morem zaceti urejanja!",
    "Imposs iniziare processo di modifica",
    "Kan niet beginnen met bewerken!",
    "No pode iniciar a modificao!",
    "Impossible de commencer le montage!",
    "Kan ikke starte redigeringsprosessen!",
    "Muokkauksen aloittaminen ei onnistu!",
    "Uruchamianie montazu jest niemozliwe!",
    "No puedo iniciar proceso de modificacin!",
  },
  { "Editing process already active!",
    "Schnitt bereits aktiv!",
    "Urejanje je ze aktivno!",
    "Processo di modifica gia` attivo",
    "Bewerken is al actief!",
    "Processo de modificao j activo!",
    "Montage dj en cours!",
    "Redigeringsprosessen er allerede aktiv!",
    "Muokkaus on jo kynniss!",
    "Montaz w toku!",
    "Proceso de modificacin ya fue iniciado!",
  },
  { "Can't shutdown - option '-s' not given!",
    "Shutdown unmglich - Option '-s' fehlt!",
    "Zaustavitev ni mogoca - opcija '-s' ni podana!",
    "Impossibile spegnere - parametro '-s' non passato",
    "Shutdown onmogelijk - Optie '-s' ontbreekt!",
    "Impossvel desligar - falta a opo '-s'!",
    "Arrt impossible - option '-s' absente!",
    "Kan ikke sl av - startet uten parameteret '-s'!",
    "Ei voida sammuttaa '-s' parametria ei annettu!",
    "Wylaczenie niemozliwe - brak opcji '-s' !",
    "No puedo cortar - opcin '-s' absente!",
  },
  { "Low disk space!",
    "Platte beinahe voll!",
    "Zmanjkuje prostora na disku",
    "Poco spazio su disco!",
    "Disk bijna vol!",
    "Espao em disco reduzido!",
    "Disque presque plein!",
    "Lite ledig diskplass!",
    "Kovalevy lhes tynn!",
    "Dysk wkrotce pelny!",
    "Disco casi lleno",
  },
  // Setup pages:
  { "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Affichage des menus",
    "OSD",
    "Tekstinytt",
    "OSD",
    "OSD",
  },
  { "EPG",
    "EPG",
    "EPG",
    "EPG",
    "EPG",
    "EPG",
    "Guide des programmes",
    "Programoversikt",
    "Ohjelmaopas",
    "EPG",
    "EPG",
  },
  { "DVB",
    "DVB",
    "DVB",
    "Scheda DVB",
    "DVB",
    "DVB",
    "Cartes DVB",
    "DVB-enheter",
    "DVB",
    "DVB",
    "DVB",
  },
  { "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
  },
  { "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "Accs conditionnel",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
  },
  { "Recording",
    "Aufnahme",
    "Snemanje",
    "Registrazione",
    "Opname",
    "A gravar",
    "Enregistrement",
    "Opptak",
    "Nauhoita",
    "Nagranie",
    "Grabacin",
  },
  { "Replay",
    "Wiedergabe",
    "Predvajanje",
    "Replay",
    "Afspelen",
    "Replay",
    "Lecture",
    "Spill av",
    "Toista",
    "Odtwarzanie",
    "Poner",
  },
  { "Miscellaneous",
    "Sonstiges",
    "Ostalo",
    "Generici",
    "Overig",
    "Outros",
    "Divers",
    "Forskjellig",
    "Sekalaista",
    "Pozostale",
    "Varios",
  },
  { "Restart",
    "Neustart",
    "Ponoven zagon",
    "Restart",
    "Herstart",
    "Reiniciar",
    "Redmarrer",
    "Start p nytt",
    "Aloita uudelleen",
    "Zastartowac",
    "Reiniciar",
  },
  // Setup parameters:
  { "Setup.OSD$Language",
    "Sprache",
    "Jezik",
    "Linguaggio",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jezyk",
    "Lengua",
  },
  { "Setup.OSD$Width",
    "Breite",
    "Sirina",
    "Largh OSD",
    "Breedte",
    "Largura",
    "Largeur",
    "Bredde",
    "Leveys",
    "Szerokosc",
    "Anchura",
  },
  { "Setup.OSD$Height",
    "Hhe",
    "Visina",
    "Altezz OSD",
    "Hoogte",
    "Altura",
    "Hauteur",
    "Hyde",
    "Korkeus",
    "Wysokosc",
    "Altura",
  },
  { "Setup.OSD$Message time (s)",
    "Anzeigedauer fr Nachrichten (s)",
    "Cas sporocila (s)",
    "Tempo del messaggio (s)",
    "Weergave duur van berichten (s)",
    "Mostrar contador (s)",
    "Dure affichage cran (s)",
    "Tid meldinger skal vises (s)",
    "Ilmoitusten nkymisaika (s)",
    "Czas wyswietlania wiadomosci (s)",
    "Duracin muestra mensajes (s)",
  },
  { "Setup.OSD$Channel info position",
    "Kanal-Info Position",
    "Pozicija informacije o kanalu",
    "Posizione info canale",
    "Kanaal info positie",
    "Posio de info dos canais",
    "Position infos chanes",
    "Posisjon p kanalinformasjon",
    "Kanavainfon sijainti",
    "Lokalizacja informacji o kanale",
    "Posicin para informacin canal",
  },
  { "Setup.OSD$Info on channel switch",
    "Info beim Kanalwechsel",
    "Pokazi naziv kanala",
    "Vis info nel cambio canale",
    "Kanaal info tonen",
    "Mostrar info ao mudar de Canal",
    "Affichage progr. en cours",
    "Info ved kanalskifte",
    "Nyt kanavainfo",
    "Informacja przy zmianie kanalu",
    "Informacin para cambio de canal",
  },
  { "Setup.OSD$Scroll pages",
    "Seitenweise scrollen",
    "Drsni meni",
    "Scrolla pagina nel menu",
    "Scrollen per pagina",
    "Scroll da pgina no menu",
    "Affichage progr. suivant",
    "Rask rulling i menyer",
    "Valikkojen rullaus",
    "Przesuwac stronami",
    "Desplazar pgina entera",
  },
  { "Setup.OSD$Sort timers",
    "Timer sortieren",
    "Sortiraj termine",
    "Ordinamento timer",
    "Timers sorteren",
    "Ordenar os timers",
    "Trier les programmations",
    "Sorter timere",
    "Jrjest ajastimet",
    "Sortowanie timerow",
    "Ordenar timer",
  },
  { "Setup.OSD$Recording directories",
    "Aufnahmeverzeichnisse",
    "Direktoriji za posnetke",
    "Directory di registrazione",
    "Opname directories",
    "Directorias de gravao",
    "Dossiers d'enregistrements",
    "Kataloger til opptak",
    "Nauhoitushakemistot",
    "Wykaz nagran",
    "Directorios para grabacin",
  },
  { "Setup.EPG$EPG scan timeout (h)",
    "Zeit bis EPG Scan (h)",
    "Cas do EPG pregleda (h)",
    "Timeout EPG (h)",
    "EPG-scan Timeout (h)",
    "Expirou o EPG (h)",
    "Temps maxi EPG (h)",
    "Ledig tid fr EPG-sk (h)",
    "Ohjelmatied. odotusaika (h)",
    "Czas do skanu EPG (h)",
    "Tiempo hasta exploracin EPG (h)",
  },
  { "Setup.EPG$EPG bugfix level",
    "EPG Fehlerbereinigung",
    "Nivo za popravilo EPG napak",
    "EPG livello corr",
    "EPG foutcorrectieniveau",
    "Nvel de correcto EPG",
    "Niveau de correction EPG",
    "Niv for EPG-feilretting",
    "EPG Bugfix Level",
    "Poziom bledow EPG",
    "Nivel para arreglar EPG",
  },
  { "Setup.EPG$Set system time",
    "Systemzeit stellen",
    "Nastavi sistemski cas",
    "Settaggio orario auto",
    "Systeem klok instellen",
    "Ajustar relgio do sistema",
    "Ajuster l'heure du systme",
    "Juster system-klokken",
    "Vastaanota kellonaika",
    "Ustawianie czasu",
    "Ajustar reloj de sistema",
  },
  { "Setup.EPG$Use time from transponder",
    "Transponder fr Systemzeit",
    "Transponder za nastavitev casa",
    "Utilizza orario da transponder",
    "Gebruik transponder tijd voor systeem",
    "Usar relgio do transponder",
    "Utiliser l'heure de la chane",
    "Bruk klokke fra transponder",
    "Vastaanota kellonaika lhettimelt",
    "Transponder do ustawiania czasu",
    "Transponder para reloj de sistema",
  },
  { "Setup.DVB$Primary DVB interface",
    "Primres DVB Interface",
    "Primarna naprava",
    "Scheda DVB primaria",
    "Eerste DVB kaart",
    "Interface DVB primrio",
    "Carte DVB primaire",
    "Hoved DVB-enhet",
    "Ensisij. vast.otin",
    "Pierwotny interfejs DVB",
    "Primer interface DVB",
  },
  { "Setup.DVB$Video format",
    "Video Format",
    "Video format",
    "Formato video",
    "Videoformaat",
    "Formato vdeo",
    "Format vido",
    "TV-Format",
    "Kuvamuoto",
    "Format telewizyjny",
    "Formato Vdeo",
  },
  { "Setup.LNB$SLOF (MHz)",
    "SLOF (MHz)",
    "Frekvenca preklopa (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "Limite de bandas LNB (MHz)",
    "Limite de bandes LNB (MHz)",
    "LO-grensefrekvens (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
  },
  { "Setup.LNB$Low LNB frequency (MHz)",
    "Untere LNB-Frequenz (MHz)",
    "Spodnja LNB-frek. (MHz)",
    "Freq LO LNB (MHz)",
    "Laagste LNB frequentie (MHz)",
    "Frequncia base LNB (MHz)",
    "Frquence basse LNB (MHz)",
    "LO-frekvens i lavbndet (MHz)",
    "LO LNB taajuus (MHz)",
    "Dolna czestotliwosc LNB (MHz)",
    "Frecuencia baja LNB (MHz)",
  },
  { "Setup.LNB$High LNB frequency (MHz)",
    "Obere LNB-Frequenz (MHz)",
    "Zgornja LNB-frek. (MHz)",
    "Freq HI LNB (MHz)",
    "Hoogste LNB frequentie (MHz)",
    "Frequncia alta LNB (MHz)",
    "Frquence haute LNB (MHz)",
    "LO-frekvens i hybndet (MHz)",
    "HI LNB taajuus (MHz)",
    "Gorna czestotliwosc LNB (MHz)",
    "Frecuencia alta LNB (MHz)",
  },
  { "Setup.LNB$Use DiSEqC",
    "DiSEqC benutzen",
    "Uporabi DiSEqC",
    "Utilizza DiSEqC",
    "DiSEqC gebruiken",
    "Utilizar DiSEqC",
    "Utiliser le DiSEqC",
    "Bruk DiSEqC",
    "Kyt DiSEqC",
    "Uzywac DiSEqC",
    "Utilizar DiSEqC",
  },
  { "Setup.CICAM$CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Accs conditionnel",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
  },
  { "Setup.Recording$Margin at start (min)",
    "Zeitpuffer bei Anfang (min)",
    "Premor pred zacetkom (min)",
    "Min margine inizio (min)",
    "Tijd marge begin (min)",
    "Margem inicial (min)",
    "Marge antrieure (min)",
    "Opptaksmargin start (min)",
    "Aloitusmarginaali (min)",
    "Poczatkowy czas buforowy (min)",
    "Comenzar grabacin antes (min)",
  },
  { "Setup.Recording$Margin at stop (min)",
    "Zeitpuffer bei Ende (min)",
    "Premor za koncem (min)",
    "Min margine fine (min)",
    "Tijd marge eind (min)",
    "Margem final (min)",
    "Marge postrieure (min)",
    "Opptaksmargin slutt (min)",
    "Lopetusmarginaali (min)",
    "Koncowy czas buforowy (min)",
    "Cortar grabacin despus (min)",
  },
  { "Setup.Recording$Primary limit",
    "Primr-Limit",
    "Osnovna meja",
    "Limite primario",
    "Eerste grens",
    "Limite Primrio",
    "Premire limite",
    "Prioritetsgrense HovedDVB",
    "PrimaryLimit",
    "Pierwotny limit",
    "L'mite primario",
  },
  { "Setup.Recording$Default priority",
    "Default Prioritt",
    "Osnovna prioriteta",
    "Priorita' predefinita",
    "Standaard prioriteit",
    "Prioridade por defeito",
    "Priorit par dfaut",
    "Normal prioritet (Timer)",
    "Oletusprioriteetti",
    "Priorytet pierwotny",
    "Prioridad predefinida",
  },
  { "Setup.Recording$Default lifetime (d)",
    "Default Lebensdauer (d)",
    "Osnovni zivljenski cas (d)",
    "Durata predefinita (d)",
    "Standaard levensduur (d)",
    "Validade por defeito (d)",
    "Dure de vie par dfaut (d)",
    "Normal levetid timer (d)",
    "Oletus voimassaoloaika (d)",
    "Pierwotna trwalosc (d)",
    "Duracin predefinida",
  },
  { "Setup.Recording$Use episode name",
    "Episodenname verwenden",
    "Uporabi ime epizode",
    "Utilizza il nome dell'episodio",
    "Gebruik episode naam",
    "Utilizar o nome do episdio",
    "Utiliser le nom de l'pisode",
    "Bruk episodenavn",
    "Kyt jakson nime",
    "Czy uzywac nazwe epizodu",
    "Utilizar nombre de episodo",
  },
  { "Setup.Recording$Mark instant recording",
    "Direktaufzeichnung markieren",
    "Oznaci direktno snemanje",
    "Marca la registrazione",
    "Direkte opnamen markeren",
    "Marca de gravao rpida",
    "Enregistrement immdiat",
    "Markere direkteopptak",
    "Merkitse vlitn nauh.",
    "Zaznaczyc natychm. nagranie",
    "Marcar grabaciones instantneas",
  },
  { "Setup.Recording$Name instant recording",
    "Direktaufzeichnung benennen",
    "Ime za direktno snemanje",
    "Nome registrazione istantanea",
    "Naam direkt-opname",
    "Nome de gravao rpida",
    "Noms enregistr. immdiats",
    "Navngi direkteopptak",
    "Nime vlitn nauh.",
    "Nazwac natychm. nagranie",
    "Nombrar grabaciones instantneas",
  },
  { "Setup.Recording$Record Dolby Digital",
    "Dolby Digital Ton aufzeichnen",
    "Posnemi dolby digital",
    "Registra dolby digital",
    "Dolby Digital geluid opnamen",
    "Gravar em Dolby Digital",
    "Enregistrer en Dolby Digital",
    "Ta opp Dolby Digital lyd",
    "Dolby Digital nauhoitus",
    "Nagrywac Dolby Digital",
    "Grabar sonido Dolby Digital",
  },
  { "Setup.Recording$Max. video file size (MB)",
    "Max. Video Dateigre (MB)",
    "Najvecja velikost datoteke (MB)",
    "Dimensione massima file video (MB)",
    "Maximale omvang video file (MB)",
    "Tamanho mximo dos ficheiros (MB)",
    "Taille maxi des fichiers (MB)",
    "Maksimal strrelse p videofiler (MB)",
    "Maksimi tiedoston koko (MB)",
    "Maks. wielkosc pliku (MB)",
    "Tamao mx. ficheros (MB)",
  },
  { "Setup.Recording$Split edited files",
    "Editierte Dateien aufteilen",
    "Razdeli urejene datoteke",
    "Dividi i file modificati",
    "Bewerkte files opdelen",
    "Quebrar ficheiros",
    "Sparer les squences",
    "Splitt redigerte filer",
    "Paloittele muokatut",
    "Dzielic montowane pliki",
    "Quebrar ficheros",
  },
  { "Setup.Replay$Multi speed mode",
    "MultiSpeed Modus",
    "Rezim z vec hitrostmi",
    "Modalita' multispeed",
    "Multi-speed mode",
    "Modo de multi-speed",
    "Mode multi-vitesses",
    "Multispeed modus",
    "Moninopeustila",
    "Tryb wielopredkosciowy",
    "Modo multi-velocidad",
  },
  { "Setup.Replay$Show replay mode",
    "Wiedergabestatus anzeigen",
    "Prikazi rezim predvajanja",
    "Modalita' di visualizz su replay",
    "Weergave mode aangeven",
    "Mostrar modo de replay",
    "Affichage mode de lecture",
    "Vis avspillingsmodus",
    "Nyt toiston tila",
    "Wyswietlac status odtwarzania",
    "Mostrar modo de replay",
  },
  { "Setup.Miscellaneous$Min. event timeout (min)",
    "Mindest Event Pause (min)",
    "Najmanjsi cas dogodka (min)",
    "Tempo minimo di pausa (min)", // ??? i don't know...
    "Minimale event time-out (min)",
    "Perodo mnimo de pausa (min)",
    "MinEventTimeout (min)", // Too difficult to translate - read the manual!
    "Minste hendelsespause (min)",
    "Minimi tapahtuman odotus (min)",
    "Min. czas do nast. akcji (Event) (min)",
    "Tiempo mnimo pausa (min)",
  },
  { "Setup.Miscellaneous$Min. user inactivity (min)",
    "Mindest Benutzer-Inaktivitt (min)",
    "Najmanjsi cas neaktivnosti (min)",
    "Tempo minimo di inattivita' (min)",
    "Minimum gebruikers inactiviteit (min)",
    "Perodo mnimo de inactividade (min)",
    "Dure minimale d'inactivit (min)",
    "Minimumstid med inaktivitet (min)",
    "Minimi kyttjn odotus (min)",
    "Min. brak aktywnosci uzytkownika (min)",
    "Tiempo mnimo inactividad (min)",
  },
  { "Setup.Miscellaneous$SVDRP timeout (min)",
    "SVDRP Timeout (min)",
    "SVDRP Timeout (min)",
    "Timeout SVDRP (min)",
    "SVDRP Timeout (min)",
    "Timeout SVDRP (min)",
    "Temps maxi SVDRP (min)",
    "Ubrukt SVDRP-levetid (min)",
    "SVDRP odotusaika (min)",
    "Min. brak aktywnosci SVDRP (min)",
    "SVDRP interrupcin (min)",
  },
  // The days of the week:
  { "MTWTFSS",
    "MDMDFSS",
    "PTSCPSN",
    "DLMMGVS",
    "MDWDVZZ",
    "STQQSSD",
    "LMMJVSD",
    "MTOTFLS",
    "MTKTPLS",
    "PWSCPSN",
    "LMMJVSD",
  },
  { "MonTueWedThuFriSatSun", // must all be 3 letters!
    "MonDieMitDonFreSamSon",
    "PonTorSreCetPetSobNed",
    "LunMarMerGioVenSabDom",
    "MaaDinWoeDonVryZatZon",
    "SegTerQuaQuiSexSabDom",
    "LunMarMerJeuVenSamDim",
    "ManTirOnsTorFreLrSn",
    "MaaTiiKesTorPerLauSun",
    "PonWtoSroCzwPiaSobNie",
    "LunMarMieJueVieSabDom",
  },
  // Learning keys:
  { "Learning Remote Control Keys",
    "Fernbedienungs-Codes lernen",
    "Ucim se kod upravljalca",
    "Apprendimento tasti unita` remota",
    "Leren toetsen afstandsbediening",
    "Aprender as teclas do telecomando",
    "Apprentissage des codes de tlcommande",
    "Lre fjernkontrolltaster",
    "Kaukostimen nppinten opettelu",
    "Nauka kodu pilota",
    "Aprendiendo teclas del telemando",
  },
  { "Phase 1: Detecting RC code type",
    "Phase 1: FB Code feststellen",
    "Faza 1: Sprejemanje IR kode",
    "Fase 1: tipo ricevitore RC",
    "Fase 1: detecteren type afstandsbediening",
    "Fase 1: detectar tipo de receptor",
    "Phase 1: Dtection du type de code",
    "Fase 1: Finne fjernkontroll-kodetype",
    "Vaihe 1: Lhetystavan selvittminen",
    "Faza 1: Detekcja typu kodu",
    "Fase 1: Detectando tipo de receptor",
  },
  { "Press any key on the RC unit",
    "Eine Taste auf der FB drcken",
    "Pritisnite tipko na upravljalcu",
    "Premere un tasto nell'unita` RC",
    "Druk op een willekeurige knop",
    "Pressione qualquer tecla do telecomando",
    "Appuyer sur une touche de la tlcommande",
    "Trykk en av tastene p fjernkontrollen",
    "Paina mit tahansa kaukostimen nppint",
    "Nacisnac klawisz pilota",
    "Pulse una tecla en el telemando",
  },
  { "RC code detected!",
    "FB Code erkannt!",
    "IR koda sprejeta!",
    "Codice RC rilevato!",
    "Afstandsbediening code herkend!",
    "Cdigo do telecomando detectado!",
    "Code de la tlcommande dtect!",
    "Fjernkontroll-kodetype funnet!",
    "Nppinpainallus vastaanotettu!",
    "Kod pilota zostal poznany!",
    "Cdigo detectado!",
  },
  { "Do not press any key...",
    "Keine Taste drcken...",
    "Ne pritiskajte tipk...",
    "Non premere alcun tasto...",
    "Druk niet op een knop...",
    "No pressione nada...",
    "N'appuyer sur aucune touche ...",
    "Ikke trykk p noen av tastene...",
    "l paina mitn nppint...",
    "Nie naciskac klawiszy...",
    "No pulse tecla...",
  },
  { "Phase 2: Learning specific key codes",
    "Phase 2: Einzelne Tastencodes lernen",
    "Faza 2: Ucenje posebnih kod",
    "Fase 2: Codici specifici dei tasti",
    "Fase 2: Leren specifieke toets-codes",
    "Fase 2: A aprender cdigos especificos",
    "Phase 2: Apprentissage des codes des touches",
    "Fase 2: Lre spesifikke tastekoder",
    "Vaihe 2: Nppinkoodien opettelu",
    "Faza 2: Nauka pojedynczych klawiszy",
    "Fase 2: Aprendiendo cdigos especficos",
  },
  { "Press key for '%s'",
    "Taste fr '%s' drcken",
    "Pritisnite tipko za '%s'",
    "Premere il tasto per '%s'",
    "Druk knop voor '%s'",
    "Pressione tecla para '%s'",
    "Appuyer sur la touche '%s'",
    "Trykk tasten for '%s'",
    "Paina nppint toiminnolle '%s'",
    "Nacisnac klawisz dla '%s'",
    "Pulsar tecla para '%s'",
  },
  { "Press 'Up' to confirm",
    "'Auf' drcken zum Besttigen",
    "Pritisnite tipko 'Gor' za potrditev",
    "Premere 'Su' per confermare",
    "Druk 'Omhoog' om te bevestigen",
    "Pressione 'Cima' para confirmar",
    "Appuyer sur 'Haut' pour confirmer",
    "Trykk 'Opp' for  bekrefte",
    "Paina 'Yls' hyvksyksesi",
    "Nacisnac 'Gora' do potwierdzenia",
    "Pulse 'Arriba' para confirmar",
  },
  { "Press 'Down' to continue",
    "'Ab' drcken zum Weitermachen",
    "Pritisnite tipko 'Dol' za nadaljevanje",
    "Premere 'Giu' per confermare",
    "Druk 'Omlaag' om verder te gaan",
    "Pressione 'Baixo' para continuar",
    "Appuyer sur 'Bas' pour continuer",
    "Trykk Ned' for  fortsette",
    "Paina 'Alas' jatkaaksesi",
    "Nacisnac 'Dol' zeby kontynuowac",
    "Pulse 'Abajo' para confirmar",
  },
  { "(press 'Up' to go back)",
    "('Auf' drcken um zurckzugehen)",
    "(pritisnite 'Gor' za nazaj)",
    "(premere 'Su' per tornare indietro)",
    "(druk 'Omhoog' om terug te gaan)",
    "(Pressione 'Cima' para voltar)",
    "(Appuyer sur 'Haut' pour revenir en arrire)",
    "(trykk 'Opp' for  g tilbake)",
    "(paina 'Yls' palataksesi takaisin)",
    "(Nacisnac 'Gora' cofa)",
    "(Pulse 'Arriba' para retornar)",
  },
  { "(press 'Down' to end key definition)",
    "('Ab' drcken zum Beenden)",
    "(pritisnite 'Dol' za konec)",
    "('Giu' per finire la definiz tasti)",
    "(Druk 'Omlaag' om te beeindigen)",
    "(Pressione 'Baixo' para terminar a definio)",
    "(Appuyer sur 'Bas' pour terminer)",
    "(trykk 'Ned' for  avslutte innlring)",
    "(paina 'Alas' lopettaaksesi nppinten opettelun)",
    "(Nacisnac 'Dol' by zakonczyc)",
    "(Pulse 'Abajo' para terminar programacin teclas)",
  },
  { "Phase 3: Saving key codes",
    "Phase 3: Codes abspeichern",
    "Faza 3: Shranjujem kodo",
    "Fase 3: Salvataggio key codes",
    "Fase 3: Opslaan toets codes",
    "Fase 3: A salvar os cdigos das teclas",
    "Phase 3: Sauvegarde des codes des touches",
    "Fase 3: Lagre tastekoder",
    "Vaihe 3: Nppinkoodien tallettaminen",
    "Faza 3: Zapamietac Kod",
    "Fase 3: Guardar cdigos de teclas",
  },
  { "Press 'Up' to save, 'Down' to cancel",
    "'Auf' speichert, 'Ab' bricht ab",
    "'Gor' za potrditev, 'Dol' za prekinitev",
    "'Su' per salvare, 'Giu' per annullare",
    "'Omhoog' te bewaren, 'Omlaag' voor annuleren",
    "'Cima' para Salvar, 'Baixo' para Cancelar",
    "Appuyer sur 'Haut' pour sauvegarder, 'Bas' pour annuler",
    "Trykk 'Opp' for  lagre, 'Ned' for  avbryte",
    "Paina 'Yls' tallettaaksesi ja 'Alas' peruuttaaksesi",
    "'Gora' zapamietuje, 'Dol' przerywa",
    "Pulse 'Arriba' para guarder, 'Abajo' para anular",
  },
  // Key names:
  { "Up",
    "Auf",
    "Gor",
    "Su",
    "Omhoog",
    "Cima",
    "Haut",
    "Opp",
    "Yls",
    "Gora",
    "Arriba",
  },
  { "Down",
    "Ab",
    "Dol",
    "Giu",
    "Omlaag",
    "Baixo",
    "Bas",
    "Ned",
    "Alas",
    "Dol",
    "Abajo",
  },
  { "Menu",
    "Men",
    "Meni",
    "Menu",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Menu",
  },
  { "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
  },
  { "Back",
    "Zurck",
    "Nazaj",
    "Indietro",
    "Terug",
    "Voltar",
    "Retour",
    "Tilbake",
    "Takaisin",
    "Wstecz",
    "Retornar",
  },
  { "Left",
    "Links",
    "Levo",
    "Sinistra",
    "Links",
    "Esquerda",
    "Gauche",
    "Venstre",
    "Vasemmalle",
    "Lewo",
    "Izquierda",
  },
  { "Right",
    "Rechts",
    "Desno",
    "Destra",
    "Rechts",
    "Direita",
    "Droite",
    "Hyre",
    "Oikealle",
    "Prawo",
    "Derecha",
  },
  { "Red",
    "Rot",
    "Rdeca",
    "Rosso",
    "Rood",
    "Vermelho",
    "Rouge",
    "Rd",
    "Punainen",
    "Czerwony",
    "Rojo",
  },
  { "Green",
    "Grn",
    "Zelena",
    "Verde",
    "Groen",
    "Verde",
    "Vert",
    "Grnn",
    "Vihre",
    "Zielony",
    "Verde",
  },
  { "Yellow",
    "Gelb",
    "Rumena",
    "Giallo",
    "Geel",
    "Amarelo",
    "Jaune",
    "Gul",
    "Keltainen",
    "Zolty",
    "Amarillo",
  },
  { "Blue",
    "Blau",
    "Modra",
    "Blu",
    "Blauw",
    "Azul",
    "Bleu",
    "Bl",
    "Sininen",
    "Niebieski",
    "Azul",
  },
  { "Power",
    "Ausschalten",
    "Izklop",
    "Power",
    "Uitschakelen",
    "Ligar",
    "Arrt",
    "Power",
    "Virtakytkin",
    "Wylaczyc",
    "Corriente",
  },
  { "Volume+",
    "Lautstrke+",
    "Glasnost+",
    "Volume+",
    "Volume+",
    "Volume+",
    "Volume+",
    "Volum+",
    "nenvoimakkuus+",
    "Glosnej",
    "Volumen+",
  },
  { "Volume-",
    "Lautstrke-",
    "Glasnost-",
    "Volume-",
    "Volume-",
    "Volume-",
    "Volume-",
    "Volum-",
    "nenvoimakkuus-",
    "Ciszej",
    "Volumen-",
  },
  { "Mute",
    "Stumm",
    "Izklop zvoka",
    "Mute",
    "Geluid onderbreken",
    "Sem som",
    "Coupure du son",
    "Lyd av",
    "nen vaimennus",
    "Cisza",
    "Mudo",
  },
  // Miscellaneous:
  { "yes",
    "ja",
    "da",
    "si",
    "ja",
    "sim",
    "oui",
    "ja",
    "kyll",
    "tak",
    "s",
  },
  { "no",
    "nein",
    "ne",
    "no",
    "nee",
    "no",
    "non",
    "nei",
    "ei",
    "nie",
    "no",
  },
  { "top",
    "oben",
    "zgoraj",
    "limite sup",
    "boven",
    "topo",
    "haut",
    "vre",
    "yl",
    "gora",
    "parte sup.",
  },
  { "bottom",
    "unten",
    "spodaj",
    "limite inf",
    "onder",
    "fundo",
    "bas",
    "nedre",
    "ala",
    "dol",
    "fondo",
  },
  { "Disk",
    "Disk",
    "Disk",
    "Disk",
    "Disk",
    "Disk",
    "Disque",
    "Disk",
    "Disk",
    "Disk",
    "Disco",
  },
  { "free",
    "frei",
    "prosto",
    "liberi",
    "vrij",
    "livre",
    "restant",
    "ledig",
    "vapaa",
    "pozostalo",
    "libre",
  },
  { "Jump: ", // note the trailing blank
    "Springen: ",
    "Skoci: ",
    "Vai a: ",
    "Springen: ",
    "Saltar: ",
    "Accs direct: ",
    "Hopp: ",
    "Hypp: ",
    "Skok: ",
    "Saltar: ",
  },
  { "Volume ", // note the trailing blank
    "Lautstrke ",
    "Glasnost ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volum ",
    "nenvoimakkuus ",
    "Glosnosc ",
    "Volumen ",
  },
  { " Stop replaying", // note the leading blank!
    " Wiedergabe beenden",
    " Prekini ponavljanje",
    " Interrompi riproduzione",
    " Stop afspelen",
    " Parar reproduo",
    " Arrter la lecture",
    " Stopp avspilling",
    " Pysyt toisto",
    " Zatrzymac odtwarzanie",
    " Parar reproducin",
  },
  { " Stop recording ", // note the leading and trailing blanks!
    " Aufzeichnung beenden ",
    " Prekini shranjevanje ",
    " Interrompi registrazione ",
    " Stop opnemen ",
    " Parar gravao ",
    " Arrter l'enregistrement ",
    " Stopp opptak fra ",
    " Pysyt nauhoitus ",
    " Zatrzymac nagrywanie ",
    " Parar grabacin ",
  },
  { " Cancel editing", // note the leading blank!
    " Schneiden abbrechen",
    " Prekini urejanje",
    " Annulla modifiche",
    " Bewerken afbreken",
    " Anular modificao",
    " Annuler le montage",
    " Avbryt redigering",
    " Peruuta muokkaus",
    " Przerwac montaz ",
    " Anular modificacin ",
  },
  { "Switching primary DVB...",
    "Primres Interface wird umgeschaltet...",
    "Preklapljanje primarne naprave...",
    "Cambio su card DVB primaria...",
    "Eerste DVB-kaart wordt omgeschakeld...",
    "A mudar interface DVB primrio...",
    "Changement de carte DVB primaire...",
    "Bytter frste DVB-enhet..."
    "Vaihdetaan ensisijainen vastaanotin...",
    "Pierwszy interfejs DVB przelacza...",
    "Cambio interface primario...",
  },
  { "Up/Dn for new location - OK to move",
    "Auf/Ab fr neue Position - dann OK",
    "Gor/Dol za novo poz. - Ok za premik",
    "Su/Giu per nuova posizione - OK per muovere",
    "Gebruik Omhoog/Omlaag - daarna Ok",
    "Cima/Baixo para nova localizao - Ok para mover",
    "Haut/Bas -> nouvelle place - OK -> dplacer",
    "Opp/Ned for ny plass - OK for  flytte",
    "Yls/Alas = liiku, OK = siirr",
    "Gora/Dol na nowa pozycje - Ok zmienia",
    "Arriba/Abajo para nuevo lugar - OK para mover",
  },
  { "Editing process started",
    "Schnitt gestartet",
    "Urejanje se je zacelo",
    "Processo di modifica iniziato",
    "Bewerken is gestart",
    "Processo de modificao iniciado",
    "Opration de montage lance",
    "Redigeringsprosess startet",
    "Muokkaus aloitettu",
    "Uruchomiony proces montazu",
    "Proceso modificacin iniciado",
  },
  { "Editing process finished",
    "Schnitt beendet",
    "Proces urejanja koncan",
    "Processo di modifica terminato",
    "Bewerken is klaar",
    "Processo de modificao terminado",
    "Montage termin",
    "Redigeringsprosess avsluttet",
    "Muokkaus lopetettu",
    "Proces montazu zakonczony",
    "Proceso modificacion terminado",
  },
  { "Editing process failed!",
    "Schnitt gescheitert!",
    "Napaka pri procesu urejenja!",
    "Processo di modifica fallito!",
    "Bewerken is mislukt!",
    "Falha no processo de modificao",
    "Echec du montage!",
    "Feil under redigering!",
    "Muokkaus eponnistui!",
    "Bledny proces montazu!",
    "Modificacin ha fallado!",
  },
  { "scanning recordings...",
    "Aufzeichnungen werden durchsucht...",
    "iskanje posnetkov...",
    "scansione registrazioni...",
    "Doorzoeken opnames...",
    "A pesquisar gravaes...",
    "Recherche des enregistrements...",
    "Gr igjennom opptakene...",
    "haetaan nauhoituksia...",
    "Skan nagran...",
    "buscando grabaciones...",
  },
  { NULL }
  };

const char *tr(const char *s)
{
  if (Setup.OSDLanguage) {
     for (const tPhrase *p = Phrases; **p; p++) {
         if (strcmp(s, **p) == 0) {
            const char *t = (*p)[Setup.OSDLanguage];
            if (t && *t)
               return t;
            }
         }
     esyslog(LOG_ERR, "no translation found for '%s' in language %d (%s)\n", s, Setup.OSDLanguage, Phrases[0][Setup.OSDLanguage]);
     }
  const char *p = strchr(s, '$');
  return p ? p + 1 : s;
}

const char * const * Languages(void)
{
  return &Phrases[0][0];
}

