<?php
/*
 * Copyright 2002 - 2003 by Gero Kohnert
 *
 * Group of Interest Management
 *
 * @modulegroup group
 * @module group_new
 * @package group
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'permission.p3';
 include_once 'webelements.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("group","new");
 loadmodule("group");
 loadlayout();

 /**
  * change/modify a CRM group
  */
 class group_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"groupnew\" action=\"group_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";
     if ($this->obj->id > 0 ) {
       $this->addHidden("id", $this->obj->id );
       echo "<tr>\n";
       echo " <td colspan=\"3\">". sprintf ($lang['BugCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['GroupName'],1,"name");
     echo " <td colspan=\"3\" valign=\"top\"><input id=\"name\" size=\"". min($table['group1']['name'][size],30) ."\" maxlength=\"".$table['group1']['name'][size]."\" name=\"name\" value=\"". $this->obj->name ."\"></td>";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['GroupDesc'],0,"desc");
     echo " <td colspan=\"3\" valign=\"top\"><input id=\"desc\" size=\"". min($table['group1']['description'][size],60) ."\" maxlength=\"".$table['group1']['description'][size]."\" name=\"desc\" value=\"". $this->obj->desc ."\"></td>";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";

       if ($this->obj->id > 0 ) {
         submit_reset(0,1,1,1,1,0);
       } else {
         submit_reset(0,-1,1,1,1,0);
       }

       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("groupnew.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $tutos,$lang;

     $this->obj = new group($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name = $lang['GroupModify'] .": ". $this->obj->getFullName();
     } else {
       $this->name = $lang['GroupCreate'];
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->desc = StripSlashes($_GET['desc']);
     }
     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $m = group::getOverviewLink($this->user,$lang['Groups']);
	 $m[category][] = "obj";
     $this->addMenu($m);
     if ( $this->user->feature_ok(usegroups,PERM_NEW) ) {
       $x = array( url => "group/group_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['GroupCreate'],
                   category => array("group","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "group/group_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => $lang['Delete'] ." ". $this->obj->getFullname(),
                   confirm => true,
                   category => array("group","del","obj")
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new group_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: group_new.php,v 1.19.2.1 2003/07/14 17:49:52 gokohnert Exp $
    $Author: gokohnert $
-->
