# Makefile for zlib
# Copyright (C) 1995-1996 Jean-loup Gailly.
# For conditions of distribution and use, see copyright notice in zlib.h 
INCLUDE=$(INCLUDE);../../win32

# To compile and test, type:
#   ./configure; make test
# The call of configure is optional if you don't have special requirements

# To install /usr/local/lib/zlib.* and /usr/local/include/zlib.h, type:
#    make install
# To install in $HOME instead of /usr/local, use:
#    make install prefix=$HOME

!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

c_auto_h_dir = $(kpathsea_srcdir)

VER=1.0.4

DEFS= $(DEFS) $(ZLIB_FLAGS)

!IFDEF ZLIB_DLL
ZLIB=$(objdir)\zlib.lib $(objdir)\zlib.dll
DEFS = $(DEFS) -DMAKE_ZLIB_DLL
!ELSE
ZLIB=$(objdir)\zlib.lib
!ENDIF

OBJS = $(objdir)\adler32.obj $(objdir)\compress.obj $(objdir)\crc32.obj      \
	$(objdir)\gzio.obj $(objdir)\uncompr.obj $(objdir)\deflate.obj       \
	$(objdir)\trees.obj $(objdir)\zutil.obj $(objdir)\inflate.obj        \
	$(objdir)\infblock.obj $(objdir)\inftrees.obj $(objdir)\infcodes.obj \
	$(objdir)\infutil.obj $(objdir)\inffast.obj

TEST_OBJS = $(objdir)\example.obj $(objdir)\minigzip.obj

DISTFILES = README INDEX ChangeLog configure Make*[a-z0-9] descrip.mms \
	    zlib.def zlib.rc algorithm.doc  *.[ch]

# CFLAGS = $(CFLAGS) -Og-

all: $(objdir) $(ZLIB)

lib: $(objdir) $(ZLIB)

!IFDEF ZLIB_DLL

$(objdir)\zlib.lib: $(objdir) $(win32defdir)\zlib.def $(OBJS)
	$(archive_command) /DEF:$(win32defdir)\zlib.def $(OBJS)

$(objdir)\zlib.dll: $(OBJS) $(objdir)\zlib.lib $(objdir)\zlib.res $(gnuw32lib)
	$(dll_command) $(OBJS) $(objdir)\zlib.exp $(objdir)\zlib.res $(LIBS)
!ELSE

$(objdir)\zlib.lib: $(objdir) $(OBJS)
	$(archive_command) $(OBJS)
!ENDIF

test: all $(objdir)\example.exe $(objdir)\minigzip.exe
	.\$(objdir)\example.exe
	echo hello world | .\$(objdir)\minigzip | .\$(objdir)\minigzip -d 


$(objdir)\example.exe: $(objdir)\example.obj $(ZLIB)
	$(link_command) /OUT:$@ $(objdir)\example.obj $(objdir)\zlib.lib $(LIBS)

$(objdir)\minigzip.exe: $(objdir)\minigzip.obj $(ZLIB)
	$(link_command) /OUT:$@ $(objdir)\minigzip.obj $(objdir)\zlib.lib $(LIBS)

install: $(ZLIB)
	$(mktexdir) $(toolsprefix)\include $(toolsprefix)\lib \
	$(toolsprefix)\bin $(bindir) $(includedir) $(libdir) \
	$(man3dir)
	$(CP) zlib.h $(toolsprefix)\include
	$(CP) zconf.h $(toolsprefix)\include
	$(CP) $(objdir)\zlib.lib $(toolsprefix)\lib
	$(CP) zlib.h $(includedir)
	$(CP) zconf.h $(includedir)
	$(CP) $(objdir)\zlib.lib $(libdir)
	$(CP) zlib.3 $(man3dir)
!IFDEF ZLIB_DLL
	$(CP) $(objdir)\zlib.dll $(toolsprefix)\bin
	$(CP) $(objdir)\zlib.dll $(bindir)
!ENDIF

uninstall:

!include <make/man.mak>
!include <make/clean.mak>
!include <make/tkpathsea.mak>
!include <make/version.mak>

mostlyclean clean::
	-@$(RM) $(objdir)\minigzip.exe  $(objdir)\zlib.lib  $(objdir)\zlib.dll foo.gz

tags:	
	etags *.[ch]

#depend:
#	makedepend -- $(CFLAGS) -- *.[ch]
!include <make/rdepend.mak>
!include "./depend.mak"

#
# Local Variables:
# mode: makefile
# End:
