#include <TTreeNodes.h>

#include <gtk/gtkhbox.h>
#include <gtk/gtklabel.h>
#include <stdio.h>

TTreeNodes::TTreeNodes(TCustomTreeView *AOwner) {
	FOwner = AOwner;
}


TTreeNodes::~TTreeNodes() {
}


/*
procedure TTreeNodes.Clear;
begin
  ClearCache;
  if Owner.HandleAllocated then
    TreeView_DeleteAllItems(Handle);
end;

*/
void TTreeNodes::Clear() {
	gtk_tree_remove_items(GTK_TREE(FOwner->nativeControl), GTK_TREE(FOwner->nativeControl)->children);
	nodeCache.erase(nodeCache.begin(), nodeCache.end());
}


/*
function TTreeNodes.GetFirstNode: TTreeNode;
begin
  Result := GetNode(TreeView_GetRoot(Handle));
end;
*/

TTreeNode *TTreeNodes::GetFirstNode() {
	GList *first = g_list_first(GTK_TREE(FOwner->nativeControl)->children);
	return (first) ? GetNode(GTK_TREE_ITEM(first->data)) : 0;
}

/*
function TTreeNodes.GetNode(ItemId: HTreeItem): TTreeNode;
var
  Item: TTVItem;
begin
  with Item do
  begin
    hItem := ItemId;
    mask := TVIF_PARAM;
  end;
  if TreeView_GetItem(Handle, Item) then Result := TTreeNode(Item.lParam)
  else Result := nil;
end;
*/

TTreeNode *TTreeNodes::GetNode(GtkTreeItem *subElement) {
	TTreeNodeMap::iterator node;
	node = nodeCache.find(subElement);
	if (node != nodeCache.end())
		return &(node->second);
	else return 0;
}


GtkTreeItem *TTreeNodes::GetParentNode(GtkTreeItem *root, GtkTreeItem *subElement) {
	GtkWidget *subtree = root->subtree;
	if (subtree) {
		for (GList *nodes = GTK_TREE(subtree)->children; nodes; nodes = g_list_next(nodes)) {
			if (nodes->data == subElement)
				return root;
			GtkTreeItem *ret = GetParentNode(GTK_TREE_ITEM(nodes->data), subElement);
			if (ret)
				return ret;
		}
	}
	return 0;
}


TTreeNode *TTreeNodes::GetParentNode(TTreeNode *target) {
	for (GList *nodes = g_list_first(GTK_TREE(FOwner->nativeControl)->children); nodes; nodes = g_list_next(nodes)) {
		if (nodes->data == target->nativeControl)
			return 0;	// top level; no parent
		GtkTreeItem *ret = GetParentNode(GTK_TREE_ITEM(nodes->data), target->nativeControl);
		if (ret)
			return GetNode(ret);
	}
	return 0;
}


/*
function TTreeNodes.AddChildFirst(Node: TTreeNode; const S: string): TTreeNode;
begin
  Result := AddChildObjectFirst(Node, S, nil);
end;
*/

GtkTree *TTreeNodes::getSubTree(TTreeNode *node) {
	GtkWidget *subtree;

	if (!node)
		subtree = FOwner->nativeControl;
	else {
		subtree = node->nativeControl->subtree;
		if (!subtree) {
			subtree = gtk_tree_new();
			gtk_tree_set_selection_mode (GTK_TREE(subtree), GTK_SELECTION_SINGLE);
			gtk_tree_set_view_mode (GTK_TREE(subtree), GTK_TREE_VIEW_ITEM);
			gtk_tree_item_set_subtree (node->nativeControl, subtree);
		}
	}
	return GTK_TREE(subtree);
}


GtkTreeItem *TTreeNodes::createTreeItem(GtkWidget *parent, const char *label) {
	GtkWidget *treeitem;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkWidget *pixmap1;
	GtkWidget *pixmap2;
	GtkStyle *style;
	GdkWindow *window = 0;

	treeitem = gtk_tree_item_new ();

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (treeitem), hbox1);

	while ((!window) && (parent->parent)) {
		window = gtk_widget_get_parent_window(GTK_WIDGET(parent));
		parent = parent->parent;
	}
	style = gtk_widget_get_style( GTK_WIDGET(parent) );
	pixmap = gdk_pixmap_create_from_xpm_d( window,  &mask,
                                                &style->bg[GTK_STATE_NORMAL],
                                                (gchar **)default_xpm );

	pixmap1 = gtk_pixmap_new( pixmap, mask );
	gtk_widget_hide (pixmap1);
	gtk_box_pack_start (GTK_BOX (hbox1), pixmap1, FALSE, TRUE, 0);
	gtk_object_set_data (GTK_OBJECT (hbox1), "pixmap1", pixmap1);
	pixmap2 = gtk_pixmap_new( pixmap, mask );
	gtk_widget_hide (pixmap2);
	gtk_box_pack_start (GTK_BOX (hbox1), pixmap2, FALSE, TRUE, 0);
	gtk_object_set_data (GTK_OBJECT (hbox1), "pixmap2", pixmap2);

	label1 = gtk_label_new (label);
	gtk_widget_ref (label1);
	gtk_object_set_data (GTK_OBJECT (hbox1), "label1", label1);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 3);

	return GTK_TREE_ITEM(treeitem);
}


TTreeNode *TTreeNodes::AddChildFirst(TTreeNode *Node, const string S) {
	GtkTree *subtree;
	GtkTreeItem *item;

	subtree = getSubTree(Node);
	item = createTreeItem(GTK_WIDGET(subtree), (const char *)S.c_str());
	gtk_tree_prepend(subtree, GTK_WIDGET(item));
	gtk_widget_show(GTK_WIDGET(item));
	nodeCache.insert(TTreeNodeMap::value_type(item, TTreeNode(this, subtree, item, S)));
	return GetNode(item);
}
TTreeNode *TTreeNodes::AddChild(TTreeNode *Node, const string S) {
	GtkTree *subtree;
	GtkTreeItem *item;

	subtree = getSubTree(Node);
	item = createTreeItem(GTK_WIDGET(subtree), (const char *)S.c_str());
	gtk_tree_append(subtree, GTK_WIDGET(item));
	gtk_widget_show(GTK_WIDGET(item));
	nodeCache.insert(TTreeNodeMap::value_type(item, TTreeNode(this, subtree, item, S)));
	return GetNode(item);
}
TTreeNode *TTreeNodes::AddChildObject(TTreeNode *Node, const string S, void *Ptr) {
	GtkTree *subtree;
	GtkTreeItem *item;


	subtree = getSubTree(Node);
	item = createTreeItem(GTK_WIDGET(subtree), (const char *)S.c_str());
	gtk_tree_append(subtree, GTK_WIDGET(item));
	gtk_widget_show(GTK_WIDGET(item));
	nodeCache.insert(TTreeNodeMap::value_type(item, TTreeNode(this, subtree, item, S)));
	TTreeNode *node = GetNode(item);
	if (node)
		node->Data = Ptr;

	return node;
}

/*
function TTreeNodes.AddChildObjectFirst(Node: TTreeNode; const S: string;
  Ptr: Pointer): TTreeNode;
begin
  Result := InternalAddObject(Node, S, Ptr, taAddFirst);
end;

function TTreeNodes.InternalAddObject(Node: TTreeNode; const S: string;
  Ptr: Pointer; AddMode: TAddMode): TTreeNode;
var
  Item: HTreeItem;
begin
  Result := Owner.CreateNode;
  try
    if Node <> nil then Item := Node.ItemId
    else Item := nil;
    Result.Data := Ptr;
    Result.Text := S;
    Item := AddItem(Item, nil, CreateItem(Result), AddMode);
    if Item = nil then
      raise EOutOfResources.Create(sInsertError);
    Result.FItemId := Item;
    AddedNode(Node);
  except
    Result.Free;
    raise;
  end;
end;

function TTreeNodes.AddItem(Parent, Target: HTreeItem;
  const Item: TTVItem; AddMode: TAddMode): HTreeItem;
var
  InsertStruct: TTVInsertStruct;
begin
  ClearCache;
  with InsertStruct do
  begin
    hParent := Parent;
    case AddMode of
      taAddFirst:
        hInsertAfter := TVI_FIRST;
      taAdd:
        hInsertAfter := TVI_LAST;
      taInsert:
        hInsertAfter := Target;
    end;
  end;
  InsertStruct.item := Item;
  FOwner.FChangeTimer.Enabled := False;
  Result := TreeView_InsertItem(Handle, InsertStruct);
end;
*/


/*
{ TTreeNodes }

constructor TTreeNodes.Create(AOwner: TCustomTreeView);
begin
  inherited Create;
  FOwner := AOwner;
end;

destructor TTreeNodes.Destroy;
begin
  Clear;
  inherited Destroy;
end;

function TTreeNodes.GetCount: Integer;
begin
  if Owner.HandleAllocated then Result := TreeView_GetCount(Handle)
  else Result := 0;
end;

function TTreeNodes.GetHandle: HWND;
begin
  Result := Owner.Handle;
end;

procedure TTreeNodes.Delete(Node: TTreeNode);
begin
  if (Node.ItemId = nil) then
    Owner.Delete(Node);
  Node.Delete;
end;

function TTreeNodes.AddChild(Node: TTreeNode; const S: string): TTreeNode;
begin
  Result := AddChildObject(Node, S, nil);
end;

function TTreeNodes.AddChildObject(Node: TTreeNode; const S: string;
  Ptr: Pointer): TTreeNode;
begin
  Result := InternalAddObject(Node, S, Ptr, taAdd);
end;

function TTreeNodes.AddFirst(Node: TTreeNode; const S: string): TTreeNode;
begin
  Result := AddObjectFirst(Node, S, nil);
end;

function TTreeNodes.AddObjectFirst(Node: TTreeNode; const S: string;
  Ptr: Pointer): TTreeNode;
begin
  if Node <> nil then Node := Node.Parent;
  Result := InternalAddObject(Node, S, Ptr, taAddFirst);
end;

function TTreeNodes.Add(Node: TTreeNode; const S: string): TTreeNode;
begin
  Result := AddObject(Node, S, nil);
end;

procedure TTreeNodes.Repaint(Node: TTreeNode);
var
  R: TRect;
begin
  if FUpdateCount < 1 then
  begin
    while (Node <> nil) and not Node.IsVisible do Node := Node.Parent;
    if Node <> nil then
    begin
      R := Node.DisplayRect(False);
      InvalidateRect(Owner.Handle, @R, True);
    end;
  end;
end;

function TTreeNodes.AddObject(Node: TTreeNode; const S: string;
  Ptr: Pointer): TTreeNode;
begin
  if Node <> nil then Node := Node.Parent;
  Result := InternalAddObject(Node, S, Ptr, taAdd);
end;

function TTreeNodes.Insert(Node: TTreeNode; const S: string): TTreeNode;
begin
  Result := InsertObject(Node, S, nil);
end;

procedure TTreeNodes.AddedNode(Value: TTreeNode);
begin
  if Value <> nil then
  begin
    Value.HasChildren := True;
    Repaint(Value);
  end;
end;

function TTreeNodes.InsertObject(Node: TTreeNode; const S: string;
  Ptr: Pointer): TTreeNode;
var
  Item, ItemId: HTreeItem;
  Parent: TTreeNode;
  AddMode: TAddMode;
begin
  Result := Owner.CreateNode;
  try
    Item := nil;
    ItemId := nil;
    Parent := nil;
    AddMode := taInsert;
    if Node <> nil then
    begin
      Parent := Node.Parent;
      if Parent <> nil then Item := Parent.ItemId;
      Node := Node.GetPrevSibling;
      if Node <> nil then ItemId := Node.ItemId
      else AddMode := taAddFirst;
    end;
    Result.Data := Ptr;
    Result.Text := S;
    Item := AddItem(Item, ItemId, CreateItem(Result), AddMode);
    if Item = nil then
      raise EOutOfResources.Create(sInsertError);
    Result.FItemId := Item;
    AddedNode(Parent);
  except
    Result.Free;
    raise;
  end;
end;

function TTreeNodes.CreateItem(Node: TTreeNode): TTVItem;
begin
  Node.FInTree := True;
  with Result do
  begin
    mask := TVIF_TEXT or TVIF_PARAM or TVIF_IMAGE or TVIF_SELECTEDIMAGE;
    lParam := Longint(Node);
    pszText := LPSTR_TEXTCALLBACK;
    iImage := I_IMAGECALLBACK;
    iSelectedImage := I_IMAGECALLBACK;
  end;
end;


function TTreeNodes.GetNodeFromIndex(Index: Integer): TTreeNode;
var
  I: Integer;
begin
  if Index < 0 then TreeViewError(sInvalidIndex);
  if (FNodeCache.CacheNode <> nil) and (Abs(FNodeCache.CacheIndex - Index) <= 1) then
  begin
    with FNodeCache do
    begin
      if Index = CacheIndex then Result := CacheNode
      else if Index < CacheIndex then Result := CacheNode.GetPrev
      else Result := CacheNode.GetNext;
    end;
  end
  else begin
    Result := GetFirstNode;
    I := Index;
    while (I <> 0) and (Result <> nil) do
    begin
      Result := Result.GetNext;
      Dec(I);
    end;
  end;
  if Result = nil then TreeViewError(sInvalidIndex);
  FNodeCache.CacheNode := Result;
  FNodeCache.CacheIndex := Index;
end;

function TTreeNodes.GetNode(ItemId: HTreeItem): TTreeNode;
var
  Item: TTVItem;
begin
  with Item do
  begin
    hItem := ItemId;
    mask := TVIF_PARAM;
  end;
  if TreeView_GetItem(Handle, Item) then Result := TTreeNode(Item.lParam)
  else Result := nil;
end;

procedure TTreeNodes.SetItem(Index: Integer; Value: TTreeNode);
begin
  GetNodeFromIndex(Index).Assign(Value);
end;

procedure TTreeNodes.BeginUpdate;
begin
  if FUpdateCount = 0 then SetUpdateState(True);
  Inc(FUpdateCount);
end;

procedure TTreeNodes.SetUpdateState(Updating: Boolean);
begin
  SendMessage(Handle, WM_SETREDRAW, Ord(not Updating), 0);
  if not Updating then Owner.Refresh;
end;

procedure TTreeNodes.EndUpdate;
begin
  Dec(FUpdateCount);
  if FUpdateCount = 0 then SetUpdateState(False);
end;

procedure TTreeNodes.Assign(Source: TPersistent);
var
  TreeNodes: TTreeNodes;
  MemStream: TMemoryStream;
begin
  ClearCache;
  if Source is TTreeNodes then
  begin
    TreeNodes := TTreeNodes(Source);
    Clear;
    MemStream := TMemoryStream.Create;
    try
      TreeNodes.WriteData(MemStream);
      MemStream.Position := 0;
      ReadData(MemStream);
    finally
      MemStream.Free;
    end;
  end
  else inherited Assign(Source);
end;

procedure TTreeNodes.DefineProperties(Filer: TFiler);

  function WriteNodes: Boolean;
  var
    I: Integer;
    Nodes: TTreeNodes;
  begin
    Nodes := TTreeNodes(Filer.Ancestor);
    if Nodes = nil then
      Result := Count > 0
    else if Nodes.Count <> Count then
      Result := True
    else
    begin
      Result := False;
      for I := 0 to Count - 1 do
      begin
        Result := not Item[I].IsEqual(Nodes[I]);
        if Result then Break;
      end
    end;
  end;

begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('Data', ReadData, WriteData, WriteNodes);
end;

procedure TTreeNodes.ReadData(Stream: TStream);
var
  I, Count: Integer;
  NodeInfo: TNodeInfo;
begin
  Clear;
  Stream.ReadBuffer(Count, SizeOf(Count));
  for I := 0 to Count - 1 do
    Add(nil, '').ReadData(Stream, @NodeInfo);
end;

procedure TTreeNodes.WriteData(Stream: TStream);
var
  I: Integer;
  Node: TTreeNode;
  NodeInfo: TNodeInfo;
begin
  I := 0;
  Node := GetFirstNode;
  while Node <> nil do
  begin
    Inc(I);
    Node := Node.GetNextSibling;
  end;
  Stream.WriteBuffer(I, SizeOf(I));
  Node := GetFirstNode;
  while Node <> nil do
  begin
    Node.WriteData(Stream, @NodeInfo);
    Node := Node.GetNextSibling;
  end;
end;

procedure TTreeNodes.ClearCache;
begin
  FNodeCache.CacheNode := nil;
end;
*/
