<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: database abstraction library   
 *
 */

class acidCon {
  
  var $DB;
  var $DB_type;
  var $DB_name;
  var $DB_host;
  var $DB_port;
  var $DB_username;
  var $lastSQL;

  function acidCon($type) 
  {
     $this->DB_type = $type;
  }

  function acidConnect($database, $host, $port, $username, $password)
  {
     $this->DB = NewADOConnection();
     $this->DB_name = $database;
     $this->DB_host = $host;
     $this->DB_port = $port;
     $this->DB_username = $username;

     $db = $this->DB->Connect( ( ( $port == "") ? $host : ($host.":".$port) ),
                               $username, $password, $database); 

     if ( !$db )
     {
        echo '<P><B>Error connecting to DB : </B>'.
             $database.'@'. ( $port == "") ? $host : ($host.":".$port).
             '<P>Check the DB connection variables in <I>acid_conf.php</I> 
              <PRE>
               = $alert_dbname   : MySQL database name where the alerts are stored 
               = $alert_host     : host where the database is stored
               = $alert_port     : port where the database is stored
               = $alert_user     : username into the database
               = $alert_password : password for the username
              </PRE>
              <P>';

        echo $this->acidErrorMessage();
        die();
     } 

     return $db;
  }

  function acidPConnect($database, $host, $port, $username, $password)
  {
     $this->DB = NewADOConnection();
     $this->DB_name = $database;
     $this->DB_host = $host;
     $this->DB_port = $port;
     $this->DB_username = $username;

     $db = $this->DB->PConnect( ( ( $port == "") ? $host : ($host.":".$port) ),
                               $username, $password, $database); 

     if ( !$db )
     {
        echo '<P><B>Error (p)connecting to DB : </B>'.
             $database.'@'. ( $port == "") ? $host : ($host.":".$port).
             '<P>Check the DB connection variables in <I>acid_conf.php</I> 
              <PRE>
               = $alert_dbname   : MySQL database name where the alerts are stored 
               = $alert_host     : host where the database is stored
               = $alert_port     : port where the database is stored
               = $alert_user     : username into the database
               = $alert_password : password for the username
              </PRE>
              <P>';

        echo $this->acidErrorMessage();
        die();
     } 

     return $db;
  }

  function acidClose()
  {
     $this->DB->Close();
  }

  function acidExecute($sql, $start_row=0, $num_rows=-1, $die_on_error=true )
  {
     GLOBAL $debug_mode;

     /* Some DB support only INNER JOINs */
     //if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") ||
     //        ($this->DB_type == "maxsql") )
     //   $sql = eregi_replace("INNER JOIN", "LEFT JOIN", $sql);
     //else if ( $this->DB_type == "postgres" ) 
        //$sql = eregi_replace("LEFT JOIN", "INNER JOIN", $sql);
     //   $sql = eregi_replace("INNER JOIN", "LEFT JOIN", $sql);

     $this->lastSQL = $sql;

     /* Check whether need to add a LIMIT / TOP / ROWNUM clause */
     if ( $num_rows == -1 )
        $rs = new acidRS($this->DB->Execute($sql), $this->DB_type);
     else
     {
        $limit_str = "";
        if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || 
             ($this->DB_type == "maxsql") )
        {
           $rs =  new acidRS($this->DB->Execute($sql." LIMIT ".$start_row.", ".$num_rows),
                             $this->DB_type);
           $limit_str = " LIMIT ".$start_row.", ".$num_rows;
        }
        else if ( $this->DB_type == "postgres" )
        {
           $rs = new acidRS($this->DB->Execute($sql." LIMIT ".$num_rows." OFFSET ".$start_row),
                             $this->DB_type);
           $limit_str = " LIMIT ".$num_rows." OFFSET ".$start_row;
        }
        else 
        {
           $rs = new acidRS($this->DB->Execute($sql), $this->DB_type);
           $i = 0;
           while ( ($i < $start_row) && $rs)
           {
              if ( !$rs->row->EOF )
                 $rs->row->MoveNext();
              $i++;
           }
         }
     } 

     if ( (!$rs || $this->DB->ErrorMsg() != "") && $die_on_error )
     {
        echo '</TABLE></TABLE></TABLE>
               <FONT COLOR="#FF0000"><B>Database ERROR:</B>'.($this->DB->ErrorMsg()).'</FONT>'.
               '<P><CODE>'.( $debug_mode > 0 ? ($this->lastSQL).$limit_str : "" ).'</CODE><P>';
        die();
     }
     else
     {
        return $rs;
     }
  }

  function acidErrorMessage()
  {
     GLOBAL $debug_mode;

     if ( $this->DB->ErrorMsg() )
        return '</TABLE></TABLE></TABLE>'.
               '<FONT COLOR="#FF0000"><B>Database ERROR:</B>'.($this->DB->ErrorMsg()).'</FONT>'.
               '<P><CODE>'.( $debug_mode > 0 ? $this->lastSQL : "" ).'</CODE><P>';
  }

  function acidTableExists($table)
  {
     $table_list = $this->DB->MetaTables();

     for ( $i = 0; $i < sizeof($table_list); $i++ )
     {
        if ( $table_list[$i] == $table )
           return 1;
     }

     return 0;
  }

  function acidFieldExists($table, $field)
  {
     $sql = "SELECT ".$field." FROM ".$table;
     $result = $this->DB->Execute($sql);

     if ( !$result )
        return false;
     else
        return true;

     /*
     $field_list = $this->DB->MetaColumns($table);

     for ( $i = 0; $i <= sizeof($field_list); $i++ )
        if ( $field_list[$i]->name == $field )
           return true;

     return false;  */     
  }

  function acidIndexExists($table, $field)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
     {
        $sql = "SHOW INDEX FROM ".$table; 
        $result = $this->DB->Execute($sql);
        if ( $this->DB->ErrorMsg() != "" )
           return 0;
        else
        {
           $num = $result->RecordCount();
           $done = 0;
           for ($i = 0; $i < $num && !$done; $i++)
           {
               $myrow = $result->fields;

               if ( $myrow[4] == $field )
                  $done = 1;
 
               $result->MoveNext();
            }
            $result->Close();
        }
 
        return $done;
     }
     else
        return -1;
  }

  function acidInsertID()
  {
  /* Getting the insert ID fails on certain databases (e.g. postgres), but we may use it on the onse it works
   * on.  This function returns -1 if the dbtype is postgres, then we can run a kludgy query to get the insert 
   * ID.  That query may vary depending upon which table you are looking at and what variables you have set at
   * the current point, so it can't be here and needs to be in the actual script after calling this function
   *  -- srh (02/01/2001)
   */
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return $this->DB->Insert_ID();
     else if ($this->DB_type == "postgres" )
        return -1;   
  }

  function acidTimestampFmt($timestamp)
  {
     return $this->DB->DBTimeStamp($timestamp);
  }

  function acidSQL_YEAR($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " YEAR($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
        return " DATE_PART('year', $func_param) $op $timestamp ";  
  }

  function acidSQL_MONTH($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " MONTH($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
        return " DATE_PART('month', $func_param) $op $timestamp "; 
  }

  function acidSQL_DAY($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " DAYOFMONTH($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
        return " DATE_PART('day', $func_param) $op $timestamp "; 
  }

  function acidSQL_HOUR($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " HOUR($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
        return " DATE_PART('hour', $func_param) $op $timestamp "; 
  }

  function acidSQL_MINUTE($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " MINUTE($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
        return " DATE_PART('minute', $func_param) $op $timestamp "; 
  }

  function acidSQL_SECOND($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " SECOND($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
        return " DATE_PART('second', $func_param) $op $timestamp "; 
  }

  function acidSQL_UNIXTIME($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " UNIX_TIMESTAMP($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
     {
    
        if ( ($op == "") && ($timestamp == "") )
           /* Catches the case where I want to get the UNIXTIME of a constant
            *   i.e. DATE_PART('epoch', timestamp) > = DATE_PART('epoch', timestamp '20010124')
            *                                            (This one /\ )
            */
           //return " DATE_PART('epoch', timestamp '$func_param') ";
           return " DATE_PART('epoch', timestamp $func_param) ";
        else
           return " DATE_PART('epoch', $func_param) $op $timestamp ";
     } 
  }

  function acidSQL_TIMESEC($func_param, $op, $timestamp)
  {
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") )
        return " TIME_TO_SEC($func_param) $op $timestamp ";
     else if ( $this->DB_type == "postgres" )
     {
    
        if ( ($op == "") && ($timestamp == "") )
           return " DATE_PART('second', DATE_PART('day', '$func_param') ";
        else
           return " DATE_PART('second', DATE_PART('day', $func_param) ) $op $timestamp ";
     } 
  }

}

class acidRS {

  var $row;
  var $DB_type;

  function acidRS($id, $type) 
  {
     $this->row = $id;
     $this->DB_type = $type;
  }

  function acidFetchRow()
  {
     if ( !$this->row->EOF )
     {
        $temp = $this->row->fields;
        $this->row->MoveNext();
        return $temp;
     }
     else
        return ""; 
  }

  function acidColCount()
  {
     return $this->row->FieldCount();
  }

  function acidRecordCount()
  {
     /* MS SQL Server 7, MySQL, Sybase, and Postgres natively support this function */ 
     if ( ($this->DB_type == "mysql") || ($this->DB_type == "mysqlt") || ($this->DB_type == "maxsql") ||
          ($this->DB_type == "mssql") || ($this->DB_type == "sybase") || ($this->DB_type == "postgres") )
        return $this->row->RecordCount();

     /* Otherwise we need to emulate this functionality */
     else 
     {
          $i = 0;
          while ( !$this->row->EOF )
          {
             ++$i;
             $this->row->MoveNext();
          }

          return $i;
     }
  }

  function acidFreeRows()
  {
     $this->row->Close();
  }
}

function getSafeSQLString($str)
{
   $t = str_replace("\\", "\\\\", $str);
   $t = str_replace("'", "\'", $t);
   $t = str_replace("\"", "\\\\\"", $t);
 
   return $t;
}

function VerifyDBAbstractionLib($path)
{
  GLOBAL $debug_mode;

   if ( $debug_mode > 0 )
      echo "Checking for DB abstraction lib in '$path'<BR>";

   if ( is_file($path) )
      return true;
   else
   {
      echo '<P><B>Error loading the DB Abstraction library: </B> from "'.$path.
           '"<P>Check the DB abstraction library variable <CODE>$DBlib_path</CODE>'.
           '  in <CODE>acid_conf.php</CODE>
            <P>
            The underlying database library currently used is ADODB, that can be downloaded
            at <A HREF="http://php.weblogs.com/adodb">http://php.weblogs.com/adodb</A>';

      die();
   }
}

function NewACIDDBConnection($path, $type)
{

  if ( !(($type == "mysql") || ($type == "mysqlt") || ($type == "maxsql") ||
        ($type == "postgres")) )
  {
     echo "<B>Invalid Database Type Specified</B>".
            "<P>The variable <CODE>\$DBtype</CODE> in <CODE>acid_conf.php</CODE> was set to the ".
            "unrecognized database type of <CODE>'$type'</CODE>.  Only the following databases are ". 
            "supported: ".
            "<PRE>
                MySQL       : 'mysql'
                PostgreSQL  : 'postgres'
             </PRE>";
     die(); 
  }
 
   $last_char =  substr($path, strlen($path)-1, 1);

   if ( $last_char == "\\" || $last_char == "/" )
   {
      VerifyDBAbstractionLib($path."adodb.inc.php");
      include($path."adodb.inc.php");
   }
   else if ( strstr($path,"/") || $path == "" )
   {
      VerifyDBAbstractionLib($path."/adodb.inc.php");
      include($path."/adodb.inc.php");
   }
   else if ( strstr($path,"\\") )
   {
      VerifyDBAbstractionLib($path."\\adodb.inc.php");
      include($path."\\adodb.inc.php");
   }

   ADOLoadCode($type);

   return new AcidCon($type);
}

?>
