  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

/*
This product includes software developed by The SyncML Initiative.
*/

#ifndef PHP_SYNCML_H
#define PHP_SYNCML_H

extern zend_module_entry syncml_module_entry;
#define phpext_syncml_ptr &syncml_module_entry

#ifdef PHP_WIN32
#define PHP_SYNCML_API __declspec(dllexport)
#else
#define PHP_SYNCML_API
#endif

PHP_MINIT_FUNCTION(syncml);
PHP_MSHUTDOWN_FUNCTION(syncml);
PHP_RINIT_FUNCTION(syncml);
PHP_RSHUTDOWN_FUNCTION(syncml);
PHP_MINFO_FUNCTION(syncml);

/* Manager API */
/* smlInit, smlTerminate are handled in the init/shutdown function above. */
PHP_FUNCTION(sml_init_instance);
PHP_FUNCTION(sml_set_syncml_options);
PHP_FUNCTION(sml_set_callbacks);
PHP_FUNCTION(sml_set_encoding);
PHP_FUNCTION(sml_set_user_data);
PHP_FUNCTION(sml_terminate_instance);
PHP_FUNCTION(sml_free_proto_element);
PHP_FUNCTION(sml_write_in_buffer);
PHP_FUNCTION(sml_read_out_buffer);
PHP_FUNCTION(sml_get_free_buffer);
/* Command Builder API */
PHP_FUNCTION(sml_start_message);
PHP_FUNCTION(sml_end_message);
PHP_FUNCTION(sml_start_sync);
PHP_FUNCTION(sml_end_sync);
PHP_FUNCTION(sml_start_atomic);
PHP_FUNCTION(sml_end_atomic);
PHP_FUNCTION(sml_start_sequence);
PHP_FUNCTION(sml_end_sequence);
PHP_FUNCTION(sml_add_cmd);
PHP_FUNCTION(sml_alert_cmd);
PHP_FUNCTION(sml_copy_cmd);
PHP_FUNCTION(sml_delete_cmd);
PHP_FUNCTION(sml_exec_cmd);
PHP_FUNCTION(sml_get_cmd);
PHP_FUNCTION(sml_put_cmd);
PHP_FUNCTION(sml_map_cmd);
PHP_FUNCTION(sml_results_cmd);
PHP_FUNCTION(sml_search_cmd);
PHP_FUNCTION(sml_status_cmd);
PHP_FUNCTION(sml_replace_cmd);
/* Command Dispatcher API */
PHP_FUNCTION(sml_process_data);

/* In every function that needs to use variables in php_syncml_globals,
   do call SYNCMLLS_FETCH(); after declaring other variables used by
   that function, and always refer to them as SYNCMLG(variable).
   You are encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define SYNCMLG(v) (syncml_globals->v)
#define SYNCMLLS_FETCH() php_syncml_globals *syncml_globals = ts_resource(syncml_globals_id)
#else
#define SYNCMLG(v) (syncml_globals.v)
#define SYNCMLLS_FETCH()
#endif

#endif	/* PHP_SYNCML_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
