/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svxbox.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:05:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#pragma hdrstop

#include "svxbox.hxx"

#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif
namespace binfilter {

// -----------------------------------------------------------------------

//STRIP001 SV_IMPL_PTRARR(SvxEntryLst, SvxBoxEntry*)

/*--------------------------------------------------------------------
	 Beschreibung: Ein ListboxElement
 --------------------------------------------------------------------*/

//STRIP001 SvxBoxEntry::SvxBoxEntry() :
//STRIP001 	bModified(FALSE),
//STRIP001 	bNew(FALSE),
//STRIP001 	nId(LISTBOX_ENTRY_NOTFOUND)
//STRIP001 {
//STRIP001 }


//STRIP001 SvxBoxEntry::SvxBoxEntry(const String& aNam, USHORT nIdx) :
//STRIP001 	bModified(FALSE),
//STRIP001 	bNew(FALSE),
//STRIP001 	aName(aNam),
//STRIP001 	nId(nIdx)
//STRIP001 {
//STRIP001 }


//STRIP001 SvxBoxEntry::SvxBoxEntry(const SvxBoxEntry& rOld) :
//STRIP001 	aName(rOld.aName),
//STRIP001 	nId(rOld.nId),
//STRIP001 	bNew(rOld.bNew),
//STRIP001 	bModified(rOld.bModified)
//STRIP001 {
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 SvxListBox::SvxListBox(Window* pParent, WinBits nBits) :
//STRIP001 	ListBox(pParent, nBits)
//STRIP001 {
//STRIP001 	InitListBox();
//STRIP001 }


//STRIP001 SvxListBox::SvxListBox(Window* pParent, const ResId& rId):
//STRIP001 	ListBox(pParent, rId)
//STRIP001 {
//STRIP001 	InitListBox();
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Basisklasse Dtor
 --------------------------------------------------------------------*/

//STRIP001 __EXPORT SvxListBox::~SvxListBox()
//STRIP001 {
//STRIP001 	aEntryLst.DeleteAndDestroy(0,	aEntryLst.Count());
//STRIP001 	aDelEntryLst.DeleteAndDestroy(0, aDelEntryLst.Count());
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Evtl. Liste aus der Ressource beachten
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::InitListBox()
//STRIP001 {
//STRIP001 	// Verwaltung fuer die Stringlist aus der Resource aufbauen
//STRIP001 	USHORT nSize = GetEntryCount();
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	const SvxBoxEntry* pTmp = new SvxBoxEntry(ListBox::GetEntry(i), i);
//STRIP001 		const SvxBoxEntry* &rpTmp = pTmp;
//STRIP001 		aEntryLst.Insert(rpTmp, aEntryLst.Count());
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: neue Eintraege verwalten
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::InsertNewEntry(const SvxBoxEntry& rEntry)
//STRIP001 {
//STRIP001 	SvxBoxEntry* pNew = new SvxBoxEntry(rEntry);
//STRIP001 	pNew->bNew = TRUE;
//STRIP001 	InsertSorted(pNew);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Eintrag in die ListBox aufnehmen
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::InsertEntry(const SvxBoxEntry& rEntry, USHORT nPos)
//STRIP001 {
//STRIP001 	if(nPos != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		SvxBoxEntry* pEntry = new SvxBoxEntry(rEntry);
//STRIP001 		ListBox::InsertEntry(pEntry->aName, nPos);
//STRIP001 		//const SvxBoxEntry* &rpEntry = pEntry;
//STRIP001 		aEntryLst.C40_INSERT(SvxBoxEntry, pEntry, nPos);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		InsertSorted(new SvxBoxEntry(rEntry));
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Eintrag aus der Liste loeschen
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::RemoveEntry(USHORT nPos)
//STRIP001 {
//STRIP001 	if(nPos >= aEntryLst.Count())
//STRIP001 		return;
//STRIP001 
//STRIP001 	// Altes Element austragen
//STRIP001 	SvxBoxEntry* pEntry = aEntryLst[nPos];
//STRIP001 	aEntryLst.Remove(nPos, 1);
//STRIP001 	ListBox::RemoveEntry(nPos);
//STRIP001 
//STRIP001 	// keine neuen Eintraege in die Liste mit aufnehmen
//STRIP001 	if(pEntry->bNew)
//STRIP001 		return;
//STRIP001 
//STRIP001 	// in DeleteListe eintragen
//STRIP001 	aDelEntryLst.C40_INSERT(SvxBoxEntry, pEntry, aDelEntryLst.Count());
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Eintrag ueber konkretes Obkjekt loeschen
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::RemoveEntry(const SvxBoxEntry& rEntry)
//STRIP001 {
//STRIP001 	USHORT nPos = ListBox::GetEntryPos(rEntry.aName);
//STRIP001 	RemoveEntry(nPos);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Listen loeschen und Anzeige loeschen
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::Clear()
//STRIP001 {
//STRIP001 	ListBox::Clear();
//STRIP001 	aEntryLst.DeleteAndDestroy(0, aEntryLst.Count());
//STRIP001 	aDelEntryLst.DeleteAndDestroy(0, aDelEntryLst.Count());
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Position by Name
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxListBox::GetEntryPos(const SvxBoxEntry& rEntry) const
//STRIP001 {
//STRIP001 	return ListBox::GetEntryPos(rEntry.aName);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Rund um die Entries
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxListBox::GetEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	if(nPos < aEntryLst.Count())
//STRIP001 		return *aEntryLst[nPos];
//STRIP001 	else
//STRIP001 		return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: aktullen Eintrag zurueckgeben
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxListBox::GetSelectEntry(USHORT nSelId) const
//STRIP001 {
//STRIP001 	String aName(ListBox::GetSelectEntry(nSelId));
//STRIP001 
//STRIP001 	if(aName.Len() > 0)
//STRIP001 	{
//STRIP001 		for (USHORT i=0; i < aEntryLst.Count(); i++)
//STRIP001 		{
//STRIP001 			if(aEntryLst[i]->aName == aName )
//STRIP001 				return *aEntryLst[i];
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: modifizierte Eintraege
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxListBox::GetModifiedCount() const
//STRIP001 {
//STRIP001 	USHORT nMod  = 0;
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bModified)
//STRIP001 			nMod++;
//STRIP001 	}
//STRIP001 	return nMod;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Modifizierte Eintraege behandeln
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::ModifyEntry(USHORT nPos, const String& rName)
//STRIP001 {
//STRIP001 	if(nPos >= aEntryLst.Count())
//STRIP001 		return;
//STRIP001 
//STRIP001 	SvxBoxEntry* pEntry = aEntryLst[nPos];
//STRIP001 	aEntryLst.Remove(nPos, 1);
//STRIP001 	aEntryLst[nPos]->aName 		= rName;
//STRIP001 	aEntryLst[nPos]->bModified 	= TRUE;
//STRIP001 	ListBox::RemoveEntry(nPos);
//STRIP001 
//STRIP001 	InsertSorted(pEntry);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: alle modifizierten Eintraege bahandeln
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxListBox::GetModifiedEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	USHORT nMod  = 0;
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bModified)
//STRIP001 		{	if(nMod == nPos)
//STRIP001 				return *aEntryLst[i];
//STRIP001 			nMod++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: geloeschte Eintraege
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxListBox::GetRemovedCount() const
//STRIP001 {
//STRIP001 	return aDelEntryLst.Count();
//STRIP001 }


//STRIP001 const SvxBoxEntry& SvxListBox::GetRemovedEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	if(nPos < aDelEntryLst.Count())
//STRIP001 		return *aDelEntryLst[nPos];
//STRIP001 
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Neue Entries begutachten
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxListBox::GetNewCount() const
//STRIP001 {
//STRIP001 	USHORT nNew = 0;
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bNew)
//STRIP001 			nNew++;
//STRIP001 	}
//STRIP001 	return nNew;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:	Alle neuen Eintraege ueberpruefen
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxListBox::GetNewEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	USHORT nNew  = 0;
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bNew)
//STRIP001 		{	if(nNew == nPos)
//STRIP001 				return *aEntryLst[i];
//STRIP001 			nNew++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Sortiert einfuegen
 --------------------------------------------------------------------*/

//STRIP001 void SvxListBox::InsertSorted(SvxBoxEntry* pEntry)
//STRIP001 {
//STRIP001 	ListBox::InsertEntry(pEntry->aName);
//STRIP001 	USHORT nPos = ListBox::GetEntryPos(pEntry->aName);
//STRIP001 	aEntryLst.C40_INSERT(SvxBoxEntry, pEntry, nPos);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: ComboBoxen mit Verwaltungseinheit
 --------------------------------------------------------------------*/

//STRIP001 SvxComboBox::SvxComboBox(Window* pParent, WinBits nBits, USHORT nStyleBits) :
//STRIP001 	::com::boBox(pParent, nBits),
//STRIP001 	nStyle(nStyleBits)
//STRIP001 {
//STRIP001 	InitComboBox();
//STRIP001 }


//STRIP001 SvxComboBox::SvxComboBox(Window* pParent, const ResId& rId, USHORT nStyleBits ):
//STRIP001 	::com::boBox(pParent, rId),
//STRIP001 	nStyle(nStyleBits)
//STRIP001 {
//STRIP001 	InitComboBox();
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Basisklasse Dtor
 --------------------------------------------------------------------*/

//STRIP001 __EXPORT SvxComboBox::~SvxComboBox()
//STRIP001 {
//STRIP001 	aEntryLst.DeleteAndDestroy(0,	aEntryLst.Count());
//STRIP001 	aDelEntryLst.DeleteAndDestroy(0, aDelEntryLst.Count());
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Evtl. Liste aus der Ressource beachten
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::InitComboBox()
//STRIP001 {
//STRIP001 	// Verwaltung fuer die Stringlist aus der Resource aufbauen
//STRIP001 	USHORT nSize = GetEntryCount();
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	const SvxBoxEntry* pTmp = new SvxBoxEntry(ComboBox::GetEntry(i), i);
//STRIP001 		const SvxBoxEntry* &rpTmp = pTmp;
//STRIP001 		aEntryLst.Insert(rpTmp, aEntryLst.Count());
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: neue Eintraege verwalten
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::InsertNewEntry(const SvxBoxEntry& rEntry)
//STRIP001 {
//STRIP001 	SvxBoxEntry* pNew = new SvxBoxEntry(rEntry);
//STRIP001 	pNew->bNew = TRUE;
//STRIP001 	InsertSorted(pNew);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Eintrag in die ComboBox aufnehmen
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::InsertEntry(const SvxBoxEntry& rEntry)
//STRIP001 {
//STRIP001 	InsertSorted(new SvxBoxEntry(rEntry));
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Eintrag aus der Liste loeschen
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::RemoveEntry(USHORT nPos)
//STRIP001 {
//STRIP001 	if(nPos >= aEntryLst.Count())
//STRIP001 		return;
//STRIP001 
//STRIP001 	// Altes Element austragen
//STRIP001 	SvxBoxEntry* pEntry = aEntryLst[nPos];
//STRIP001 	aEntryLst.Remove(nPos, 1);
//STRIP001 	::com::boBox::RemoveEntry(nPos);
//STRIP001 
//STRIP001 	// keine neuen Eintraege in die Liste mit aufnehmen
//STRIP001 	if(pEntry->bNew)
//STRIP001 		return;
//STRIP001 
//STRIP001 	// in DeleteListe eintragen
//STRIP001 	aDelEntryLst.C40_INSERT(SvxBoxEntry, pEntry, aDelEntryLst.Count());
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Eintrag ueber konkretes Obkjekt loeschen
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::RemoveEntry(const SvxBoxEntry& rEntry)
//STRIP001 {
//STRIP001 	USHORT nPos = ComboBox::GetEntryPos(rEntry.aName);
//STRIP001 	RemoveEntry(nPos);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Listen loeschen und Anzeige loeschen
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::Clear()
//STRIP001 {
//STRIP001 	::com::boBox::Clear();
//STRIP001 	aEntryLst.DeleteAndDestroy(0, aEntryLst.Count());
//STRIP001 	aDelEntryLst.DeleteAndDestroy(0, aDelEntryLst.Count());
//STRIP001 }


/*--------------------------------------------------------------------
	 Beschreibung: Position by Name
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxComboBox::GetEntryPos(const SvxBoxEntry& rEntry) const
//STRIP001 {
//STRIP001 	return ComboBox::GetEntryPos(rEntry.aName);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Rund um die Entries
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxComboBox::GetEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	if(nPos < aEntryLst.Count())
//STRIP001 		return *aEntryLst[nPos];
//STRIP001 	else
//STRIP001 		return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: modifizierte Eintraege
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxComboBox::GetModifiedCount() const
//STRIP001 {
//STRIP001 	USHORT nMod  = 0;
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bModified)
//STRIP001 			nMod++;
//STRIP001 	}
//STRIP001 	return nMod;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Modifizierte Eintraege behandeln
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::ModifyEntry(USHORT nPos, const String& rName)
//STRIP001 {
//STRIP001 	if(nPos >= aEntryLst.Count())
//STRIP001 		return;
//STRIP001 
//STRIP001 	SvxBoxEntry* pEntry = aEntryLst[nPos];
//STRIP001 	aEntryLst.Remove(nPos, 1);
//STRIP001 	aEntryLst[nPos]->aName 		= rName;
//STRIP001 	aEntryLst[nPos]->bModified 	= TRUE;
//STRIP001 	::com::boBox::RemoveEntry(nPos);
//STRIP001 
//STRIP001 	InsertSorted(pEntry);
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: alle modifizierten Eintraege bahandeln
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxComboBox::GetModifiedEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	USHORT nMod  = 0;
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bModified)
//STRIP001 		{	if(nMod == nPos)
//STRIP001 				return *aEntryLst[i];
//STRIP001 			nMod++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: geloeschte Eintraege
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxComboBox::GetRemovedCount() const
//STRIP001 {
//STRIP001 	return aDelEntryLst.Count();
//STRIP001 }


//STRIP001 const SvxBoxEntry& SvxComboBox::GetRemovedEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	if(nPos < aDelEntryLst.Count())
//STRIP001 		return *aDelEntryLst[nPos];
//STRIP001 
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Neue Entries begutachten
 --------------------------------------------------------------------*/

//STRIP001 USHORT SvxComboBox::GetNewCount() const
//STRIP001 {
//STRIP001 	USHORT nNew = 0;
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bNew)
//STRIP001 			nNew++;
//STRIP001 	}
//STRIP001 	return nNew;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:	Alle neuen Eintraege ueberpruefen
 --------------------------------------------------------------------*/

//STRIP001 const SvxBoxEntry& SvxComboBox::GetNewEntry(USHORT nPos) const
//STRIP001 {
//STRIP001 	USHORT nSize = aEntryLst.Count();
//STRIP001 	USHORT nNew  = 0;
//STRIP001 	for(USHORT i=0; i < nSize; ++i)
//STRIP001 	{	if(aEntryLst[i]->bNew)
//STRIP001 		{	if(nNew == nPos)
//STRIP001 				return *aEntryLst[i];
//STRIP001 			nNew++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aDefault;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung: Sortiert einfuegen
 --------------------------------------------------------------------*/

//STRIP001 void SvxComboBox::InsertSorted(SvxBoxEntry* pEntry)
//STRIP001 {
//STRIP001 	::com::boBox::InsertEntry(pEntry->aName);
//STRIP001 	USHORT nPos = ComboBox::GetEntryPos(pEntry->aName);
//STRIP001 	aEntryLst.C40_INSERT(SvxBoxEntry, pEntry, nPos);
//STRIP001 }


/*--------------------------------------------------------------------
	Beschreibung: Je nach Option bestimmte Zeichen ausblenden
 --------------------------------------------------------------------*/

//STRIP001 void __EXPORT SvxComboBox::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	sal_Unicode cChar = rKEvt.GetCharCode();
//STRIP001 
//STRIP001 	if(nStyle & SVX_CBS_FILENAME)
//STRIP001 	{
//STRIP001 #ifdef MAC
//STRIP001 		if( cChar == sal_Unicode( ':' ) )
//STRIP001 			return;
//STRIP001 #elif defined UNX
//STRIP001 		if( cChar == sal_Unicode( '/' ) || cChar == sal_Unicode( ' ' ) )
//STRIP001 			return;
//STRIP001 #else
//STRIP001 		if( cChar == sal_Unicode( ':' ) || cChar == sal_Unicode( '\\' ) || 
//STRIP001 			cChar == sal_Unicode( '.' ) || cChar == sal_Unicode( ' ' ) )
//STRIP001 			return;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 	::com::boBox::KeyInput(rKEvt);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Text nach Option konvertieren
 --------------------------------------------------------------------*/

//STRIP001 String SvxComboBox::GetText() const
//STRIP001 {
//STRIP001 	String aTxt(ComboBox::GetText());
//STRIP001 	CharClass aCharClass( Application::GetSettings().GetLocale() );
//STRIP001 
//STRIP001 	if(nStyle & SVX_CBS_LOWER)
//STRIP001 		return aCharClass.lower(aTxt);
//STRIP001 
//STRIP001 	if(nStyle & SVX_CBS_UPPER)
//STRIP001 		return aCharClass.upper(aTxt);
//STRIP001 
//STRIP001 	return aTxt;
//STRIP001 }


}
