/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_vectdlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:05:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _VCL_VCLENUM_HXX
// auto strip #include <vcl/vclenum.hxx>
// auto strip #endif
// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

#include "strings.hrc"
// auto strip #include "sdresid.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "sdmod.hxx"
// auto strip #include "sdiocmpt.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "vectdlg.hxx"
#include "vectdlg.hrc"

// auto strip #ifndef _CONFIG_HXX
// auto strip #include <tools/config.hxx>
// auto strip #endif
// auto strip #ifndef _SV_OCTREE_HXX //autogen
// auto strip  #include <vcl/octree.hxx>
// auto strip #endif
// auto strip #ifndef _SV_BMPACC_HXX //autogen
// auto strip #include <vcl/bmpacc.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_METAACT_HXX //autogen
// auto strip #include <vcl/metaact.hxx>
// auto strip #endif
namespace binfilter {

// -----------
// - Defines -
// -----------

#define VECTORIZE_MAX_EXTENT 512

// ------------------
// - SdVectorizeDlg -
// ------------------

//STRIP001 SdVectorizeDlg::SdVectorizeDlg( Window* pParent, const Bitmap& rBmp, SdDrawDocShell* pDocShell ) :
//STRIP001 		ModalDialog     ( pParent, SdResId( DLG_VECTORIZE ) ),
//STRIP001 		pDocSh          ( pDocShell ),
//STRIP001 		aGrpSettings    ( this, SdResId( GRP_SETTINGS ) ),
//STRIP001 		aFtLayers		( this, SdResId( FT_LAYERS ) ),
//STRIP001 		aNmLayers		( this, SdResId( NM_LAYERS ) ),
//STRIP001 		aFtReduce		( this, SdResId( FT_REDUCE ) ),
//STRIP001 		aMtReduce		( this, SdResId( MT_REDUCE ) ),
//STRIP001 		aFtFillHoles	( this, SdResId( FT_FILLHOLES ) ),
//STRIP001 		aMtFillHoles	( this, SdResId( MT_FILLHOLES ) ),
//STRIP001 		aCbFillHoles	( this, SdResId( CB_FILLHOLES ) ),
//STRIP001 		aFtOriginal		( this, SdResId( FT_ORIGINAL ) ),
//STRIP001 		aFtVectorized	( this, SdResId( FT_VECTORIZED ) ),
//STRIP001 		aBmpWin			( this, SdResId( CTL_BMP ) ),
//STRIP001 		aMtfWin			( this, SdResId( CTL_WMF ) ),
//STRIP001 		aGrpPrgs		( this, SdResId( GRP_PRGS ) ),
//STRIP001 		aPrgs			( this, SdResId( WND_PRGS ) ),
//STRIP001 		aBtnOK          ( this, SdResId( BTN_OK ) ),
//STRIP001 		aBtnCancel      ( this, SdResId( BTN_CANCEL ) ),
//STRIP001 		aBtnHelp        ( this, SdResId( BTN_HELP ) ),
//STRIP001 		aBtnPreview		( this, SdResId( BTN_PREVIEW ) ),
//STRIP001 		aBmp			( rBmp )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aBtnPreview.SetClickHdl( LINK( this, SdVectorizeDlg, ClickPreviewHdl ) );
//STRIP001 	aBtnOK.SetClickHdl( LINK( this, SdVectorizeDlg, ClickOKHdl ) );
//STRIP001 	aNmLayers.SetModifyHdl( LINK( this, SdVectorizeDlg, ModifyHdl ) );
//STRIP001 	aMtReduce.SetModifyHdl( LINK( this, SdVectorizeDlg, ModifyHdl ) );
//STRIP001 	aMtFillHoles.SetModifyHdl( LINK( this, SdVectorizeDlg, ModifyHdl ) );
//STRIP001 	aCbFillHoles.SetToggleHdl( LINK( this, SdVectorizeDlg, ToggleHdl ) );
//STRIP001 
//STRIP001 	// disable 3D border
//STRIP001 	aBmpWin.SetBorderStyle(WINDOW_BORDER_MONO);
//STRIP001 	aMtfWin.SetBorderStyle(WINDOW_BORDER_MONO);
//STRIP001 
//STRIP001 	LoadSettings();
//STRIP001 	InitPreviewBmp();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdVectorizeDlg::~SdVectorizeDlg()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Rectangle SdVectorizeDlg::GetRect( const Size& rDispSize, const Size& rBmpSize ) const
//STRIP001 {
//STRIP001 	Rectangle aRect;
//STRIP001 
//STRIP001 	if( rBmpSize.Width() && rBmpSize.Height() && rDispSize.Width() && rDispSize.Height() )
//STRIP001 	{
//STRIP001 		Size		 aBmpSize( rBmpSize );
//STRIP001 		const double fGrfWH = (double) aBmpSize.Width() / aBmpSize.Height();
//STRIP001 		const double fWinWH = (double) rDispSize.Width() / rDispSize.Height();
//STRIP001 
//STRIP001 		if( fGrfWH < fWinWH )
//STRIP001 		{
//STRIP001 			aBmpSize.Width() = (long) ( rDispSize.Height() * fGrfWH );
//STRIP001 			aBmpSize.Height()= rDispSize.Height();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBmpSize.Width() = rDispSize.Width();
//STRIP001 			aBmpSize.Height()= (long) ( rDispSize.Width() / fGrfWH);
//STRIP001 		}
//STRIP001 
//STRIP001 		const Point aBmpPos( ( rDispSize.Width()  - aBmpSize.Width() ) >> 1,
//STRIP001 							 ( rDispSize.Height() - aBmpSize.Height() ) >> 1 );
//STRIP001 
//STRIP001 		aRect = Rectangle( aBmpPos, aBmpSize );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRect;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdVectorizeDlg::InitPreviewBmp()
//STRIP001 {
//STRIP001 	const Rectangle aRect( GetRect( aBmpWin.GetSizePixel(), aBmp.GetSizePixel() ) );
//STRIP001 
//STRIP001 	aPreviewBmp = aBmp;
//STRIP001 	aPreviewBmp.Scale( aRect.GetSize() );
//STRIP001 	aBmpWin.SetGraphic( aPreviewBmp );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Bitmap SdVectorizeDlg::GetPreparedBitmap( Bitmap& rBmp, Fraction& rScale )
//STRIP001 {
//STRIP001 	Bitmap		aNew( rBmp );
//STRIP001 	const Size	aSizePix( aNew.GetSizePixel() );
//STRIP001 
//STRIP001 	if( aSizePix.Width() > VECTORIZE_MAX_EXTENT || aSizePix.Height() > VECTORIZE_MAX_EXTENT )
//STRIP001 	{
//STRIP001 		const Rectangle aRect( GetRect( Size( VECTORIZE_MAX_EXTENT, VECTORIZE_MAX_EXTENT ), aSizePix ) );
//STRIP001 		rScale = Fraction( aSizePix.Width(), aRect.GetWidth() );
//STRIP001 		aNew.Scale( aRect.GetSize() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rScale = Fraction( 1, 1 );
//STRIP001 
//STRIP001 	aNew.ReduceColors( (USHORT) aNmLayers.GetValue(), BMP_REDUCE_SIMPLE );
//STRIP001 
//STRIP001 	return aNew;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdVectorizeDlg::Calculate( Bitmap& rBmp, GDIMetaFile& rMtf )
//STRIP001 {
//STRIP001 	pDocSh->SetWaitCursor( TRUE );
//STRIP001 	aPrgs.SetValue( 0 );
//STRIP001 
//STRIP001 	Fraction	aScale;
//STRIP001 	Bitmap		aTmp( GetPreparedBitmap( rBmp, aScale ) );
//STRIP001 
//STRIP001 	if( !!aTmp )
//STRIP001 	{
//STRIP001 		const Link aPrgsHdl( LINK( this, SdVectorizeDlg, ProgressHdl ) );
//STRIP001 		aTmp.Vectorize( rMtf, (BYTE) aMtReduce.GetValue(), BMP_VECTORIZE_OUTER | BMP_VECTORIZE_REDUCE_EDGES, &aPrgsHdl );
//STRIP001 
//STRIP001 		if( aCbFillHoles.IsChecked() )
//STRIP001 		{
//STRIP001 			GDIMetaFile			aNewMtf;
//STRIP001 			BitmapReadAccess*	pRAcc = aTmp.AcquireReadAccess();
//STRIP001 
//STRIP001 			if( pRAcc )
//STRIP001 			{
//STRIP001 				const long		nWidth = pRAcc->Width();
//STRIP001 				const long		nHeight = pRAcc->Height();
//STRIP001 				const long		nTileX = aMtFillHoles.GetValue();
//STRIP001 				const long		nTileY = aMtFillHoles.GetValue();
//STRIP001 				const long		nCountX = nWidth / nTileX;
//STRIP001 				const long		nCountY = nHeight / nTileY;
//STRIP001 				const long		nRestX = nWidth % nTileX;
//STRIP001 				const long		nRestY = nHeight % nTileY;
//STRIP001 
//STRIP001 				MapMode aMap( rMtf.GetPrefMapMode() );
//STRIP001 				aNewMtf.SetPrefSize( rMtf.GetPrefSize() );
//STRIP001 				aNewMtf.SetPrefMapMode( aMap );
//STRIP001 
//STRIP001 				for( long nTY = 0; nTY < nCountY; nTY++ )
//STRIP001 				{
//STRIP001 					const long nY = nTY * nTileY;
//STRIP001 
//STRIP001 					for( long nTX = 0; nTX < nCountX; nTX++ )
//STRIP001 						AddTile( pRAcc, aNewMtf, nTX * nTileX, nTY * nTileY, nTileX, nTileY );
//STRIP001 
//STRIP001 					if( nRestX )
//STRIP001 						AddTile( pRAcc, aNewMtf, nCountX * nTileX, nY, nRestX, nTileY );
//STRIP001 				}
//STRIP001 
//STRIP001 				if( nRestY )
//STRIP001 				{
//STRIP001 					const long nY = nCountY * nTileY;
//STRIP001 
//STRIP001 					for( long nTX = 0; nTX < nCountX; nTX++ )
//STRIP001 						AddTile( pRAcc, aNewMtf, nTX * nTileX, nY, nTileX, nRestY );
//STRIP001 
//STRIP001 					if( nRestX )
//STRIP001 						AddTile( pRAcc, aNewMtf, nCountX * nTileX, nCountY * nTileY, nRestX, nRestY );
//STRIP001 				}
//STRIP001 
//STRIP001 
//STRIP001 				aTmp.ReleaseAccess( pRAcc );
//STRIP001 
//STRIP001 				for( ULONG n = 0UL, nCount = rMtf.GetActionCount(); n < nCount; n++ )
//STRIP001 					aNewMtf.AddAction( rMtf.GetAction( n )->Clone() );
//STRIP001 
//STRIP001 				aMap.SetScaleX( aMap.GetScaleX() * aScale );
//STRIP001 				aMap.SetScaleY( aMap.GetScaleY() * aScale );
//STRIP001 				aNewMtf.SetPrefMapMode( aMap );
//STRIP001 				rMtf = aNewMtf;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aPrgs.SetValue( 0 );
//STRIP001 	pDocSh->SetWaitCursor( FALSE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdVectorizeDlg::AddTile( BitmapReadAccess* pRAcc, GDIMetaFile& rMtf,
//STRIP001 							  long nPosX, long nPosY, long nWidth, long nHeight )
//STRIP001 {
//STRIP001 	ULONG			nSumR = 0UL, nSumG = 0UL, nSumB = 0UL;
//STRIP001 	const long		nRight = nPosX + nWidth - 1L;
//STRIP001 	const long		nBottom = nPosY + nHeight - 1L;
//STRIP001 	const double	fMult = 1.0 / ( nWidth * nHeight );
//STRIP001 
//STRIP001 	for( long nY = nPosY; nY <= nBottom; nY++ )
//STRIP001 	{
//STRIP001 		for( long nX = nPosX; nX <= nRight; nX++ )
//STRIP001 		{
//STRIP001 			const BitmapColor aPixel( pRAcc->GetColor( nY, nX ) );
//STRIP001 
//STRIP001 			nSumR += aPixel.GetRed();
//STRIP001 			nSumG += aPixel.GetGreen();
//STRIP001 			nSumB += aPixel.GetBlue();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	const Color aColor( (BYTE) FRound( nSumR * fMult ),
//STRIP001 						(BYTE) FRound( nSumG * fMult ),
//STRIP001 						(BYTE) FRound( nSumB * fMult ) );
//STRIP001 
//STRIP001 	Rectangle	aRect( Point( nPosX, nPosY ), Size( nWidth + 1, nHeight + 1 ) );
//STRIP001 	const Size&	rMaxSize = rMtf.GetPrefSize();
//STRIP001 
//STRIP001 	aRect = PixelToLogic( aRect, rMtf.GetPrefMapMode() );
//STRIP001 
//STRIP001 	if( aRect.Right() > ( rMaxSize.Width() - 1L ) )
//STRIP001 		aRect.Right() = rMaxSize.Width() - 1L;
//STRIP001 
//STRIP001 	if( aRect.Bottom() > ( rMaxSize.Height() - 1L ) )
//STRIP001 		aRect.Bottom() = rMaxSize.Height() - 1L;
//STRIP001 
//STRIP001 	rMtf.AddAction( new MetaLineColorAction( aColor, TRUE ) );
//STRIP001 	rMtf.AddAction( new MetaFillColorAction( aColor, TRUE ) );
//STRIP001 	rMtf.AddAction( new MetaRectAction( aRect ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdVectorizeDlg, ProgressHdl, void*, pData )
//STRIP001 {
//STRIP001 	aPrgs.SetValue( (USHORT)(ULONG) pData );
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdVectorizeDlg, ClickPreviewHdl, PushButton*, pBtn )
//STRIP001 {
//STRIP001 	Calculate( aBmp, aMtf );
//STRIP001 	aMtfWin.SetGraphic( aMtf );
//STRIP001 	aBtnPreview.Disable();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdVectorizeDlg, ClickOKHdl, OKButton*, pBtn )
//STRIP001 {
//STRIP001 	if( aBtnPreview.IsEnabled() )
//STRIP001 		Calculate( aBmp, aMtf );
//STRIP001 
//STRIP001 	SaveSettings();
//STRIP001 	EndDialog( RET_OK );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdVectorizeDlg, ToggleHdl, CheckBox*, pCb )
//STRIP001 {
//STRIP001 	if( pCb->IsChecked() )
//STRIP001 	{
//STRIP001 		aFtFillHoles.Enable();
//STRIP001 		aMtFillHoles.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFtFillHoles.Disable();
//STRIP001 		aMtFillHoles.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	ModifyHdl( NULL );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdVectorizeDlg, ModifyHdl, void*, p )
//STRIP001 {
//STRIP001 	aBtnPreview.Enable();
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdVectorizeDlg::LoadSettings()
//STRIP001 {
//STRIP001 	SvStorageStreamRef	xIStm( SD_MOD()->GetOptionStream(
//STRIP001 							   UniString::CreateFromAscii(
//STRIP001 							   RTL_CONSTASCII_STRINGPARAM( SD_OPTION_VECTORIZE ) ),
//STRIP001 							   SD_OPTION_LOAD ) );
//STRIP001 	UINT16				nLayers;
//STRIP001 	UINT16				nReduce;
//STRIP001 	UINT16				nFillHoles;
//STRIP001 	BOOL				bFillHoles;
//STRIP001 
//STRIP001 	if( xIStm.Is() )
//STRIP001 	{
//STRIP001 		SdIOCompat aCompat( *xIStm, STREAM_READ );
//STRIP001 		*xIStm >> nLayers >> nReduce >> nFillHoles >> bFillHoles;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nLayers = 8;
//STRIP001 		nReduce = 0;
//STRIP001 		nFillHoles = 32;
//STRIP001 		bFillHoles = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	aNmLayers.SetValue( nLayers );
//STRIP001 	aMtReduce.SetValue( nReduce );
//STRIP001 	aMtFillHoles.SetValue( nFillHoles );
//STRIP001 	aCbFillHoles.Check( bFillHoles );
//STRIP001 
//STRIP001 	ToggleHdl( &aCbFillHoles );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdVectorizeDlg::SaveSettings() const
//STRIP001 {
//STRIP001 	SvStorageStreamRef xOStm( SD_MOD()->GetOptionStream(
//STRIP001 							  UniString::CreateFromAscii(
//STRIP001 							  RTL_CONSTASCII_STRINGPARAM( SD_OPTION_VECTORIZE ) ),
//STRIP001 							  SD_OPTION_STORE ) );
//STRIP001 
//STRIP001 	if( xOStm.Is() )
//STRIP001 	{
//STRIP001 		SdIOCompat aCompat( *xOStm, STREAM_WRITE, 1 );
//STRIP001 		*xOStm << (UINT16) aNmLayers.GetValue() << (UINT16) aMtReduce.GetValue();
//STRIP001 		*xOStm << (UINT16) aMtFillHoles.GetValue() << aCbFillHoles.IsChecked();
//STRIP001 	}
//STRIP001 }

}
