/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_csvcontrol.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:56:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif
#pragma hdrstop

// ============================================================================

#ifndef _SC_CSVCONTROL_HXX
#include "csvcontrol.hxx"
#endif

// auto strip #ifndef _TOOLS_DEBUG_HXX
// auto strip #include <tools/debug.hxx>
// auto strip #endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SC_ACCESSIBLECSVCONTROL_HXX
#include "AccessibleCsvControl.hxx"
#endif
namespace binfilter {


// ============================================================================

/*N*/ ScCsvLayoutData::ScCsvLayoutData() :
/*N*/     mnPosCount( 1 ),
/*N*/     mnPosOffset( 0 ),
/*N*/     mnWinWidth( 1 ),
/*N*/     mnHdrWidth( 0 ),
/*N*/     mnCharWidth( 1 ),
/*N*/     mnLineCount( 1 ),
/*N*/     mnLineOffset( 0 ),
/*N*/     mnWinHeight( 1 ),
/*N*/     mnHdrHeight( 0 ),
/*N*/     mnLineHeight( 1 ),
/*N*/     mnPosCursor( CSV_POS_INVALID ),
/*N*/     mnColCursor( 0 ),
/*N*/     mnNoRepaint( 0 ),
/*N*/     mbAppRTL( !!Application::GetSettings().GetLayoutRTL() )
/*N*/ {
/*N*/ }

//STRIP001 ScCsvDiff ScCsvLayoutData::GetDiff( const ScCsvLayoutData& rData ) const
//STRIP001 {
//STRIP001     ScCsvDiff nRet = CSV_DIFF_EQUAL;
//STRIP001     if( mnPosCount != rData.mnPosCount )        nRet |= CSV_DIFF_POSCOUNT;
//STRIP001     if( mnPosOffset != rData.mnPosOffset )      nRet |= CSV_DIFF_POSOFFSET;
//STRIP001     if( mnHdrWidth != rData.mnHdrWidth )        nRet |= CSV_DIFF_HDRWIDTH;
//STRIP001     if( mnCharWidth != rData.mnCharWidth )      nRet |= CSV_DIFF_CHARWIDTH;
//STRIP001     if( mnLineCount != rData.mnLineCount )      nRet |= CSV_DIFF_LINECOUNT;
//STRIP001     if( mnLineOffset != rData.mnLineOffset )    nRet |= CSV_DIFF_LINEOFFSET;
//STRIP001     if( mnHdrHeight != rData.mnHdrHeight )      nRet |= CSV_DIFF_HDRHEIGHT;
//STRIP001     if( mnLineHeight != rData.mnLineHeight )    nRet |= CSV_DIFF_LINEHEIGHT;
//STRIP001     if( mnPosCursor != rData.mnPosCursor )      nRet |= CSV_DIFF_RULERCURSOR;
//STRIP001     if( mnColCursor != rData.mnColCursor )      nRet |= CSV_DIFF_GRIDCURSOR;
//STRIP001     return nRet;
//STRIP001 }


// ============================================================================

/*N*/ ScCsvControl::ScCsvControl( ScCsvControl& rParent ) :
/*N*/     Control( &rParent, WB_TABSTOP | WB_NODIALOGCONTROL ),
/*N*/     mrData( rParent.GetLayoutData() ),
/*M*/     mpAccessible( NULL ),
/*N*/     mbValidGfx( false )
/*N*/ {
/*N*/ }

/*N*/ ScCsvControl::ScCsvControl( Window* pParent, const ScCsvLayoutData& rData, WinBits nStyle ) :
/*N*/     Control( pParent, nStyle ),
/*N*/     mrData( rData ),
/*M*/     mpAccessible( NULL ),
/*N*/     mbValidGfx( false )
/*N*/ {
/*N*/ }

/*N*/ ScCsvControl::ScCsvControl( Window* pParent, const ScCsvLayoutData& rData, const ResId& rResId ) :
/*N*/     Control( pParent, rResId ),
/*N*/     mrData( rData ),
/*M*/     mpAccessible( NULL ),
/*N*/     mbValidGfx( false )
/*N*/ {
/*N*/ }

/*M*/ ScCsvControl::~ScCsvControl()
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->dispose();
/*M*/ }


// event handling -------------------------------------------------------------

/*M*/ void ScCsvControl::GetFocus()
/*M*/ {
/*M*/     Control::GetFocus();
/*M*/     AccSendFocusEvent( true );
/*M*/ }

/*M*/ void ScCsvControl::LoseFocus()
/*M*/ {
/*M*/     Control::LoseFocus();
/*M*/     AccSendFocusEvent( false );
/*M*/ }

/*M*/ void ScCsvControl::AccSendFocusEvent( bool bFocused )
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendFocusEvent( bFocused );
/*M*/ }

/*M*/ void ScCsvControl::AccSendCaretEvent()
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendCaretEvent();
/*M*/ }

/*M*/ void ScCsvControl::AccSendVisibleEvent()
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendVisibleEvent();
/*M*/ }

/*M*/ void ScCsvControl::AccSendSelectionEvent()
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendSelectionEvent();
/*M*/ }

/*M*/ void ScCsvControl::AccSendTableUpdateEvent( sal_uInt32 nFirstColumn, sal_uInt32 nLastColumn, bool bAllRows )
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendTableUpdateEvent( nFirstColumn, nLastColumn, bAllRows );
/*M*/ }

/*M*/ void ScCsvControl::AccSendInsertColumnEvent( sal_uInt32 nFirstColumn, sal_uInt32 nLastColumn )
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendInsertColumnEvent( nFirstColumn, nLastColumn );
/*M*/ }

/*M*/ void ScCsvControl::AccSendRemoveColumnEvent( sal_uInt32 nFirstColumn, sal_uInt32 nLastColumn )
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendRemoveColumnEvent( nFirstColumn, nLastColumn );
/*M*/ }


// repaint helpers ------------------------------------------------------------

//STRIP001 void ScCsvControl::Repaint( bool bInvalidate )
//STRIP001 {
//STRIP001     if( bInvalidate )
//STRIP001         InvalidateGfx();
//STRIP001     if( !IsNoRepaint() )
//STRIP001         Execute( CSVCMD_REPAINT );
//STRIP001 }

//STRIP001 void ScCsvControl::DisableRepaint()
//STRIP001 {
//STRIP001     ++mrData.mnNoRepaint;
//STRIP001 }

//STRIP001 void ScCsvControl::EnableRepaint( bool bInvalidate )
//STRIP001 {
//STRIP001     DBG_ASSERT( IsNoRepaint(), "ScCsvControl::EnableRepaint - invalid call" );
//STRIP001     --mrData.mnNoRepaint;
//STRIP001     Repaint( bInvalidate );
//STRIP001 }


// command handling -----------------------------------------------------------

/*M*/ void ScCsvControl::Execute( ScCsvCmdType eType, sal_Int32 nParam1, sal_Int32 nParam2 )
/*M*/ {
/*M*/     maCmd.Set( eType, nParam1, nParam2 );
/*M*/     maCmdHdl.Call( this );
/*M*/ }


// layout helpers -------------------------------------------------------------

//STRIP001 sal_Int32 ScCsvControl::GetVisPosCount() const
//STRIP001 {
//STRIP001     return (mrData.mnWinWidth - GetHdrWidth()) / GetCharWidth();
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetMaxPosOffset() const
//STRIP001 {
//STRIP001     return Max( GetPosCount() - GetVisPosCount() + 2L, 0L );
//STRIP001 }

//STRIP001 bool ScCsvControl::IsValidSplitPos( sal_Int32 nPos ) const
//STRIP001 {
//STRIP001     return (0 < nPos) && (nPos < GetPosCount() );
//STRIP001 }

//STRIP001 bool ScCsvControl::IsVisibleSplitPos( sal_Int32 nPos ) const
//STRIP001 {
//STRIP001     return IsValidSplitPos( nPos ) && (GetFirstVisPos() <= nPos) && (nPos <= GetLastVisPos());
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetHdrX() const
//STRIP001 {
//STRIP001     return IsRTL() ? (mrData.mnWinWidth - GetHdrWidth()) : 0;
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetFirstX() const
//STRIP001 {
//STRIP001     return IsRTL() ? 0 : GetHdrWidth();
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetLastX() const
//STRIP001 {
//STRIP001     return mrData.mnWinWidth - (IsRTL() ? GetHdrWidth() : 0) - 1;
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetX( sal_Int32 nPos ) const
//STRIP001 {
//STRIP001     return GetFirstX() + (nPos - GetFirstVisPos()) * GetCharWidth();
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetPosFromX( sal_Int32 nX ) const
//STRIP001 {
//STRIP001     return (nX - GetFirstX() + GetCharWidth() / 2) / GetCharWidth() + GetFirstVisPos();
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetVisLineCount() const
//STRIP001 {
//STRIP001     return (mrData.mnWinHeight - GetHdrHeight() - 2) / GetLineHeight() + 1;
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetLastVisLine() const
//STRIP001 {
//STRIP001     return Min( GetFirstVisLine() + GetVisLineCount(), GetLineCount() ) - 1;
//STRIP001 }

//STRIP001 sal_Int32 ScCsvControl::GetMaxLineOffset() const
//STRIP001 {
//STRIP001     return Max( GetLineCount() - GetVisLineCount() + 1L, 0L );
//STRIP001 }
//STRIP001 
//STRIP001 bool ScCsvControl::IsValidLine( sal_Int32 nLine ) const
//STRIP001 {
//STRIP001     return (0 <= nLine) && (nLine < GetLineCount());
//STRIP001 }
//STRIP001 
//STRIP001 bool ScCsvControl::IsVisibleLine( sal_Int32 nLine ) const
//STRIP001 {
//STRIP001     return IsValidLine( nLine ) && (GetFirstVisLine() <= nLine) && (nLine <= GetLastVisLine());
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 ScCsvControl::GetY( sal_Int32 nLine ) const
//STRIP001 {
//STRIP001     return GetHdrHeight() + (nLine - GetFirstVisLine()) * GetLineHeight();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 ScCsvControl::GetLineFromY( sal_Int32 nY ) const
//STRIP001 {
//STRIP001     return (nY - GetHdrHeight()) / GetLineHeight() + GetFirstVisLine();
//STRIP001 }


// static helpers -------------------------------------------------------------

//STRIP001 void ScCsvControl::ImplInvertRect( OutputDevice& rOutDev, const Rectangle& rRect )
//STRIP001 {
//STRIP001     RasterOp eOldOp = rOutDev.GetRasterOp();
//STRIP001     rOutDev.SetRasterOp( ROP_INVERT );
//STRIP001     rOutDev.DrawRect( rRect );
//STRIP001     rOutDev.SetRasterOp( eOldOp );
//STRIP001 }

//STRIP001 ScMoveMode ScCsvControl::GetHorzDirection( sal_uInt16 nCode, bool bHomeEnd )
//STRIP001 {
//STRIP001     switch( nCode )
//STRIP001     {
//STRIP001         case KEY_LEFT:  return MOVE_PREV;
//STRIP001         case KEY_RIGHT: return MOVE_NEXT;
//STRIP001     }
//STRIP001     if( bHomeEnd ) switch( nCode )
//STRIP001     {
//STRIP001         case KEY_HOME:  return MOVE_FIRST;
//STRIP001         case KEY_END:   return MOVE_LAST;
//STRIP001     }
//STRIP001     return MOVE_NONE;
//STRIP001 }
//STRIP001 
//STRIP001 ScMoveMode ScCsvControl::GetVertDirection( sal_uInt16 nCode, bool bHomeEnd )
//STRIP001 {
//STRIP001     switch( nCode )
//STRIP001     {
//STRIP001         case KEY_UP:        return MOVE_PREV;
//STRIP001         case KEY_DOWN:      return MOVE_NEXT;
//STRIP001         case KEY_PAGEUP:    return MOVE_PREVPAGE;
//STRIP001         case KEY_PAGEDOWN:  return MOVE_NEXTPAGE;
//STRIP001     }
//STRIP001     if( bHomeEnd ) switch( nCode )
//STRIP001     {
//STRIP001         case KEY_HOME:      return MOVE_FIRST;
//STRIP001         case KEY_END:       return MOVE_LAST;
//STRIP001     }
//STRIP001     return MOVE_NONE;
//STRIP001 }


// accessibility --------------------------------------------------------------

//STRIP001 ScCsvControl::XAccessibleRef ScCsvControl::CreateAccessible()
//STRIP001 {
//STRIP001     mpAccessible = ImplCreateAccessible();
//STRIP001     mxAccessible = mpAccessible;
//STRIP001     return mxAccessible;
//STRIP001 }


// ============================================================================

}
