package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

import com.sun.star.wizards.tutorial.executer.util.FindInterfaces;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * This class is meant for handling all the StarOffice menus functionality
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class DesktopMenu extends Desktop {
    private Helper m_helper;
    private static DesktopMenu m_desktopMenu;

    static {
        new DesktopMenu();
    }

    /**
     * Creates a new DesktopMenu object.
     */
    public DesktopMenu() {
        m_desktopMenu = this;
    }

    /**
     * Creates a new DesktopMenu object.
     *
     * @param helper
     *
     * @throws java.lang.Exception
     * @throws Exception DOCUMENT ME!
     */
    public DesktopMenu(Helper helper) throws java.lang.Exception {
        if (helper == null) {
            throw new Exception("ERROR : Helper is not initialized.");
        }

        m_helper = helper;
    }

    /**
     * Get Helper
     *
     * @return Helper instance
     */
    public Helper getHelper() {
        return m_helper;
    }

    /**
     * Set Helper instance
     *
     * @param helper DOCUMENT ME!
     */
    public void setHelper(Helper helper) {
        m_helper = helper;
    }

    /**
     * Get implemented interfaces
     *
     * @return interfaces.
     */
    public static Hashtable getInterfaces() {
        return (FindInterfaces.getInterfaces(m_desktopMenu.getClass()));
    }
}
