
package org.netbeans.modules.openoffice.wizard.nodes;

import java.util.*;
import org.openide.nodes.Children;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.util.*;
import org.openide.nodes.Node;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;


public class IDLBaseChildren extends org.openide.nodes.Children.Keys 
implements AbstractMoveableNode
{

   private ArrayList subNodes;
   
   public IDLBaseChildren()
    {
        subNodes = new ArrayList();
    }

    public void addNotify()
    {
        super.addNotify();
        prepareKeys();
    }

    public void prepareKeys()
    {
        setKeys(subNodes);
    }

    public void addKey(BaseKey mutablekey)
    {

        subNodes.add(mutablekey);
        prepareKeys();
    }

    public void addKey(int i, BaseKey mutablekey)
    {
        if(i < 0 || i > subNodes.size())
        {
            return;
        }
        else
        {
            subNodes.add(i, mutablekey);
            prepareKeys();
            return;
        }
    }

    public void addKeys(Collection collection)
    {
        subNodes.addAll(collection);
        prepareKeys();
    }

    public void removeKey(BaseKey mutablekey)
    {
        subNodes.remove(mutablekey);
        prepareKeys();
    }

    public void removeAllKeys(boolean flag)
    {
        subNodes.clear();
        if(flag)
            prepareKeys();
    }

    public ArrayList getKeys()
    {
        return subNodes;
    }

    public ArrayList getKeysSafe()
    {
        return (ArrayList)subNodes.clone();
    }

    public int getKeysCount()
    {
        return subNodes.size();
    }

    public BaseKey getKey(int i)
    {
        if(i < 0 || i >= subNodes.size())
            return null;
        else
            return (BaseKey)subNodes.get(i);
    }

    public Node[] createNodes(Object obj)
    {
     
       if(obj != null && (obj instanceof BaseKey))
        {
          
           Node anode[] = new Node[1];
            switch(((BaseKey)obj).kind())
            {
            case 1: /* '\001' */
                return (new Node[] {
                    new ModuleNode((NameKey)obj)
                });

            case 5: /* '\005' */
                return (new Node[] {
                    new ConstantNode((NameKey)obj)
                });

            case 8: /* '\b' */
                return (new Node[] {
                    new StructNode((NameKey)obj)
                });

           case 7: /* '\007' */
                return (new Node[] {
                    new ExceptionNode((NameKey)obj)
                });

          case 6: /* '\006' */
               return (new Node[] {
                   new AliasNode((NameKey)obj)
               });

            case 9: /* '\t' */
                return (new Node[] {
                    new UnionNode((NameKey)obj)
                });

            case 10: /* '\n' */
                return (new Node[] {
                    new EnumNode((NameKey)obj)
                });

            case 2: /* '\002' */
                return (new Node[] {
                    new InterfaceNode((NameKey)obj)
                 });

            case 13: /* '\r' */
                return (new Node[] {
                    new EnumEntryNode((NameKey)obj)
                });

            case 12: /* '\f' */
                return (new Node[] {
                    new StructMemberNode((NameKey)obj)
                });

            case 11: /* '\013' */
                return (new Node[] {
                    new UnionMemberNode((NameKey)obj)
                });

            case 3: /* '\003' */
                return (new Node[] {
                    new OperationNode((NameKey)obj)
                });

            case 4: /* '\004' */
                return (new Node[] {
                    new AttributeNode((NameKey)obj)
                });

            case 14: /* '\016' */
                return (new Node[] {
                    new ForwardDcl((ForwardDclKey)obj)
                });

            case 15: /* '\017' */
                return (new Node[] {
                    new ValueBoxNode((AliasKey)obj)
                });

//            case 16: /* '\020' */
//                return (new Node[] {
//                    new ValueTypeNode((ValueTypeKey)obj)
//                });

            case 17: /* '\021' */
                return (new Node[] {
                    new ValueNode((ValueKey)obj)
                });

           case 19: /* '\023' */
                return (new Node[] {
                    new ServiceNode((NameKey)obj)
                });

           case 20: /* '\024' */
               return (
               new Node[] {
                   new ConstantsNode( ( NameKey ) obj )
               }
               );
            }
            return new Node[0];
        }
        else
        {
            return new Node[0];
        }
    }

    public void moveUp(Node node)
    {
        NameKey namedkey = ((BaseNode)node).key;
        int i = subNodes.indexOf(namedkey);
        if(i == -1)
        {
            return;
        }
        else
        {
            Object obj = subNodes.get(i - 1);
            subNodes.set(i - 1, namedkey);
            subNodes.set(i, obj);
            prepareKeys();
            return;
        }
    }

    public void moveDown(Node node)
    {
        NameKey namedkey = ((BaseNode)node).key;
        int i = subNodes.indexOf(namedkey);
        if(i == -1)
        {
            return;
        }
        else
        {
            Object obj = subNodes.get(i + 1);
            subNodes.set(i + 1, namedkey);
            subNodes.set(i, obj);
            prepareKeys();
            return;
        }
    }
  

    
}
