/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BoundedCoordinateSystem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:53:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "BoundedCoordinateSystem.hxx"

#if OSL_DEBUG_LEVEL > 1
#include <rtl/math.hxx>
#endif

using namespace ::com::sun::star;

namespace
{
static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart2.BoundedCoordinateSystem" ));
} // anonymous namespace

namespace chart
{

BoundedCoordinateSystem::BoundedCoordinateSystem(
    const uno::Reference<
    chart2::XCoordinateSystem > & xCoordSys ) :
        m_xCoordSys( xCoordSys )
{
    OSL_ASSERT( m_xCoordSys.is());

    sal_Int32 nDim = m_xCoordSys->getDimension();

    if( m_xCoordSys.is())
        m_aScales.resize( nDim );

    m_aOrigin.realloc( nDim );
    for( sal_Int32 i = 0; i < nDim; ++i )
        m_aOrigin[ i ] = uno::makeAny( double( 0.0 ) );
}

BoundedCoordinateSystem::~BoundedCoordinateSystem()
{}

// ____ XBoundedCoordinateSystem ____
void SAL_CALL BoundedCoordinateSystem::setScaleByDimension(
    sal_Int32 nDimension,
    const uno::Reference< chart2::XScale >& aScale )
    throw (lang::IndexOutOfBoundsException,
           uno::RuntimeException)
{
    if( ! m_xCoordSys.is() ||
        ( nDimension >= m_xCoordSys->getDimension() ))
        throw lang::IndexOutOfBoundsException();

    m_aScales[ nDimension ] = aScale;
}

uno::Reference< chart2::XScale > SAL_CALL BoundedCoordinateSystem::getScaleByDimension( sal_Int32 nDimension )
    throw (lang::IndexOutOfBoundsException,
           uno::RuntimeException)
{
    if( ! m_xCoordSys.is() ||
        ( nDimension >= m_xCoordSys->getDimension() ))
        throw lang::IndexOutOfBoundsException();

    OSL_ASSERT( m_aScales.size() == static_cast< size_t >( m_xCoordSys->getDimension()));

    return m_aScales[ nDimension ];
}

void SAL_CALL BoundedCoordinateSystem::setOrigin( const uno::Sequence< uno::Any >& aOrigin )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    const sal_Int32 nDim = m_xCoordSys->getDimension();
    if( ! m_xCoordSys.is() ||
        aOrigin.getLength() != nDim )
        throw lang::IllegalArgumentException();

    // anies must be empty or contain a double
    for( sal_Int32 i = 0; i < nDim; ++i )
        if( aOrigin[i].hasValue() &&
            ( aOrigin[i].getValueType().getTypeClass() !=
              ::com::sun::star::uno::TypeClass_DOUBLE ) )
            throw lang::IllegalArgumentException();

    m_aOrigin = aOrigin;

#if OSL_DEBUG_LEVEL > 1
    double x, y, z;
    ::rtl::math::setNan( &x ), ::rtl::math::setNan( &y ), ::rtl::math::setNan( &z );
    if( m_aOrigin.getLength() > 0 &&
        m_aOrigin[0].hasValue() )
        m_aOrigin[0] >>= x;
    if( m_aOrigin.getLength() > 1 &&
        m_aOrigin[1].hasValue() )
        m_aOrigin[1] >>= y;
    if( m_aOrigin.getLength() > 2 &&
        m_aOrigin[2].hasValue() )
        m_aOrigin[2] >>= z;
    OSL_TRACE( "Origin: (%f, %f, %f)", x, y, z );
#endif
}

uno::Sequence< uno::Any > SAL_CALL BoundedCoordinateSystem::getOrigin()
    throw (uno::RuntimeException)
{
    return m_aOrigin;
}

// ____ XCoordinateSystem ____
uno::Reference< chart2::XTransformation > SAL_CALL BoundedCoordinateSystem::getTransformationToCartesian()
    throw (uno::RuntimeException)
{
    if( ! m_xCoordSys.is())
        return uno::Reference< chart2::XTransformation >();

    return m_xCoordSys->getTransformationToCartesian();
}

uno::Reference< chart2::XTransformation > SAL_CALL BoundedCoordinateSystem::getTransformationFromCartesian()
    throw (uno::RuntimeException)
{
    if( ! m_xCoordSys.is())
        return uno::Reference< chart2::XTransformation >();

    return m_xCoordSys->getTransformationFromCartesian();
}

sal_Int32 SAL_CALL BoundedCoordinateSystem::getDimension()
    throw (uno::RuntimeException)
{
    if( ! m_xCoordSys.is())
        return 0;

    return m_xCoordSys->getDimension();
}

::rtl::OUString SAL_CALL BoundedCoordinateSystem::getCoordinateSystemType()
        throw (uno::RuntimeException)
{
    if( ! m_xCoordSys.is())
        return ::rtl::OUString();

    return m_xCoordSys->getCoordinateSystemType();
}

::rtl::OUString SAL_CALL BoundedCoordinateSystem::getViewServiceName()
        throw (uno::RuntimeException)
{
    if( ! m_xCoordSys.is())
        return ::rtl::OUString();

    return m_xCoordSys->getViewServiceName();
}

// ____ XCloneable ____
uno::Reference< util::XCloneable > SAL_CALL BoundedCoordinateSystem::createClone()
    throw (uno::RuntimeException)
{
    uno::Reference< util::XCloneable > aResult;
    BoundedCoordinateSystem * pClone = new BoundedCoordinateSystem( m_xCoordSys );

    try
    {
        pClone->m_aOrigin = this->m_aOrigin;
        pClone->m_aScales = this->m_aScales;

        aResult.set( pClone );
    }
    catch( ... )
    {
        delete pClone;
        throw;
    }

    return aResult;
}


// ____ XServiceInfo ____

uno::Sequence< ::rtl::OUString > BoundedCoordinateSystem::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices;
//      Sequence< OUString > aServices( 1 );
//      aServices[ 0 ] = OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.chart2.CoordinateSystem" ));
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( BoundedCoordinateSystem, lcl_aServiceName );

} //  namespace chart
