/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: moptions.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:09:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MOPTIONS_HXX
#define _MOPTIONS_HXX

#ifndef _SVHEADER_HXX
#include <svheader.hxx>
#endif

#include <svtools/svmedit.hxx>

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

class SbMethod;
class SbxVariable;

class MacroOptionsDialog: public ModalDialog
{
private:
	OKButton 		aOKButton;
	CancelButton 	aCancelButton;
	HelpButton 		aHelpButton;

	FixedText 		aSbxName;
	FixedText 		aDescrText;
	MultiLineEdit 	aDescription;

    FixedLine       aFixedLine;
    FixedText 		aHelpIdText;
	NumericField 	aHelpId;
	FixedText 		aHelpFileText;
	Edit 			aHelpFile;

	SbxVariable*	pVariable;

	DECL_LINK( ButtonHdl, Button * );



public:
					MacroOptionsDialog( Window* pParent, SbxVariable* pVariable );

	virtual short	Execute();
};

#endif	//_MOPTIONS_HXX
