/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: getncast.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:58:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_GETNCAST_HXX
#define ARY_GETNCAST_HXX

//  VERSION:            Autodoc 2.2


// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERSs
#include <ary/x_ary.hxx>

namespace ary
{


template <class DEST>
struct T2T { };


template <class DEST, class SRC>
inline bool
is_type( const SRC & i_rSrc, T2T<DEST> )
{
    return i_rSrc.ClassId() == DEST::class_id;
}


template <class DEST, class SRC>
inline const DEST *
cptr_cast( const SRC * i_pSrc, T2T<DEST> unused )
{
    if ( i_pSrc != 0 )
    {
        if ( is_type(*i_pSrc, unused) )
            return static_cast< const DEST* >(i_pSrc);
    }

    return 0;
}

template <class DEST, class SRC>
inline DEST *
ptr_cast( SRC * i_pSrc, T2T<DEST> unused )
{
    if ( i_pSrc != 0 )
    {
        if ( is_type(*i_pSrc, unused) )
            return static_cast< DEST* >(i_pSrc);
    }

    return 0;
}

template <class DEST, class SRC>
inline const DEST &
cref_cast( const SRC & i_rSrc, T2T<DEST> unused )
{
    if ( is_type(i_rSrc, unused) )
        return static_cast< const DEST& >(i_rSrc);
    throw X_Ary(X_Ary::x_InvalidCast);

    // NOT reached:
    return static_cast< const DEST& >(i_rSrc);
}

template <class DEST, class SRC>
inline DEST &
ref_cast( SRC & i_rSrc, T2T<DEST> unused )
{
    if ( is_type(i_rSrc, unused) )
        return static_cast< DEST& >(i_rSrc);
    throw X_Ary(X_Ary::x_InvalidCast);

    // NOT reached:
    return static_cast< DEST& >(i_rSrc);
}


//********** Assuming that works under VC++ and others *********//

template <class DEST>
inline const DEST &
ary_cast( const n22::RepositoryEntity & ce)
{
    if ( ce.ClassId() != DEST::class_id )
        throw X_Ary(X_Ary::x_InvalidCast);
    return static_cast< const DEST& >(ce);
}

template <class DEST>
inline DEST &
ary_cast( n22::RepositoryEntity & ce)
{    
    if ( ce.ClassId() != DEST::class_id )
        throw X_Ary(X_Ary::x_InvalidCast);
    return static_cast< DEST& >(ce);
}

template <class DEST>
inline const DEST *
ary_cast( const n22::RepositoryEntity * ce)
{
    if ( ce ? ce->ClassId() == DEST::class_id : false )
        return static_cast< const DEST* >(ce);
    return 0;
}

template <class DEST>
inline DEST *
ary_cast( n22::RepositoryEntity * ce)
{
    if ( ce ? ce->ClassId() == DEST::class_id : false )
        return static_cast< DEST* >(ce);
    return 0;
}


}   // namespace ary






#endif

