/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: c_disply.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:57:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_C_DISPLY_HXX
#define ARY_CPP_C_DISPLY_HXX


#include <ary/r_disply.hxx>

#include <ary/ids.hxx>
#include <ary/idlists.hxx>
#include <iostream>



namespace ary
{
    namespace loc
    {
        class RoGate;
    }

    class CodeEntity;
    class QualifiedName;

namespace cpp
{
    class RoGate_Defines;
    class RoGate_Groups;
    class Namespace;
    class Class;
    class OperationSignature;


class DisplayGate : public ary::DisplayGate
{
  public:
	// LIFECYCLE
	virtual 			~DisplayGate() {}

    // INQUIRY
	const CodeEntity &  Ref_Ce(
							Cid					i_nId ) const;
	const CodeEntity *  Find_Ce(
							Cid					i_nId ) const;
    const OperationSignature *
                        Find_Signature(
                            OSid                i_nSignature ) const;
	const CodeEntity *  Search_RelatedCe(
							Tid					i_nType ) const;
    /// It's assumed that i_rSearchedName is an absolute name.
    const CodeEntity *  Search_CeAbsolute(
                            const QualifiedName &
                                                i_rSearchedName ) const;
    const CodeEntity *  Search_CeLocal(
                            const udmstri &     i_sLocalName,
                            bool                i_bIsFunction,
                            const Namespace &   i_rCurNamespace,
                            const Class *       i_pCurClass ) const;
    uintt               Get_AlphabeticalList(
                            List_Rid &          o_sResult,
                            const char *        i_sBegin,
                            const char *        i_sEnd ) const;
    void                Get_QualifiedName(
                            StreamStr &         o_rOut,
                            const udmstri &     i_sLocalName,
                            Cid                 i_nOwner,
                            const char *        i_sDelimiter = "::" ) const;
    bool                Get_TypeText(
                            StreamStr &         o_rOut,
                            Tid                 i_nType ) const;
    bool                Get_TypeText(
                            StreamStr &         o_rPreName,     ///  ::ary::cpp::
                            StreamStr &         o_rName,        ///  MyClass
                            StreamStr &         o_rPostName,    ///  <TplArgument> * const &
                            Tid                 i_nType ) const;
    void                Get_SignatureText(
                            StreamStr &         o_rOut,
                            OSid                i_nSignature,
                            const StringVector *
                                                i_sParameterNames = 0 ) const;
    const Namespace &   GlobalNamespace() const;
    const RoGate_Defines &
                        RoDefines() const;
    const RoGate_Groups &
                        RoGroups() const;
    const loc::RoGate & RoLocations() const;

  private:
	virtual const CodeEntity &
                        inq_Ref_Ce(
							Cid					i_nId ) const = 0;
	virtual const CodeEntity *
                        inq_Find_Ce(
							Cid					i_nId ) const = 0;
    virtual const OperationSignature *
                        inq_Find_Signature(
                            OSid                i_nSignature ) const = 0;
	virtual const CodeEntity *
                        inq_Search_RelatedCe(
							Tid					i_nType ) const = 0;
    virtual const CodeEntity *
                        inq_Search_CeAbsolute(
                            const QualifiedName &
                                                i_rSearchedName ) const = 0;
    virtual const CodeEntity *
                        inq_Search_CeLocal(
                            const udmstri &     i_sLocalName,
                            bool                i_bIsFunction,
                            const Namespace &   i_rCurNamespace,
                            const Class *       i_pCurClass ) const = 0;
    virtual uintt       inq_Get_AlphabeticalList(
                            List_Rid &          o_sResult,
                            const char *        i_sBegin,
                            const char *        i_sEnd ) const = 0;
    virtual void        inq_Get_QualifiedName(
                            StreamStr &         o_rOut,
                            const udmstri &     i_sLocalName,
                            Cid                 i_nOwner,
                            const char *        i_sDelimiter ) const = 0;
    virtual bool        inq_Get_TypeText(
                            StreamStr &         o_rOut,
                            Tid                 i_nType ) const = 0;
    virtual bool        inq_Get_TypeText(
                            StreamStr &         o_rPreName,     ///  ::ary::cpp::
                            StreamStr &         o_rName,        ///  MyClass
                            StreamStr &         o_rPostName,    ///  <TplArgument> * const &
                            Tid                 i_nType ) const = 0;
    virtual void        inq_Get_SignatureText(
                            StreamStr &         o_rOut,
                            OSid                i_nSignature,
                            const StringVector *
                                                i_sParameterNames ) const = 0;
    virtual const Namespace &
                        inq_GlobalNamespace() const = 0;
    virtual const RoGate_Defines &
                        inq_RoDefines() const = 0;
    virtual const RoGate_Groups &
                        inq_RoGroups() const = 0;
    virtual const loc::RoGate &
                        inq_RoLocations() const = 0;
};


// IMPLEMENTATION

inline const CodeEntity &
DisplayGate::Ref_Ce( Cid i_nId ) const
    { return inq_Ref_Ce(i_nId); }
inline const CodeEntity *
DisplayGate::Find_Ce( Cid i_nId ) const
    { return inq_Find_Ce(i_nId); }
inline const OperationSignature *
DisplayGate::Find_Signature( OSid i_nSignature ) const
    { return inq_Find_Signature(i_nSignature); }
inline const CodeEntity *
DisplayGate::Search_RelatedCe( Tid i_nType ) const
    { return inq_Search_RelatedCe( i_nType ); }
inline const CodeEntity *
DisplayGate::Search_CeAbsolute( const QualifiedName & i_rSearchedName ) const
    { return inq_Search_CeAbsolute( i_rSearchedName ); }
inline const CodeEntity *
DisplayGate::Search_CeLocal( const udmstri &     i_sLocalName,
                             bool                i_bIsFunction,
                             const Namespace &   i_rCurNamespace,
                             const Class *       i_pCurClass ) const
    { return inq_Search_CeLocal( i_sLocalName, i_bIsFunction, i_rCurNamespace, i_pCurClass ); }
inline uintt
DisplayGate::Get_AlphabeticalList( List_Rid &          o_sResult,
                                   const char *        i_sBegin,
                                   const char *        i_sEnd ) const
    { return inq_Get_AlphabeticalList( o_sResult, i_sBegin, i_sEnd ); }
inline void
DisplayGate::Get_QualifiedName( StreamStr &         o_rOut,
                                const udmstri &     i_sLocalName,
                                Cid                 i_nOwner,
                                const char *        i_sDelimiter ) const
    { inq_Get_QualifiedName( o_rOut, i_sLocalName, i_nOwner, i_sDelimiter ); }
inline bool
DisplayGate::Get_TypeText( StreamStr &         o_rOut,
                           Tid                 i_nType ) const
    { return inq_Get_TypeText(o_rOut, i_nType); }
inline bool
DisplayGate::Get_TypeText( StreamStr &         o_rPreName,
                           StreamStr &         o_rName,
                           StreamStr &         o_rPostName,
                           Tid                 i_nType ) const
    { return inq_Get_TypeText(o_rPreName, o_rName, o_rPostName, i_nType); }
inline void
DisplayGate::Get_SignatureText( StreamStr &                     o_rOut,
                                OSid                            i_nSignature,
                                const StringVector *  i_sParameterNames  ) const
    { inq_Get_SignatureText(o_rOut, i_nSignature, i_sParameterNames); }
inline const Namespace &
DisplayGate::GlobalNamespace() const
    { return inq_GlobalNamespace() ; }
inline const RoGate_Defines &
DisplayGate::RoDefines() const
    { return inq_RoDefines(); }
inline const RoGate_Groups &
DisplayGate::RoGroups() const
    { return inq_RoGroups(); }
inline const loc::RoGate &
DisplayGate::RoLocations() const
    { return inq_RoLocations(); }



} // namespace cpp
} // namespace ary


#endif

