/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NextDocGenerator.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:58:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.util.NonnegativeIntegerGenerator;
import com.sun.xmlsearch.xml.XmlIndex;

final class NextDocGenerator {
    private int                   _document;
    private final int              _concept;
    private final int              _queryMask;
    private final ConceptData      _terms;
    private final NonnegativeIntegerGenerator  _iterator;

    public NextDocGenerator(ConceptData cd, XmlIndex env) {
	_document = 0;
	_concept = cd.getConcept();
	_queryMask = cd.getQueryMask();
	_terms = cd;
	_iterator = env.getDocumentIterator(_concept);
    }
  
    public int first() throws Exception {
	return _document = _iterator != null
	    ? _iterator.first()
	    : NonnegativeIntegerGenerator.END;
    }
  
    public int next() throws Exception {
	return _document = _iterator.next();
    }
  
    public int getDocument() {
	return _document;
    }
  
    public int getConcept() {
	return _concept;
    }
  
    public ConceptData getTerms() {
	return _terms;
    }
  
    public int getQueryMask() {
	return _queryMask;
    }
  
    // for sorting
    public boolean compareWith(NextDocGenerator other) {
	return _document > other._document  
	    || _document == other._document && _concept > other._concept;
    }

    public boolean smallerThan(NextDocGenerator other) {
	return _document < other._document  
	    || _document == other._document && _concept < other._concept;
    }
}
