/*************************************************************************
 *
 *  $RCSfile: GetOpenFileName.c,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: tra $ $Date: 2001/06/21 13:00:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>
#include <commdlg.h>
#include <systools/win32/StrConvert.h>
//#include "ConvertOfn.h"

#define DLL_EXPORT extern

//-----------------------------------------
// Precondition:	
//
DLL_EXPORT BOOL WINAPI GetOpenFileNameW_9x (
	LPOPENFILENAMEW lpofn )
{
	OPENFILENAMEA ofnA;
	OPENFILENAMEA* lpofnA     = NULL;
	LPSTR lpstrFilterA        = NULL;
	LPSTR lpstrCustomFilterA  = NULL;
	LPSTR lpstrFileA          = NULL;
	LPSTR lpstrFileTitleA     = NULL;
	LPSTR lpstrInitialDirA    = NULL;
	LPSTR lpstrTitleA         = NULL;
	LPSTR lpstrDefExtA        = NULL;
	LPSTR lpTemplateNameA     = NULL;	
	BOOL  bRetVal;

	if ( !lpofn )
		return FALSE;

	lpofnA = &ofnA;

	ZeroMemory( lpofnA, sizeof( OPENFILENAMEA ) );

	WCL2MBL( lpofn->lpstrFilter, lpstrFilterA );	
	WC2MB( lpofn->lpstrCustomFilter, lpstrCustomFilterA );

	if( lpofn->lpstrFile && (lpofn->nMaxFile > 0) )
		AllocSpaceAndCopyWStr2Str(
			lpofn->lpstrFile, lpofn->nMaxFile, &lpstrFileA );

	// special case because the length of the string is specified in 
	// nMaxFileTitle
	if ( lpofn->lpstrFileTitle && (lpofn->nMaxFileTitle > 0) )
		AllocSpaceAndCopyWStr2Str( 
			lpofn->lpstrFileTitle, lpofn->nMaxFileTitle, &lpstrFileTitleA );

	WC2MB( lpofn->lpstrInitialDir, lpstrInitialDirA );
	WC2MB( lpofn->lpstrTitle, lpstrTitleA );
	WC2MB( lpofn->lpstrDefExt, lpstrDefExtA );
	
	// if the template name is a resource id the
	// high word is 0 which is an invalid pointer
	if ( 0 == HIWORD( lpofnA->lpTemplateName ) ) 
	{
		lpofnA->lpTemplateName = (LPSTR)lpofn->lpTemplateName;
	}
	else
	{
		WC2MB( lpofn->lpTemplateName, lpTemplateNameA );
		lpofnA->lpTemplateName = lpTemplateNameA;
	}

	lpofnA->lStructSize		  = sizeof( OPENFILENAMEA);
	lpofnA->hwndOwner		  = lpofn->hwndOwner;
	lpofnA->hInstance		  = lpofn->hInstance;
	lpofnA->lpstrFilter       = lpstrFilterA;
	lpofnA->lpstrCustomFilter = lpstrCustomFilterA;
	lpofnA->nMaxCustFilter    = lpofn->nMaxCustFilter;
	lpofnA->nFilterIndex      = lpofn->nFilterIndex;
	lpofnA->lpstrFile         = lpstrFileA;
	lpofnA->nMaxFile          = lpofn->nMaxFile;
	lpofnA->lpstrFileTitle    = lpstrFileTitleA;
	lpofnA->nMaxFileTitle     = lpofn->nMaxFileTitle;
	lpofnA->lpstrInitialDir   = lpstrInitialDirA;
	lpofnA->lpstrTitle        = lpstrTitleA;
	lpofnA->Flags             = lpofn->Flags;
	lpofnA->nFileOffset       = lpofn->nFileOffset;
	lpofnA->nFileExtension    = lpofn->nFileExtension;
	lpofnA->lpstrDefExt       = lpstrDefExtA;
	lpofnA->lCustData         = lpofn->lCustData;
	lpofnA->lpfnHook          = lpofn->lpfnHook;	

	bRetVal = GetOpenFileNameA( lpofnA );

	// copy the strings back 

	if ( lpofnA->nMaxCustFilter > 0 )
		MultiByteToWideChar( 
			CP_ACP, 
			0, 
			lpofnA->lpstrCustomFilter, 
			lpofnA->nMaxCustFilter * sizeof( char ), 
			lpofn->lpstrCustomFilter, 
			lpofn->nMaxCustFilter );
		
	if ( (lpofnA->nMaxFile > 0) && lpofnA->lpstrFile )
		MultiByteToWideChar( 
			CP_ACP,
			0,
			lpofnA->lpstrFile,
			lpofnA->nMaxFile * sizeof( char ),
			lpofn->lpstrFile,
			lpofn->nMaxFile );
	
	if ( (lpofnA->nMaxFileTitle > 0) && lpofnA->lpstrFileTitle )
		MultiByteToWideChar( 
			CP_ACP,
			0,
			lpofnA->lpstrFileTitle,
			lpofnA->nMaxFileTitle * sizeof( char ),
			lpofn->lpstrFileTitle,
			lpofn->nMaxFileTitle );

	lpofn->nFilterIndex   = lpofnA->nFilterIndex;
	lpofn->nFileOffset    = lpofnA->nFileOffset;
	lpofn->nFileExtension = lpofnA->nFileExtension;

	// cleanup the heap allocated strings
	FreeSpaceStr( (LPSTR)lpofnA->lpstrFileTitle );
	FreeSpaceStr( (LPSTR)lpofnA->lpstrFile );

	return bRetVal;
}




