#ifndef THENCODE
#define THENCODE

/* some maximum sizes for buffers */
#define MAX_WD_LEN 70
#define MAX_WDS 65535
#define MAX_LN_LEN 16384

/* 
  read a line of text from a text file stripping
  off the line terminator and replacing it with
  a null string terminator.

  returns:  -1 on error or the number of characters in
             in the returning string

  A maximum of nc characters will be returned
*/
sal_Int32 readLine(File * pf, sal_Char * buf, sal_Int32 nc);


/*
  writes a fixed number of bytes to a File making sure
  the complete write occurs or an error is returned
*/
FileBase::RC writenc(File * pf, sal_Char * buf, sal_uInt64 nc);


/* 
  performs a binary search on null terminated character
  strings

  returns: -1 on not found
           index of wrd in the list[]
*/
sal_Int32 binsearch(sal_Char * wrd, sal_Char* list[], int nlst);


/*
   performs a special memcpy of a string of unsigned shorts
   which does endian swapping on little endian systems to
   create big endian versions of the data
*/
void end_cpy(sal_Char * q, sal_Char * p, sal_Int32 num_shorts);


#define A2OU(x) ::rtl::OUString::createFromAscii( x )
#define OU2A(rtlOUString)     ::rtl::OString((rtlOUString).getStr(), (rtlOUString).getLength(), RTL_TEXTENCODING_ASCII_US).getStr()

#endif
