/*************************************************************************
 *
 *  $RCSfile: datasourcemap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/19 17:52:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_DATASOURCEMAP_HXX
#include "datasourcemap.hxx"
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif
#ifndef _SFXITEMSET_HXX 
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXSTRITEM_HXX 
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX 
#include <svtools/eitem.hxx>
#endif
#ifndef _DBAUI_DATASOURCEITEMS_HXX_
#include "dsitems.hxx"
#endif
#ifndef _DBAUI_PROPERTYSETITEM_HXX_
#include "propertysetitem.hxx"
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................
	using namespace com::sun::star::uno;
	using namespace com::sun::star::lang;
	using namespace com::sun::star::beans;
	using namespace com::sun::star::container;
	//=====================================================================
	//= ODatasourceMap
	//=====================================================================
	//-------------------------------------------------------------------------
	ODatasourceMap::ODatasourceMap(const Reference< XMultiServiceFactory > _rxORB)
		:m_xORB(_rxORB)
	{
		// create the DatabaseContext service
		OSL_ENSURE(m_xORB.is(), "ODatasourceMap::ODatasourceMap: need a service factory !");
		try
		{
			m_xDatabaseContext = Reference< XNameAccess >(m_xORB->createInstance(SERVICE_SDB_DATABASECONTEXT), UNO_QUERY);
		}
		catch(Exception&)
		{
		}

		// initialize our map
		if (m_xDatabaseContext.is())
		{
			Sequence< ::rtl::OUString > aDatasources = m_xDatabaseContext->getElementNames();
			const ::rtl::OUString* pDatasources = aDatasources.getConstArray();
			for (sal_Int32 i=0; i<aDatasources.getLength(); ++i, ++pDatasources)
				m_aDatasources[*pDatasources] = DatasourceInfo();
		}
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator ODatasourceMap::begin()
	{
		return Iterator(this, m_aDatasources.begin());
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator ODatasourceMap::end()
	{
		return Iterator(this, m_aDatasources.end());
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator ODatasourceMap::beginDeleted()
	{
		return Iterator(this, m_aDeletedDatasources.begin());
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator ODatasourceMap::endDeleted()
	{
		return Iterator(this, m_aDeletedDatasources.end());
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::update(const ::rtl::OUString& _rName, SfxItemSet& _rSet)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::update: invalid name!!");
		if (aPos == m_aDatasources.end())
			return;

		if (aPos->second.pModifications)
			// already had modifications for this datasource
			// -> simply update them
			aPos->second.pModifications->Put(_rSet);
		else
		{
			// this is the first time this data source is modified -> create a new set and initialize it
			aPos->second.pModifications = new SfxItemSet(_rSet);
			aPos->second.pModifications->Put(SfxStringItem(DSID_ORIGINALNAME, _rName));
			aPos->second.pModifications->Put(SfxBoolItem(DSID_NEWDATASOURCE, sal_False));
			aPos->second.pModifications->Put(SfxBoolItem(DSID_DELETEDDATASOURCE, sal_False));

			// and reset the original name in the source set, it may contain an old one
			_rSet.Put(SfxStringItem(DSID_ORIGINALNAME, _rName));
		}
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::deleted(const ::rtl::OUString& _rName)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDeletedDatasources.end(), "ODatasourceMap::deleted: invalid access key!");
		if (aPos == m_aDeletedDatasources.end())
			return;

		delete aPos->second.pModifications;
		m_aDatasources.erase(aPos);
	}

	//-------------------------------------------------------------------------
	sal_Bool ODatasourceMap::restoreDeleted(sal_Int32 _nAccessId, ::rtl::OUString& _rName)
	{
		MapInt2InfoIterator aPos = m_aDeletedDatasources.find(_nAccessId);
		if (m_aDeletedDatasources.end() == aPos)
		{
			DBG_ERROR("ODatasourceSelector::restoreDeleted: invalid access id!");
			return sal_False;
		}

		// the name (not the original name) of the data source
		Iterator aEasyNameAccess(this, aPos);
		::rtl::OUString sName = aEasyNameAccess->getName();

		// check if we have a not-deleted data source with that name
		ConstDatasourceInfosIterator aExistentPos = m_aDatasources.find(sName);
		if (m_aDatasources.end() != aExistentPos)
			// yes -> too bad ...
			return sal_False;

		m_aDatasources[sName] = aPos->second;
		m_aDeletedDatasources.erase(aPos);
		_rName = sName;
		return sal_True;
	}

	//-------------------------------------------------------------------------
	sal_Int32 ODatasourceMap::markDeleted(const ::rtl::OUString& _rName)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::markDeleted: invalid name!!");
		if (aPos == m_aDatasources.end())
			return -1;

		// after the DatasourceInfo moved from m_aDatasources to m_aDeletedDatasources, we loose the info
		// of the name of the ds (which in m_aDatasources is the key). So later we need an modifications item set
		// or the real object itself to obtain that name.
		if (NULL == aPos->second.pModifications)
			ensureObject(_rName);

		// search a free access key
		const sal_uInt32 nPrime = 65521;
		sal_uInt32 nAccessKey = rand() % nPrime;	// the engendering

		for (sal_uInt32 nLoop=0; nLoop<nPrime; ++nLoop, nAccessKey = (nAccessKey * nAccessKey) % nPrime)
		{
			::std::pair< MapInt2InfoIterator, bool > aInsertPos
				= m_aDeletedDatasources.insert(MapInt2Info::value_type(nAccessKey, aPos->second));
			if (aInsertPos.second)
				// a new entry was inserted into m_aDeletedDatasources, which means the key wasn't used yet
				break;
		}
		if (nAccessKey<nPrime)
		{	// we found a free key ...
			// delete the DatasourceInfo from the other map
			m_aDatasources.erase(aPos);
			return nAccessKey;
		}

		DBG_ERROR("ODatasourceMap::markDeleted: could not find a free key (tried 65521 different ones ...)!");
		return -1;
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::clearModifiedFlag(const ::rtl::OUString& _rName)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::clearModifiedFlag: invalid name!!");
		if (aPos == m_aDatasources.end())
			return;

		if (aPos->second.pModifications)
		{
			delete aPos->second.pModifications;
			aPos->second.pModifications = NULL;
		}
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::clearDeleted()
	{
		for	(	ConstMapInt2InfoIterator aLoopDeleted = m_aDeletedDatasources.begin();
				aLoopDeleted != m_aDeletedDatasources.end();
				++aLoopDeleted
			)
		{
			if (aLoopDeleted->second.pModifications)
				delete aLoopDeleted->second.pModifications;
		}
		m_aDeletedDatasources.clear();
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::clear()
	{
		// the "ordinary" data sources
		for	(	ConstDatasourceInfosIterator aLoop = m_aDatasources.begin();
				aLoop != m_aDatasources.end();
				++aLoop
			)
		{
			if (aLoop->second.pModifications)
				delete aLoop->second.pModifications;
		}
		m_aDatasources.clear();

		// the deleted ones
		clearDeleted();
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::ensureObject(const ::rtl::OUString& _rName)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::ensureObject: invalid name!!");
		if (aPos == m_aDatasources.end())
			return;

		if (aPos->second.xDatasource.is())
			// nothing to do, the object already exists
			return;

		try
		{
			if (m_xDatabaseContext.is() && _rName.getLength())
				m_xDatabaseContext->getByName(_rName) >>= aPos->second.xDatasource;
			OSL_ENSURE(aPos->second.xDatasource.is(), "ODatasourceMap::ensureObject: could not retrieve the object!");
		}
		catch(NoSuchElementException&)
		{
			DBG_ERROR("ODatasourceMap::ensureObject: did not find the element with the given name!");
		}
		catch(WrappedTargetException&)
		{
			DBG_ERROR("ODatasourceMap::ensureObject: caught a WrappedTargetException!");
		}
	}

	//-------------------------------------------------------------------------
	::rtl::OUString ODatasourceMap::adjustRealName(const ::rtl::OUString& _rName)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::adjustRealName: invalid name!!");
		if (aPos == m_aDatasources.end())
			return _rName;

		if (!aPos->second.pModifications)
			return _rName;

		SFX_ITEMSET_GET(*aPos->second.pModifications, pRealName, SfxStringItem, DSID_NAME, sal_True);
		if (!pRealName)
			return _rName;

		::rtl::OUString sRealName = pRealName->GetValue().GetBuffer();
		if (sRealName.equals(_rName))
			// all fine
			return _rName;

		OSL_ENSURE(m_aDatasources.end() == m_aDatasources.find(sRealName), "ODatasourceMap::adjustRealName: have an invalid real name!");

		renamed(_rName, sRealName);
		return sRealName;
	}

	//-------------------------------------------------------------------------
	void ODatasourceMap::renamed(const ::rtl::OUString& _rOldName, const ::rtl::OUString& _rNewName)
	{
		DatasourceInfosIterator aPos = m_aDatasources.find(_rOldName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::renamed: invalid name!!");
		if (aPos == m_aDatasources.end())
			return;

		// insert the DatasourceInfo under the new name
		DatasourceInfo aInfo = aPos->second;
		m_aDatasources.erase(aPos);
		m_aDatasources[_rNewName] = aInfo;
	}

	//-------------------------------------------------------------------------
	sal_Bool ODatasourceMap::exists(const ::rtl::OUString& _rName) const
	{
		return isValid() && (m_aDatasources.end() != m_aDatasources.find(_rName));
	}

	//-------------------------------------------------------------------------
	Reference< XPropertySet > ODatasourceMap::createNew(const ::rtl::OUString& _rName, SfxItemPool* _pPool, const sal_uInt16* _pRanges)
	{
		Reference< XPropertySet > xReturn;
		try
		{
			xReturn = Reference< XPropertySet >(m_xORB->createInstance(SERVICE_SDB_DATASOURCE), UNO_QUERY);
		}
		catch(Exception&)
		{
		}

		if (xReturn.is())
		{
			// create a new item set
			SfxItemSet* pItems = new SfxItemSet(*_pPool, _pRanges);
			pItems->Put(SfxBoolItem(DSID_NEWDATASOURCE, sal_True));
			pItems->Put(SfxStringItem(DSID_NAME, _rName));
			pItems->Put(OPropertySetItem(DSID_DATASOURCE_UNO, xReturn));
			m_aDatasources[_rName] = DatasourceInfo(xReturn, pItems);
		}
		return xReturn;
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::ODatasourceInfo ODatasourceMap::operator[](const ::rtl::OUString _rName)
	{
		ConstDatasourceInfosIterator aPos = m_aDatasources.find(_rName);
		OSL_ENSURE(aPos != m_aDatasources.end(), "ODatasourceMap::operator[]: invalid name!!");
		if (aPos == m_aDatasources.end())
		{
			// just prevent crashes, the result here is completely nonsense
			static ODatasourceMap::DatasourceInfo aFallback;
			return ODatasourceInfo(NULL, ::rtl::OUString(), aFallback, -1);
		}

		return ODatasourceInfo(this, aPos->first, aPos->second, -1);
	}

	//-------------------------------------------------------------------------
	//- ODatasourceMap::ODatasourceInfo
	//-------------------------------------------------------------------------
	Reference< XPropertySet > ODatasourceMap::ODatasourceInfo::getDatasource() const
	{
		if (!m_rInfoImpl.xDatasource.is())
		{	// the object has not been accessed yet -> create it
			OSL_ENSURE(m_pOwner, "ODatasourceInfo::getDatasource: no owner which could provide the object!");
			OSL_ENSURE(!isNew(), "ODatasourceInfo::getDatasource: new object without property set!");

			if (m_pOwner)
				m_pOwner->ensureObject(getName());
		}
		return m_rInfoImpl.xDatasource;
	}

	//-------------------------------------------------------------------------
	::rtl::OUString	ODatasourceMap::ODatasourceInfo::getRealName() const
	{
		if (!isModified())
			return getName();

		::rtl::OUString sReturn;
		if (m_rInfoImpl.pModifications)
		{
			SFX_ITEMSET_GET(*m_rInfoImpl.pModifications, pRealName, SfxStringItem, DSID_NAME, sal_True);
			if (pRealName)
				sReturn = pRealName->GetValue().GetBuffer();
		}
		return sReturn;
	}

	//-------------------------------------------------------------------------
	::rtl::OUString	ODatasourceMap::ODatasourceInfo::getOriginalName() const
	{
		if (!isModified())
			return getName();

		::rtl::OUString sReturn;
		if (m_rInfoImpl.pModifications)
		{
			SFX_ITEMSET_GET(*m_rInfoImpl.pModifications, pOriginalName, SfxStringItem, DSID_ORIGINALNAME, sal_True);
			if (pOriginalName)
				sReturn = pOriginalName->GetValue().GetBuffer();
		}
		return sReturn;
	}

	//-------------------------------------------------------------------------
	sal_Bool ODatasourceMap::ODatasourceInfo::isModified() const
	{
		return NULL != m_rInfoImpl.pModifications;
	}

	//-------------------------------------------------------------------------
	sal_Bool ODatasourceMap::ODatasourceInfo::isNew() const
	{
		if (!m_rInfoImpl.pModifications)
			return sal_False;
		SFX_ITEMSET_GET(*m_rInfoImpl.pModifications, pIsNew, SfxBoolItem, DSID_NEWDATASOURCE, sal_True);
		return pIsNew && pIsNew->GetValue();
	}

	//-------------------------------------------------------------------------
	//- ODatasourceMap::Iterator
	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator::Iterator(ODatasourceMap* _pOwner, ODatasourceMap::ConstDatasourceInfosIterator _rPos)
		:m_pOwner(_pOwner)
		,m_aPos(_rPos)
		,m_aPosDeleted(_pOwner->m_aDeletedDatasources.end())
		,m_bLoopingDeleted(sal_False)
	{
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator::Iterator(ODatasourceMap* _pOwner, ODatasourceMap::ConstMapInt2InfoIterator _rPos)
		:m_pOwner(_pOwner)
		,m_aPos(_pOwner->m_aDatasources.end())
		,m_aPosDeleted(_rPos)
		,m_bLoopingDeleted(sal_True)
	{
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::Iterator::Iterator(const ODatasourceMap::Iterator& _rSource)
		:m_pOwner(_rSource.m_pOwner)
		,m_aPos(_rSource.m_aPos)
		,m_aPosDeleted(_rSource.m_aPosDeleted)
		,m_bLoopingDeleted(_rSource.m_bLoopingDeleted)
	{
	}

	//-------------------------------------------------------------------------
	const ODatasourceMap::Iterator&	ODatasourceMap::Iterator::operator++()
	{
		if (m_bLoopingDeleted)
			++m_aPosDeleted;
		else
			++m_aPos;
		return *this;
	}

	//-------------------------------------------------------------------------
	const ODatasourceMap::Iterator&	ODatasourceMap::Iterator::operator--()
	{
		if (m_bLoopingDeleted)
			--m_aPosDeleted;
		else
			--m_aPos;
		return *this;
	}

	//-------------------------------------------------------------------------
	::rtl::OUString ODatasourceMap::Iterator::implGetName(const ODatasourceMap::DatasourceInfo& _rInfo) const
	{
		::rtl::OUString sName;
		if (_rInfo.pModifications)
		{
			SFX_ITEMSET_GET(*_rInfo.pModifications, pName, SfxStringItem, DSID_NAME, sal_True);
			sName = pName->GetValue();
		}
		else
		{
			OSL_ENSURE(_rInfo.xDatasource.is(), "ODatasourceMap::Iterator::implGetName: no modifications, no object ... How am I supposed to get the name?");
			if (_rInfo.xDatasource.is())
			{
				try
				{
					_rInfo.xDatasource->getPropertyValue(PROPERTY_NAME) >>= sName;
				}
				catch(Exception&)
				{
					DBG_ERROR("ODatasourceMap::operator->: could not obtain the data source name!");
				}
			}
		}
		return sName;
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::ODatasourceInfo ODatasourceMap::Iterator::operator->() const
	{
		if (!m_bLoopingDeleted)
			return ODatasourceInfo(m_pOwner, m_aPos->first, m_aPos->second, -1);
		else
			return ODatasourceInfo(m_pOwner, implGetName(m_aPosDeleted->second), m_aPosDeleted->second, m_aPosDeleted->first);
	}

	//-------------------------------------------------------------------------
	ODatasourceMap::ODatasourceInfo ODatasourceMap::Iterator::operator*() const
	{
		if (!m_bLoopingDeleted)
			return ODatasourceInfo(m_pOwner, m_aPos->first, m_aPos->second, -1);
		else
			return ODatasourceInfo(m_pOwner, implGetName(m_aPosDeleted->second), m_aPosDeleted->second, m_aPosDeleted->first);
	}

//.........................................................................
}	// namespace dbaui
//.........................................................................

