/*************************************************************************
 *
 *  $RCSfile: test_unourl.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2002/10/02 15:29:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "cppuhelper/unourl.hxx"
#include "rtl/malformeduriexception.hxx"
#include "rtl/strbuf.hxx"
#include "rtl/string.h"
#include "rtl/textenc.h"
#include "rtl/tres.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"

namespace {

bool testDescriptorParsing(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        bool bValid;
    };
    static Test const aTests[]
        = { { "", false },
            { "abc", true },
            { "Abc", true },
            { "aBC", true },
            { "ABC", true },
            { "1abc", true },
            { "123", true },
            { "abc-1", false },
            { "ab%63", false },
            { "abc,", false },
            { "abc,def=", true },
            { "abc,Def=", true },
            { "abc,DEF=", true },
            { "abc,1def=", true },
            { "abc,123=", true },
            { "abc,def-1=", false },
            { "abc,def", false },
            { "abc,def=xxx,def=xxx", false },
            { "abc,def=xxx,ghi=xxx", true },
            { "abc,,def=xxx", false },
            { "abc,def=xxx,,ghi=xxx", false },
            { "abc,def=xxx,ghi=xxx,", false },
            { "abc,def=%", true },
            { "abc,def=%1", true },
            { "abc,def=%00", true },
            { "abc,def=%22", true },
            { "abc,def=\"", true },
            { "abc,def=%ed%a0%80", true } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        try
        {
            cppu::UnoUrlDescriptor aDescriptor(rtl::OUString::createFromAscii(
                                                   aTests[i].pInput));
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrlDescriptor(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\"): "));
        aResult.append(bValid ? "valid" : "invalid");
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].bValid ? "valid" : "invalid");
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult, bValid == aTests[i].bValid,
                                        aResult.getStr(),
                                        "testDescriptorParsing", false));
    }
    return bResult;
}

bool testDescriptorDescriptor(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pDescriptor;
    };
    static Test const aTests[]
        = {{ "abc", "abc" },
            { "Abc", "Abc" },
            { "aBC", "aBC" },
            { "ABC", "ABC" },
            { "1abc", "1abc" },
            { "123", "123" },
            { "abc,def=", "abc,def=" },
            { "abc,Def=", "abc,Def=" },
            { "abc,DEF=", "abc,DEF=" },
            { "abc,1def=", "abc,1def=" },
            { "abc,123=", "abc,123=" },
            { "abc,def=xxx,ghi=xxx", "abc,def=xxx,ghi=xxx" },
            { "abc,def=%", "abc,def=%" },
            { "abc,def=%1", "abc,def=%1" },
            { "abc,def=%00", "abc,def=%00" },
            { "abc,def=%22", "abc,def=%22" },
            { "abc,def=\"", "abc,def=\"" },
            { "abc,def=%ed%a0%80", "abc,def=%ed%a0%80" } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        rtl::OUString aDescriptor;
        try
        {
            aDescriptor = cppu::UnoUrlDescriptor(rtl::OUString::createFromAscii(
                                                     aTests[i].pInput)).
                getDescriptor();
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrlDescriptor(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\").getDescriptor(): "));
        if (bValid)
        {
            aResult.append('\"');
            aResult.append(rtl::OUStringToOString(aDescriptor,
                                                  RTL_TEXTENCODING_UTF8));
            aResult.append('\"');
        }
        else
            aResult.append(RTL_CONSTASCII_STRINGPARAM("invalid"));
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].pDescriptor);
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && aDescriptor.equalsAscii(
                                            aTests[i].pDescriptor),
                                        aResult.getStr(),
                                        "testDescriptorDescriptor", false));
    }
    return bResult;
}

bool testDescriptorName(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pName;
    };
    static Test const aTests[]
        = { { "abc", "abc" },
            { "Abc", "abc" },
            { "aBC", "abc" },
            { "ABC", "abc" },
            { "1abc", "1abc" },
            { "123", "123" },
            { "abc,def=", "abc" },
            { "abc,Def=", "abc" },
            { "abc,DEF=", "abc" },
            { "abc,1def=", "abc" },
            { "abc,123=", "abc" },
            { "abc,def=xxx,ghi=xxx", "abc" },
            { "abc,def=%", "abc" },
            { "abc,def=%1", "abc" },
            { "abc,def=%00", "abc" },
            { "abc,def=%22", "abc" },
            { "abc,def=\"", "abc" },
            { "abc,def=%ed%a0%80", "abc" } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        rtl::OUString aName;
        try
        {
            aName = cppu::UnoUrlDescriptor(rtl::OUString::createFromAscii(
                                               aTests[i].pInput)).getName();
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrlDescriptor(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\").getName(): "));
        if (bValid)
        {
            aResult.append('\"');
            aResult.append(rtl::OUStringToOString(aName,
                                                  RTL_TEXTENCODING_UTF8));
            aResult.append('\"');
        }
        else
            aResult.append(RTL_CONSTASCII_STRINGPARAM("invalid"));
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].pName);
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && aName.equalsAscii(aTests[i].pName),
                                        aResult.getStr(),
                                        "testDescriptorName", false));
    }
    return bResult;
}

bool testDescriptorKey(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pKey;
        bool bPresent;
    };
    static Test const aTests[]
        = { { "abc", "abc", false },
            { "abc", "def", false },
            { "1abc", "def", false },
            { "123", "def", false },
            { "abc,def=", "abc", false },
            { "abc,def=", "def", true },
            { "abc,def=", "defg", false },
            { "abc,def=", "de", false },
            { "abc,def=", "ghi", false },
            { "abc,Def=", "def", true },
            { "abc,Def=", "Def", true },
            { "abc,Def=", "dEF", true },
            { "abc,Def=", "DEF", true },
            { "abc,def=xxx,ghi=xxx", "abc", false },
            { "abc,def=xxx,ghi=xxx", "def", true },
            { "abc,def=xxx,ghi=xxx", "ghi", true },
            { "abc,def=xxx,ghi=xxx", "jkl", false } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        bool bPresent;
        try
        {
            bPresent = cppu::UnoUrlDescriptor(rtl::OUString::createFromAscii(
                                                  aTests[i].pInput)).
                hasParameter(rtl::OUString::createFromAscii(aTests[i].pKey));
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrlDescriptor(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\").hasParameter(\""));
        aResult.append(aTests[i].pKey);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\"): "));
        aResult.append(bValid ? bPresent ? "true" : "false" : "invalid");
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].bPresent ? "true" : "false");
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && bPresent == aTests[i].bPresent,
                                        aResult.getStr(),
                                        "testDescriptorKey", false));
    }
    return bResult;
}

bool testDescriptorValue(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pKey;
        char const * pValue;
    };
    static Test const aTests[]
        = { { "abc", "abc", "" },
            { "abc", "def", "" },
            { "1abc", "def", "" },
            { "123", "def", "" },
            { "abc,def=", "abc", "" },
            { "abc,def=", "def", "" },
            { "abc,def=", "defg", "" },
            { "abc,def=", "de", "" },
            { "abc,def=", "ghi", "" },
            { "abc,Def=", "def", "" },
            { "abc,Def=", "Def", "" },
            { "abc,Def=", "dEF", "" },
            { "abc,Def=", "DEF", "" },
            { "abc,def=xxx,ghi=xxx", "abc", "" },
            { "abc,def=xxx,ghi=xxx", "def", "xxx" },
            { "abc,def=xxx,ghi=xxx", "ghi", "xxx" },
            { "abc,def=xxx,ghi=xxx", "jkl", "" },
            { "abc,def=%", "def", "%" },
            { "abc,def=%1", "def", "%1" },
            { "abc,def=%22", "def", "\"" },
            { "abc,def=\"", "def", "\"" },
            { "abc,def=abc", "def", "abc" },
            { "abc,def=Abc", "def", "Abc" },
            { "abc,def=aBC", "def", "aBC" },
            { "abc,def=ABC", "def", "ABC" },
            { "abc,def=%,ghi=", "def", "%" },
            { "abc,def=%1,ghi=", "def", "%1" },
            { "abc,def=%22,ghi=", "def", "\"" },
            { "abc,def=\",ghi=", "def", "\"" },
            { "abc,def=abc,ghi=", "def", "abc" },
            { "abc,def=Abc,ghi=", "def", "Abc" },
            { "abc,def=aBC,ghi=", "def", "aBC" },
            { "abc,def=ABC,ghi=", "def", "ABC" },
            { "abc,abc=,def=%", "def", "%" },
            { "abc,abc=,def=%1", "def", "%1" },
            { "abc,abc=,def=%22", "def", "\"" },
            { "abc,abc=,def=\"", "def", "\"" },
            { "abc,abc=,def=abc", "def", "abc" },
            { "abc,abc=,def=Abc", "def", "Abc" },
            { "abc,abc=,def=aBC", "def", "aBC" },
            { "abc,abc=,def=ABC", "def", "ABC" } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        rtl::OUString aValue;
        try
        {
            aValue = cppu::UnoUrlDescriptor(rtl::OUString::createFromAscii(
                                                aTests[i].pInput)).
                getParameter(rtl::OUString::createFromAscii(aTests[i].pKey));
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrlDescriptor(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\").getParameter(\""));
        aResult.append(aTests[i].pKey);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\"): "));
        if (bValid)
        {
            aResult.append('\"');
            aResult.append(rtl::OUStringToOString(aValue,
                                                  RTL_TEXTENCODING_UTF8));
            aResult.append('\"');
        }
        else
            aResult.append(RTL_CONSTASCII_STRINGPARAM("invalid"));
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != \""));
        aResult.append(aTests[i].pValue);
        aResult.append('\"');
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && aValue.equalsAscii(aTests[i].pValue),
                                        aResult.getStr(),
                                        "testDescriptorValue", false));
    }
    return bResult;
}

bool testUrlParsing(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        bool bValid;
    };
    static Test const aTests[]
        = { { "", false },
            { "abc", false },
            { "uno", false },
            { "uno:", false },
            { "uno:abc;def;ghi", true },
            { "Uno:abc;def;ghi", true },
            { "uNO:abc;def;ghi", true },
            { "UNO:abc;def;ghi", true },
            { "uno:abc,def=xxx,ghi=xxx;def,ghi=xxx,jkl=xxx;ghi", true },
            { "uno:abc,def=xxx,ghi=xxx;def,ghi=xxx,jkl=xxx,;ghi", false },
            { "uno:abc;def;", false },
            { "uno:abc;def;a", true },
            { "uno:abc;def;A", true },
            { "uno:abc;def;1", true },
            { "uno:abc;def;$&+,/:=?@", true },
            { "uno:abc;def;%24&+,/:=?@", false } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        try
        {
            cppu::UnoUrl aUrl(rtl::OUString::createFromAscii(aTests[i].pInput));
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrl(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM("\"): "));
        aResult.append(bValid ? "valid" : "invalid");
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].bValid ? "valid" : "invalid");
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult, bValid == aTests[i].bValid,
                                        aResult.getStr(), "testUrlParsing",
                                        false));
    }
    return bResult;
}

bool testUrlConnection(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pConnection;
    };
    static Test const aTests[]
        = { { "uno:abc;def;ghi", "abc" },
            { "uno:Abc;def;ghi", "Abc" },
            { "uno:aBC;def;ghi", "aBC" },
            { "uno:ABC;def;ghi", "ABC" },
            { "uno:abc,def=xxx,ghi=xxx;def,ghi=xxx,jkl=xxx;ghi",
              "abc,def=xxx,ghi=xxx" } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        rtl::OUString aConnection;
        try
        {
            aConnection = cppu::UnoUrl(rtl::OUString::createFromAscii(
                                           aTests[i].pInput)).
                getConnection().getDescriptor();
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrl(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM(
                           "\").getConnection().getDescriptor(): "));
        if (bValid)
        {
            aResult.append('\"');
            aResult.append(rtl::OUStringToOString(aConnection,
                                                  RTL_TEXTENCODING_UTF8));
            aResult.append('\"');
        }
        else
            aResult.append(RTL_CONSTASCII_STRINGPARAM("invalid"));
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].pConnection);
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && aConnection.equalsAscii(
                                            aTests[i].pConnection),
                                        aResult.getStr(),
                                        "testUrlConnection", false));
    }
    return bResult;
}

bool testUrlProtocol(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pProtocol;
    };
    static Test const aTests[]
        = { { "uno:abc;def;ghi", "def" },
            { "uno:abc;Def;ghi", "Def" },
            { "uno:abc;dEF;ghi", "dEF" },
            { "uno:abc;DEF;ghi", "DEF" },
            { "uno:abc,def=xxx,ghi=xxx;def,ghi=xxx,jkl=xxx;ghi",
              "def,ghi=xxx,jkl=xxx" } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        rtl::OUString aProtocol;
        try
        {
            aProtocol = cppu::UnoUrl(rtl::OUString::createFromAscii(
                                         aTests[i].pInput)).
                getProtocol().getDescriptor();
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrl(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM(
                           "\").getProtocol().getDescriptor(): "));
        if (bValid)
        {
            aResult.append('\"');
            aResult.append(rtl::OUStringToOString(aProtocol,
                                                  RTL_TEXTENCODING_UTF8));
            aResult.append('\"');
        }
        else
            aResult.append(RTL_CONSTASCII_STRINGPARAM("invalid"));
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].pProtocol);
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && aProtocol.equalsAscii(
                                            aTests[i].pProtocol),
                                        aResult.getStr(),
                                        "testUrlProtocol", false));
    }
    return bResult;
}

bool testUrlObjectName(rtl_TestResult * pTestResult)
{
    struct Test
    {
        char const * pInput;
        char const * pObjectName;
    };
    static Test const aTests[]
        = { { "uno:abc;def;ghi", "ghi" },
            { "uno:abc;def;Ghi", "Ghi" },
            { "uno:abc;def;gHI", "gHI" },
            { "uno:abc;def;GHI", "GHI" },
            { "uno:abc,def=xxx,ghi=xxx;def,ghi=xxx,jkl=xxx;ghi", "ghi" },
            { "uno:abc;def;a", "a" },
            { "uno:abc;def;A", "A" },
            { "uno:abc;def;1", "1" },
            { "uno:abc;def;$&+,/:=?@", "$&+,/:=?@" } };
    bool bResult = true;
    for (int i = 0; i < sizeof aTests / sizeof (Test); ++i)
    {
        bool bValid = false;
        rtl::OUString aObjectName;
        try
        {
            aObjectName = cppu::UnoUrl(rtl::OUString::createFromAscii(
                                           aTests[i].pInput)).getObjectName();
            bValid = true;
        }
        catch (rtl::MalformedUriException &)
        {}
        rtl::OStringBuffer aResult;
        aResult.append(RTL_CONSTASCII_STRINGPARAM("UnoUrl(\""));
        aResult.append(aTests[i].pInput);
        aResult.append(RTL_CONSTASCII_STRINGPARAM(
                           "\").getObjectName(): "));
        if (bValid)
        {
            aResult.append('\"');
            aResult.append(rtl::OUStringToOString(aObjectName,
                                                  RTL_TEXTENCODING_UTF8));
            aResult.append('\"');
        }
        else
            aResult.append(RTL_CONSTASCII_STRINGPARAM("invalid"));
        aResult.append(RTL_CONSTASCII_STRINGPARAM(" != "));
        aResult.append(aTests[i].pObjectName);
        bResult &= static_cast< bool >(
            pTestResult->pFuncs->state_(pTestResult,
                                        bValid
                                        && aObjectName.equalsAscii(
                                            aTests[i].pObjectName),
                                        aResult.getStr(),
                                        "testUrlObjectName", false));
    }
    return bResult;
}

}

extern "C" sal_Bool SAL_CALL test_UnoUrl(rtl_TestResult * pTestResult)
{
    return testDescriptorParsing(pTestResult)
        & testDescriptorDescriptor(pTestResult)
        & testDescriptorName(pTestResult)
        & testDescriptorKey(pTestResult)
        & testDescriptorValue(pTestResult)
        & testUrlParsing(pTestResult)
        & testUrlConnection(pTestResult)
        & testUrlProtocol(pTestResult)
        & testUrlObjectName(pTestResult);
}
