/*  VER 015  TAB P  $Id: sim.c,v 1.2.2.6 2003/01/21 09:47:25 egil Exp $
 *
 *  "simulated" storage-API interface
 *  retrieves traditional articles in a way
 *  that emulates the API to allow consistent handling
 *
 *  $Log: sim.c,v $
 *  Revision 1.2.2.6  2003/01/21 09:47:25  egil
 *  Renamed MAXHEADERSIZE to MAX_HEADER_SIZE due to name collision
 *
 *  Revision 1.2.2.5  2002/09/21 17:36:32  egil
 *  Bug #82: Incorrect quoting of leading periods
 *
 *  Revision 1.2.2.4  2002/09/21 17:20:36  egil
 *  A long range of patches incorporated..
 *
 *  Revision 1.2.2.3  2002/01/29 22:12:37  egil
 *  Fix for realloc bug
 *
 *  Revision 1.2.2.2  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.2.2.1  2001/02/14 06:55:40  egil
 *  Fixes from Winston Edmond
 *
 *  Revision 1.2  1999/03/31 05:53:46  src
 *  Seperated MAXHEADERSIZE from NNTP_STRLEN
 *
 *  Revision 1.1  1999/03/11 08:00:53  src
 *  Moved from storage
 *
 *  Revision 1.1  1999/03/07 14:58:24  src
 *  Storage API supported.
 */

#include "common.h"
#include "proto.h"
#include "nntp.h"
#include "stat.h"
#include "sim.h"
#include "news.h" /* MAX_HEADER_SIZE */

#define CHUNK_LEN (5*MAX_HEADER_SIZE)

static char *newline = "\r\n";

/*
 *  retrieve entire article
 */
ARTHANDLE *
SIMretrieve(const char *name)
{
    FILE *fp;
    char *art;
    int art_len;
    int alloc_len = CHUNK_LEN;
    int multi_1st = 0;
    int is_newline = 1;
    char *line;
    int len;
    ARTHANDLE *ap;
    struct stat st;

    SMerrorstr = NULL;

    if ((fp = fopen(name, "r")) == NULL) {
	SMerrorstr = str_error(errno);
	return 0;
    }

    line = art = malloc_perfect(alloc_len);
    art_len = 0;

    for (;;) {
	/* allocate more room, if needed */
	if (alloc_len-art_len <= MAX_HEADER_SIZE+2+1) {
	    char *prev_art = art;
	    alloc_len += CHUNK_LEN;
	    art = realloc_perfect(art, alloc_len);
	    /* reallocation may have caused buffer to move: readjust line */
	    /* fix by: Bernhard R. Erdmann */
	    line += art - prev_art;
	}

	/* BUG: does not work with articles containing NULs */
	line[MAX_HEADER_SIZE] = '\0';
	if (!fgets(line, MAX_HEADER_SIZE, fp)) break;

	/* must remove trailing linefeed */
	if ((len=strlen(line)) == 0) break;

	multi_1st = is_newline; /* if previous line ended here */
	if (line[len-1] == '\n') {
	    /* a complete line, or line termination */
	    is_newline = 1;
	    line[--len] = '\0';
	} else {
	    /*
	     * no newline detected - handle very long lines too
	     * problem pinpointed by Riku Saikkonen <rjs@isil.lloke.dna.fi>
	     */
	    is_newline = 0;
	}
	if (multi_1st && line[0] == '.') {
	    /*
	     * posting contains EOF, so convert to something
	     * harmless according to RFC-977, section 3.10.1
	     * fix by Riku Saikkonen <rjs@isil.lloke.dna.fi>
	     * 
	     * AM: s/^\./../ according to rfc977, not only
	     *     s/^\.$/../, "real" SMretrieve does this, too.
	     */
		char next, curr='.';
		char *pos;
		int i=0;
		
		pos=line;
		while (i<=len) {
			next=*pos;
			*pos=curr;
			curr=next;
			pos++;
			i++;
		}

	    len++;
	}
	if (is_newline) {
	    strcpy(line+len,newline);
	    len += strlen(newline);
	}
	line += len;
	art_len += len;
    }

    /* finished */
    if (!is_newline) {
	/* no trailing newline, so we need to add one */
	strcpy(line,newline);
	line += strlen(newline);
    }
    /* add end-of-file */
    sprintf(line, ".%s", newline);
    line += 3;

    if (ferror(fp)) {
	SMerrorstr = str_error(errno);
	fclose(fp);
	free(art);
	return 0;
    }

    /* all set */
    ap = malloc_perfect(sizeof(ARTHANDLE));

    ap->data = art;
    ap->len = line-art;
    time(&ap->arrived);
    if (fstat(fileno(fp),&st) >= 0) ap->arrived = st.st_mtime;

    fclose(fp);

    return ap;
}

/*
 *  free up storage following SIMretrieve
 */
void
SIMfreearticle(ARTHANDLE *article)
{
    if (article) {
	free(article->data);
	free(article);
    }
}
