/*  VER 117  TAB P   $Id: active.c,v 1.12.2.1 2002/01/29 06:44:48 egil Exp $
 *
 *  handle the local active file
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: active.c,v $
 *  Revision 1.12.2.1  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.12  1999/03/16 08:12:46  src
 *  Moved clean_active() to active.c
 *
 *  Revision 1.11  1999/03/07 14:58:17  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.10  1998/10/25 13:43:07  src
 *  Minor code readability issue
 *
 *  Revision 1.9  1998/09/09 07:32:10  src
 *  Version 1.1
 *
 *  Revision 1.8  1998/09/06 06:21:03  src
 *  Improved bad syntax message
 *
 *  Revision 1.7  1998/09/03 05:14:30  src
 *  Improved bad syntax messages
 *
 *  Revision 1.5  1998/09/03 02:49:29  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.4  1998/07/12 09:39:27  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"
#include "newsconfig.h"

static void
clear_active(void);

/* 
 *  globals for active 
 */
typedef struct active_grp {
    struct active_grp *next;
    char seen;
    char name[1]; /* extend as required... */
} ACTIVE_GRP;

#define ACTIVE_HASH 1023
ACTIVE_GRP *activegrp[ACTIVE_HASH] = { 0 };

/*
 *  find group on active list
 */
static ACTIVE_GRP *
find_active(char *group)
{
    ACTIVE_GRP *ap;
    long h = hashindex(group,ACTIVE_HASH);

    for (ap = activegrp[h]; ap; ap = ap->next) {
	if (strcmp(ap->name,group)==0) return ap;
    }
    return 0; /* not in list... */
}

/*
 *  add group to list of active groups
 */
static void
active_group(char *group)
{
    int n; 
    ACTIVE_GRP *ap;
    long h = hashindex(group,ACTIVE_HASH);

    if (!group[0] || !sys_allow(group)) return;

    /* BUG: check if already? */
    n = sizeof(ACTIVE_GRP) + strlen(group);

    ap = malloc_perfect(n);

    /* add to list of active groups at that hashindex */
    ap->seen = 0;
    strcpy(ap->name,group);
    ap->next = activegrp[h];
    activegrp[h] = ap;
}

/*
 *  see if group is on active list
 */
int 
is_in_active(char *group)
{
    return find_active(group) != 0;
}

/*
 *  see if group is on active list, and is not yet seen
 *  mark it as seen 
 */
int 
is_active(char *group)
{
    ACTIVE_GRP *ap;

    if (!(ap = find_active(group))) {
	return 0; /* not in list... */
    }
    if (ap->seen) return 0; /* seen already... */
    ap->seen = 1;
    return 1;
}

/*
 *  go through all groups in the active list that is not yet seen    
 *  NOTE: the in-core active list will be lost
 */
int 
unseen_active(char *group)
{
    int ok = 0;
    ACTIVE_GRP *ap;
    static int latest_h = 0;
    int h;

    for (h=latest_h; h<ACTIVE_HASH; ++h) {
	while ((ap = activegrp[h])) {
	    if (!ap->seen) {
		strcpy(group,ap->name);
		ok = 1;
	    }
	    activegrp[h] = ap->next;
	    free(ap);
	    if (ok) {
		latest_h = h;
		return 1;
	    }
	}
    }
    latest_h = 0;
    return 0;
}

/*
 *  load local active file
 *  assumes load_sys has been performed
 */
void
load_active(int again)
{
    FILE *f;
    int n;
    char buf[BUFSIZ];
    char *p;
    char group[BUFSIZ];
    long a,b;
    char isact;
    int clean = 1;

    progtitle("read active");

    if (!(f = fopen(cfg_active,"r"))) {
	log_msg(L_ERRno,"can't open \"%s\"",cfg_active);
	exit_cleanup(8);
    }
    log_msg(L_DEBUG,"%sreading %s",(again ? "re-":""), cfg_active);
    if (again) clear_active();

    /* load local active file */
    while (fgets(buf,BUFSIZ,f)) {
	p = buf;
	if (clean) {
	    while (isspace(*p)) ++p;
	    if (p[0] && p[0] != '#') {
		n = sscanf(p,"%[^ \n\t!:] %ld %ld %c",group,&a,&b,&isact);
		if (!bad_syntax(buf,n,4,cfg_active)) {
		    if (isact == 'y' || isact == 'm') {
			/* group is active */
			active_group(group);
		    }
		}
	    }
	}
	/* see if line is excessively long */
	p += strlen(p);
	clean = (p > buf && *(p-1) == '\n');
    }
    fclose(f);
}

/*
 *  clear local active file
 */
static void
clear_active(void)
{
    int h;
    ACTIVE_GRP *p,*pn;

    for (h=0; h<ACTIVE_HASH; ++h) {
	p = activegrp[h];
	while (p) {
	    pn = p->next;
	    free(p);
	    p = pn;
	}
	activegrp[h] = 0;
    }
}


/*
 *  check if bad syntax
 */
int
bad_syntax(char *buf,int was,int expect,char *where)
{
    char *p;

    if (was == expect) return 0;

    /* there may be a trailing newline */
    if ((p=strchr(buf,'\n')) && p[1]=='\0') *p = '\0';
    else p = 0;

    log_msg(L_ERR,"bad syntax in %s (item %d of %d) \"%s\"",
					  where,was+1,expect,buf);
    if (p) *p = '\n';
    return 1;
}
