<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Utils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_POST["documentid"]) || !is_numeric($_POST["documentid"]) || intval($_POST["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$documentid = $_POST["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");
UI::contentHeading(getMLText("approve_document"));

if ($document->getAccessMode($user) < M_READ) {
	UI::contentContainer(getMLText("access_denied"));
	UI::htmlEndPage();
	exit;
}

if (!isset($_POST["version"]) || !is_numeric($_POST["version"]) || intval($_POST["version"])<1) {
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}
$version = $_POST["version"];
$content = $document->getContentByVersion($version);
if (!is_object($content)) {
	// die ("Unable to retrieve version information for document '". $document->getName() ."', version ". $version .".");
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}

// Retrieve a snapshot of the overall status of the document.
$status = $content->getStatus();
if ($status["status"]==0) {
	UI::contentContainer(getMLText("cannot_approve_pending_review"));
	UI::htmlEndPage();
	exit;
}

if (!isset($_POST["approvalStatus"]) || !is_numeric($_POST["approvalStatus"]) ||
		(intval($_POST["approvalStatus"])!=1 && intval($_POST["approvalStatus"])!=-1)) {
	UI::contentContainer(getMLText("invalid_approval_status").".");
	UI::htmlEndPage();
	exit;
}

UI::contentContainerStart();

// retrieve the approve status for the current user.
$approvalStatus = $user->getApprovalStatus($documentid, $version);
if (count($approvalStatus["indstatus"]) == 0 && count($approvalStatus["grpstatus"]) == 0) {
	UI::contentSubHeading(getMLText("warning"));
	printMLText("not_approver");
	UI::contentContainerEnd();
	UI::htmlEndPage();
	exit;
}

if ($_POST["approvalType"] == "ind") {
	$indApprover = true;
	if (count($approvalStatus["indstatus"])==0) {
		UI::contentSubHeading(getMLText("warning"));
		printMLText("not_approver");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	if ($approvalStatus["indstatus"][0]["status"]==-2) {
		UI::contentSubHeading(getMLText("warning"));
		print "<dl><dt>".getMLText("user_removed_approver")."</dt>";
		$indUser=getUser($approvalStatus["indstatus"][0]["userID"]);
		print "<dd><ul class=\"actions\"><li class=\"first\">".getMLText("status_changed_by")." ".$indUser->getFullName()." <".$indUser->getEmail().">, ". $approvalStatus["indstatus"][0]["date"] .".</li>";
		print "<li>".getMLText("comment").": ". $approvalStatus["indstatus"][0]["comment"] ."</li></ul></dd></dl>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	if ($approvalStatus["indstatus"][0]["status"]!=0) {
		UI::contentSubHeading(getMLText("warning"));
		print "<dl><dt>".getMLText("user_already_approved").".</dt>";
		$indUser=getUser($approvalStatus["indstatus"][0]["userID"]);
		print "<dd><ul><li>". getApprovalStatusText($approvalStatus["indstatus"][0]["status"]) ." by ".$indUser->getFullName()." <".$indUser->getEmail().">, ". $approvalStatus["indstatus"][0]["date"] .".</li>";
		print "<li>". getMLText("comment").": ". $approvalStatus["indstatus"][0]["comment"] ."</li></ul></dd></dl>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	// User is eligible to make this update.

	$comment = sanitizeString($_POST["comment"]);
	$queryStr = "INSERT INTO `tblDocumentApproveLog` (`approveID`, `status`, `comment`, `date`, `userID`) ".
		"VALUES ('". $approvalStatus["indstatus"][0]["approveID"] ."', '".
		$_POST["approvalStatus"] ."', '". $comment ."', NOW(), '". $user->getID() ."')";
	$res=$db->getResult($queryStr);
	if (is_bool($res) && !res) {
		UI::contentSubHeading(getMLText("warning"));
		printMLText ("approval_update_failed");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	else {
		// Send an email notification to the document owner.
		$subject = "[Document Approval]: ".$document->getName().", v. ".$version;
		$message = $user->getFullName()." <". $user->getEmail() ."> ".
			"has ". ($_POST["approvalStatus"]==1 ? "approved" : "rejected") ." the following document:";
		$message = wordwrap ($message, 72, "\r\n");
		$message .= "\r\n\r\n\t   Name: ".$document->getName()."\r\n".
			"\tVersion: ".$version."\r\n".
			"\tApproval Status: ".getApprovalStatusText($_POST["approvalStatus"])."\r\n".
			"\tComment: ".$comment."\r\n".
			"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ViewDocument.php?documentid=".$documentid."\r\n";
		if (Email::toIndividual($user, $document->getOwner(), $subject, $message)<0) {
			UI::contentSubHeading(getMLText("warning"));
			print "Error sending email to document owner.";
		}
	}
}
else if ($_POST["approvalType"] == "grp") {
	$grpApprover=false;
	foreach ($approvalStatus["grpstatus"] as $gs) {
		if ($_POST["approvalGroup"] == $gs["required"]) {
			if ($gs["status"]==-2) {
				UI::contentSubHeading(getMLText("warning"));
				$grp=getGroup($gs["required"]);
				print "<dl><dt>".getMLText("group")." ". $grp->getName() ." ".getMLText("removed_approver").".</dt>";
				$u=getUser($gs["userID"]);
				print "<dd><ul><li>".getMLText("status_changed_by")." ".$u->getFullName()." <".$u->getEmail().">, ". $gs["date"] .".</li>";
				print "<li>".getMLText("comment").": ". $gs["comment"] ."</li></ul></dd></dl>";
				UI::contentContainerEnd();
				UI::htmlEndPage();
				exit;
			}
			if ($gs["status"]!=0) {
				UI::contentSubHeading(getMLText("warning"));
				$grp=getGroup($gs["required"]);
				print "<dl><dt>".getMLText("group_already_approved")." '". $grp->getName() ."'.</dt>";
				$u=getUser($gs["userID"]);
				print "<dd><ul><li>". getApprovalStatusText($gs["status"]) ." by ".$u->getFullName()." <".$u->getEmail().">, ". $gs["date"] .".</li>";
				print "<li>".getMLText("comment").": ". $gs["comment"] ."</li></ul></dd></dl>";
				UI::contentContainerEnd();
				UI::htmlEndPage();
				exit;
			}
			$grpStatus=$gs;
			$grpApprover=true;
			break;
		}
	}
	if (!$grpApprover) {
		UI::contentSubHeading(getMLText("warning"));
		printMLText("not_approver");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	// User is eligible to make this update.

	$comment = sanitizeString($_POST["comment"]);
	$queryStr = "INSERT INTO `tblDocumentApproveLog` (`approveID`, `status`, `comment`, `date`, `userID`) ".
		"VALUES ('". $grpStatus["approveID"] ."', '".
		$_POST["approvalStatus"] ."', '". $comment ."', NOW(), '". $user->getID() ."')";
	$res=$db->getResult($queryStr);
	if (is_bool($res) && !res) {
		UI::contentSubHeading(getMLText("warning"));
		printMLText("approval_update_failed");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	else {
		// Send an email notification to the document owner.
		$subject = "[Document Approval]: ".$document->getName().", v. ".$version;
		$grp = getGroup($grpStatus["required"]);
		$message = $user->getFullName()." <". $user->getEmail() ."> ".
			"has ". ($_POST["approvalStatus"]==1 ? "approved" : "rejected") ." the following document on behalf of group '". $grp->getName() ."':";
		$message = wordwrap ($message, 72, "\r\n");
		$message .= "\r\n\r\n\t   Name: ".$document->getName()."\r\n".
			"\tVersion: ".$version."\r\n".
			"\tApproval Status: ".getApprovalStatusText($_POST["approvalStatus"])."\r\n".
			"\tComment: ".$comment."\r\n".
			"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ViewDocument.php?documentid=".$documentid."\r\n";
		if (Email::toIndividual($user, $document->getOwner(), $subject, $message)<0) {
			UI::contentSubHeading(getMLText("warning"));
			print "Error sending email to document owner.";
		}
	}
}

//
// Check to see if the overall status for the document version needs to be
// updated.
//

// If the overall document status != "pending approval", do nothing.
// Otherwise, Retrieve a fresh snapshot of the approval status from the database.
if ($status["status"]==1) {
	$docApprovalStatus = $content->getApprovalStatus(true);
	if (is_bool($docApprovalStatus) && !$docApprovalStatus) {
		UI::contentSubHeading(getMLText("warning"));
		printMLText("cannot_retrieve_approval_snapshot");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$approvalCT = 0;
	$approvalTotal = 0;
	foreach ($docApprovalStatus as $drstat) {
		if ($drstat["status"] == 1) {
			$approvalCT++;
		}
		if ($drstat["status"] != -2) {
			$approvalTotal++;
		}
	}
	// If all approvals have been received and there are no rejections, retrieve a
	// count of the approvals required for this document.
	if ($approvalCT == $approvalTotal) {
		// Change the status to released.
		$newStatus=2;
		if ($content->setStatus($newStatus, "Automatic update generated on receipt of last required approval")) {
			//Send email notification to document owner reporting the change in status.
			$subject = "[Document Status Update]: ".$document->getName().", v. ".$version;
			$message = "Automatic status update generated on receipt of last required approval for the following document:";
			$message = wordwrap ($message, 72, "\r\n");
			$message .= "\r\n\r\n\t   Name: ".$document->getName()."\r\n".
				"\tVersion: ".$version."\r\n".
				"\tOverall Status: ".getOverallStatusText($newStatus)."\r\n".
				"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ViewDocument.php?documentid=".$documentid."\r\n";
			if (Email::toIndividual($user, $document->getOwner(), $subject, $message)<0) {
				UI::contentSubHeading(getMLText("warning"));
				print "Error sending email to document owner.";
			}
		}
	}
}

//
// Report successful result to user.
//
print getMLText("approve_document_complete").".";
print "<p>".getMLText("approve_document_complete_records_updated").".</p>";

UI::contentContainerEnd();
UI::htmlEndPage();
?>
