/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.util.ResourceBundleUtil;

class BezierNodeEdit
extends AbstractUndoableEdit {
    private BezierFigure owner;
    private int index;
    private BezierPath.Node oldValue;
    private BezierPath.Node newValue;

    public BezierNodeEdit(BezierFigure bezierFigure, int n, BezierPath.Node node, BezierPath.Node node2) {
        this.owner = bezierFigure;
        this.index = n;
        this.oldValue = node;
        this.newValue = node2;
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        if (this.oldValue.mask != this.newValue.mask) {
            return resourceBundleUtil.getString("edit.bezierNode.changeType.text");
        }
        return resourceBundleUtil.getString("edit.bezierNode.movePoint.text");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.setNode(this.index, this.newValue);
        this.owner.changed();
        if (this.oldValue.mask != this.newValue.mask) {
            // empty if block
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.setNode(this.index, this.oldValue);
        this.owner.changed();
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof BezierNodeEdit) {
            BezierNodeEdit bezierNodeEdit = (BezierNodeEdit)undoableEdit;
            if (bezierNodeEdit.owner == this.owner && bezierNodeEdit.index == this.index) {
                this.newValue = bezierNodeEdit.newValue;
                return true;
            }
        }
        return false;
    }
}

