/*!================================================================
 module:    vpr03Cancel.c

 responsible: BurkhardD
 
 special area:   CPCDrv | Client | CANCEL
 
 description: Cancel of SQL Commands
 
 see:  
 



    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 ===================================================================*/

/*==================================================================*
 *  INCLUDES                                                        *
 *==================================================================*/

#include "hsp26.h"
#include "gpr00.h"
#include "precom/sqlcancel.h"

/*==================================================================*
 *  DECLARATIONS                                                    *
 *==================================================================*/

static SQLCancelProc *pr03CancelCallBack = NULL;

/*==================================================================*
 *  EXPORTED FUNCTIONS                                                      *
 *==================================================================*/

void pr03Cancel(int session);

/*==================================================================*
 *  PROTOTYPES                                                      *
 *==================================================================*/

/*==================================================================*
 *  DIRTY DECLARATIONS                                                    *
 *==================================================================*/

/*==================================================================*
 *  CODE                                                            *
 *==================================================================*/

/*!
  Function: sqlInitCancelProc 

  description: Teilt der Interface Runtime die Adresse einer Callbackfunktion
      mit, die jeweils vor dem sqlareceive eines SQL Kommandos aufgerufen wird.
      Die Callbackfunktion kann das gerade laufende SQL Kommando mittels
      EXEC SQL CANCEL abbrechen.
      
  arguments:
      sqlCancelCallBack  [in]  Zeiger auf Callbackfunktion

  returns: 
      Die Adresse, auf der zuletzt gesetzten Callbackfunktion.
 */

SQLCancelProc *
sqlInitCancelProc(SQLCancelProc *sqlCancelCallBack)
{
  SQLCancelProc *pOld = pr03CancelCallBack;
  pr03CancelCallBack = sqlCancelCallBack;
  return(pOld);
}

void pr03Cancel(int session)
{
  if (pr03CancelCallBack)
    pr03CancelCallBack(session);
}

