#!/usr/bin/perl
#
# $SRC/extern/libunwind/build_libunwind.pl
#
# This script is used to extract,configure and make libunwind from source package
#
# Modify these values if using a different libunwind package
#
$LIBUNWINDVERSION="libunwind-0.98.3";
$LIBUNWINDTAR=$LIBUNWINDVERSION.".tar.gz";
$EXTERNDIR=$ENV{WRK}."/extern";
$EXTERNINCLUDEDIR=$ENV{WRK}."/incl/extern";
$LIBUNWINDMAKEDIR=$EXTERNDIR."/".$LIBUNWINDVERSION;
print "build_libunwind called extracting sources\n";
system("cd $EXTERNDIR;        tar -xzf $LIBUNWINDTAR")          && die "Extracting $LIBUNWINDTAR failed";
print "configure --prefix=$EXTERNDIR called\n";
system("cd $LIBUNWINDMAKEDIR; ./configure --exec_prefix=$EXTERNDIR --prefix=$EXTERNINCLUDEDIR") && die "Configuring $LIBUNWINDVERSION failed";
print "make AM_FLAGS=-fPIC called\n";
system("cd $LIBUNWINDMAKEDIR; make AM_CFLAGS=-fPIC")             && die "Making $LIBUNWINDVERSION failed";
print "make AM_FLAGS=-fPIC install-includeHEADERS install-nodist_includeHEADERS install-exec called\n";
system("cd $LIBUNWINDMAKEDIR; make AM_CFLAGS=-fPIC install-includeHEADERS install-nodist_includeHEADERS install-exec")  && die "Making $LIBUNWINDVERSION failed";
