/*!***************************************************************************

  module      : RTEIO_DevSpaceInfo.h

  -------------------------------------------------------------------------

  responsible : StefanP

  special area: InputOutput
  description : Updating physical device information for devspaces (C Interface)

  last changed: 2001-04-05  16:11
  see also    : 

  -------------------------------------------------------------------------



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/


#ifndef RTEIO_DEVSPACEINFO_H
#define RTEIO_DEVSPACEINFO_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*===========================================================================*
 *  PROTOTYPS                                                                *
 *===========================================================================*/



/*!
  Function: RTEIO_UpdatePhysicalDevInfoForDevspace
  Description: Update information about physical devices of a specific devspace (UNIX only)

  Arguments: pDevspace [in/out]     Pointer to devspace

 */
externC void RTEIO_UpdatePhysicalDevInfoForDevspace (DEV_DESCR      *pDevspace);

#endif  /* RTEIO_DEVSPACEINFO_HPP */
