; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=X64

; bitcast v12i8 to v3i32

define void @convert(<12 x i8>* %dst.addr, <3 x i32> %src) nounwind {
; X86-LABEL: convert:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-NEXT:    psubd %xmm1, %xmm0
; X86-NEXT:    pextrd $2, %xmm0, 8(%eax)
; X86-NEXT:    pextrd $1, %xmm0, 4(%eax)
; X86-NEXT:    movd %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64-LABEL: convert:
; X64:       # %bb.0:
; X64-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-NEXT:    psubd %xmm1, %xmm0
; X64-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; X64-NEXT:    movq %xmm0, (%rdi)
; X64-NEXT:    retq
	%add = add <3 x i32> %src, < i32 1, i32 1, i32 1 >
	%conv = bitcast <3 x i32> %add to <12 x i8>
	store <12 x i8> %conv, <12 x i8>* %dst.addr
	ret void
}
