/* This file is part of the KDE project

   Copyright (C) 1999, 2000 Rik Hemsley <rik@kde.org>
             (C) 1999, 2000 Wilco Greven <j.w.greven@student.utwente.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef RMM_DATE_TIME_H
#define RMM_DATE_TIME_H

#include <qcstring.h>
#include <qdatastream.h>
#include <qdatetime.h>

#include <rmm/Defines.h>
#include <rmm/HeaderBody.h>
#include <rmm/Enum.h>

namespace RMM {

/**
 * A DateTime encapsulates a time value. It is basically a QDateTime with an
 * added 'asUnixTime()' method and knowledge of time zones.
 */ 
class DateTime : public HeaderBody {

#include "rmm/DateTime_generated.h"

    public:
        
        QDateTime qdt();
        void setTimeZone(const QCString &);
    
        QCString    timeZone();
        Q_UINT32    asUnixTime();

    private:

        QCString    zone_;
        QDateTime   qdate_;
};

}

#endif //RDATETIME_H
// vim:ts=4:sw=4:tw=78
