/*
 * ircaux.h: header file for ircaux.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: ircaux.h,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _IRCAUX_H_
#define _IRCAUX_H_

#include "irc.h"
#include "irc_std.h"
#include <stdio.h>
#ifdef WANT_TCL
#undef USE_TCLALLOC
#include <tcl.h>
#endif

typedef int comp_len_func (char *, char *, int);
typedef int comp_func (char *, char *);

extern unsigned char stricmp_table[];


char *	check_nickname 		(char *);
char *	next_arg 		(char *, char **);
char *	new_next_arg 		(char *, char **);
char *	new_new_next_arg 	(char *, char **, char *);
char *	last_arg 		(char **);
char *	expand_twiddle 		(char *);
char *	upper 			(char *);
char *	lower 			(char *);
char *	sindex			(register char *, char *);
char *	rsindex 		(register char *, char *, char *, int);
char *	path_search 		(char *, char *);
char *	double_quote 		(const char *, const char *, char *);

char *	n_malloc_strcpy		(char **, const char *, const char *, const char *, const int);
char *	malloc_str2cpy		(char **, const char *, const char *);
char *	n_malloc_strcat 	(char **, const char *, const char *, const char *, const int);

char *	m_s3cat_s 		(char **, const char *, const char *);
char *	m_s3cat 		(char **, const char *, const char *);
char *	m_3cat 			(char **, const char *, const char *);
char *	m_e3cat 		(char **, const char *, const char *);
char *	m_2dup 			(const char *, const char *);
char *	m_3dup 			(const char *, const char *, const char *);
char *	m_opendup 		(const char *, ...);
char *	n_m_strdup 		(const char *, const char *, const char *, const int);
char *	malloc_sprintf 		(char **, const char *, ...);
char *	m_sprintf 		(const char *, ...);
int	is_number 		(const char *);
char *	my_ctime 		(time_t);

#if 0
#define my_stricmp(x, y) strcasecmp(x, y) /* unable to use these for reasons of case sensitivity and finish */
#define my_strnicmp(x, y, n) strncasecmp(x, y, n)
#else
int	my_stricmp 	(const unsigned char *, const unsigned char *);
int	my_strnicmp	(const unsigned char *, const unsigned char *, size_t);
#endif

int	my_strnstr 		(const unsigned char *, const unsigned char *, size_t);
int	scanstr 		(char *, char *);
void	really_free 		(int);
char *	chop 			(char *, int);
char *	strmcpy 		(char *, const char *, int);
char *	strmcat 		(char *, const char *, int);
char *	strmcat_ue 		(char *, const char *, int);
char *	n_m_strcat_ues 		(char **, char *, int, const char *, const char *, const int);
char *	stristr 		(const char *, const char *);
char *	rstristr 		(char *, char *);
FILE *	uzfopen 		(char **, char *, int);
int	end_strcmp 		(const char *, const char *, int);
void	ircpanic		(char *, ...) __A(1);

int	fw_strcmp 		(comp_len_func *, char *, char *);
int	lw_strcmp 		(comp_func *, char *, char *);
int	open_to 		(char *, int, off_t);
struct timeval get_time 	(struct timeval *);
double 	time_diff 		(struct timeval, struct timeval);
char *	plural 			(int);
int	time_to_next_minute 	(void);
char *	remove_trailing_spaces 	(char *);
char *	ltoa			(long);
char *	strformat 		(char *, const char *, int, char);
char *	chop_word 		(char *);
int	splitw 			(char *, char ***);
char *	unsplitw 		(char ***, int);
int	check_val 		(char *);
char *	strextend 		(char *, char, int);
char *	strext			(char *, char *);
char *	pullstr 		(char *, char *);
int 	empty 			(const char *);
char *	safe_new_next_arg 	(char *, char **);
char *	MatchingBracket 	(register char *, register char, register char);
int	word_count 		(char *);
int	parse_number 		(char **);
char *	remove_brackets 	(const char *, const char *, int *);
u_long	hashpjw 		(char *, u_long);
char *	m_dupchar 		(int);
char *	strmccat		(char *, char, int);
off_t	file_size		(char *);
int	is_root			(char *, char *, int);
size_t	streq			(const char *, const char *);
size_t	strieq			(const char *, const char *);
char *	n_m_strndup		(const char *, size_t, const char *, const char *, const int);
char *	on_off 			(int);
char *	rfgets			(char *, int, FILE *);
char *  strmopencat             (char *, int, ...);
long 	my_atol			(const char *);
char *	s_next_arg		(char **);
char *	next_in_comma_list	(char *, char **);
void	strip_control		(const char *, char *);
int	figure_out_address	(char *, char **, char **, char **, char **, int *);
int	count_char		(const unsigned char *, const unsigned char);
char *	strnrchr		(char *, char, int);
void	mask_digits		(char **);
const char *strfill		(char, int);
char *	ov_strcpy		(char *, const char *);
char *	strpcat			(char *, const char *, ...) __A(2);
char *  strmpcat		(char *, size_t, const char *, ...) __A(3);
char *	chomp			(char *);
size_t	ccspan			(const char *, int);
u_char *strcpy_nocolorcodes	(u_char *, const u_char *);

u_long	random_number		(u_long);
char *	get_userhost		(void);


/* From words.c */
#define SOS -32767
#define EOS 32767
char	*search			(register char *, char **, char *, int);
char	*move_to_abs_word	(const register char *, char **, int);
char	*move_word_rel		(const register char *, char **, int);
char	*extract		(char *, int, int);
char	*extract2		(const char *, int, int);
int	wild_match		(register const unsigned char *, register const unsigned char *);

/* Used for connect_by_number */
#define SERVICE_SERVER 0
#define SERVICE_CLIENT 1
#define PROTOCOL_TCP 0
#define PROTOCOL_UDP 1

/* Used from network.c */
int			connect_by_number (char *, unsigned short *, int, int, int);
#define resolv		lookup_host
struct sockaddr_foobar *	lookup_host(const char *);
#define lookup_ip	host_to_ip
char *			host_to_ip (const char *);
char *			ip_to_host (const char *);
char *			one_to_another (const char *);
int			set_blocking (int);
int			set_non_blocking (int);
int			my_accept (int, struct sockaddr *, int *);
int			lame_resolv (const char *, struct sockaddr_foobar *);

#define my_isspace(x) \
	((x) == 9 || (x) == 10 || (x) == 11 || (x) == 12 || (x) == 13 || (x) == 32)
  
#define my_isdigit(x) \
(*x >= '0' && *x <= '9') || \
((*x == '-'  || *x == '+') && (x[1] >= '0' && x[1] <= '9'))

#define LOCAL_COPY(y) strcpy(alloca(strlen((y)) + 1), y)


#define	_1KB	((double) 1000)
#define _1MEG	(_1KB * _1KB)
#define _1GIG	(_1KB * _1KB * _1KB)
#define _1TER	(_1KB * _1KB * _1KB * _1KB)
#define _1ETA	(_1KB * _1KB * _1KB * _1KB * _1KB)

#if 0
#define	_1MEG	(1024.0*1024.0)
#define	_1GIG	(1024.0*1024.0*1024.0)
#define	_1TER	(1024.0*1024.0*1024.0*1024.0)
#define	_1ETA	(1024.0*1024.0*1024.0*1024.0*1024.0)
#endif

#define	_GMKs(x)	( ((double)x > _1ETA) ? "eb" : \
			(((double)x > _1TER) ? "tb" : (((double)x > _1GIG) ? "gb" : \
			(((double)x > _1MEG) ? "mb" : (((double)x > _1KB)? "kb" : "bytes")))))

#define	_GMKv(x)	(((double)x > _1ETA) ? \
			((double)x/_1ETA) : (((double)x > _1TER) ? \
			((double)x/_1TER) : (((double)x > _1GIG) ? \
			((double)x/_1GIG) : (((double)x > _1MEG) ? \
			((double)x/_1MEG) : (((double)x > _1KB) ? \
			((double)x/_1KB): (double)x)))) )

void	*n_malloc 	(size_t, const char *, const char *, const int);
void	*n_realloc	(void **, size_t, const char *, const char *, const int);

void	*n_free 	(void **, const char *, const char *, const int);

#define MODULENAME NULL

#define new_malloc(x) n_malloc(x, MODULENAME, __FILE__, __LINE__)
#define new_free(x) n_free((void **)(x), MODULENAME, __FILE__, __LINE__)

#define RESIZE(x, y, z) n_realloc     ((void **)& (x), sizeof(y) * (z), MODULENAME, __FILE__, __LINE__)
#define malloc_strcpy(x, y) n_malloc_strcpy((char **)x, (char *)y, MODULENAME, __FILE__, __LINE__)
#define malloc_strcat(x, y) n_malloc_strcat((char **)x, (char *)y, MODULENAME, __FILE__, __LINE__)
#define m_strdup(x) n_m_strdup(x, MODULENAME, __FILE__, __LINE__)
#define m_strcat_ues(x, y, z) n_m_strcat_ues(x, y, z, MODULENAME, __FILE__, __LINE__)
#define m_strndup(x, y) n_m_strndup(x, y, MODULENAME, __FILE__, __LINE__)

char	*encode			(const char *, int);
char	*decode			(const char *);
char	*cryptit		(const char *);
int	checkpass		(const char *, const char *);


/* Used for the inbound mangling stuff */

#define MANGLE_ESCAPES		1 << 0
#define MANGLE_ANSI_CODES	1 << 1
#define STRIP_COLOR		1 << 2
#define STRIP_REVERSE		1 << 3
#define STRIP_UNDERLINE		1 << 4
#define STRIP_BOLD		1 << 5
#define STRIP_BLINK		1 << 6
#define STRIP_ROM_CHAR          1 << 7
#define STRIP_ND_SPACE          1 << 8
#define STRIP_ALL_OFF		1 << 9
#define STRIP_ALT_CHAR		1 << 10
#define PRE_MANGLE		1 << 11

extern	int     outbound_line_mangler;
extern	int     inbound_line_mangler;
extern	int	logfile_line_mangler;
extern	int	operlog_line_mangler;

void	mangle_line		(char *, int, int);
int	charcount		(const char *, char);
char	*stripdev		(char *);
char	*convert_dos		(char *);
char	*convert_unix		(char *);
int	is_dos			(char *);
void	strip_chars		(char *, char *, char);
char	*longcomma		(long);
char	*ulongcomma		(unsigned long);

#define SAFE(x) (((x) && *(x)) ? (x) : empty_string)

/* Used in compat.c */
#ifndef HAVE_TPARM
	char 	*tparm (const char *, ...);
#endif

#ifndef HAVE_STRTOUL
	unsigned long 	strtoul (const char *, char **, int);
#endif

	char *	bsd_getenv (const char *);
	int	bsd_putenv (const char *);
	int	bsd_setenv (const char *, const char *, int);
	void	bsd_unsetenv (const char *);

#ifndef HAVE_INET_ATON
	int	inet_aton (const char *, struct in_addr *);
#endif

#ifndef HAVE_STRLCPY
	size_t	strlcpy (char *, const char *, size_t);
#endif

#ifndef HAVE_STRLCAT
	size_t	strlcat (char *, const char *, size_t);
#endif

#ifndef HAVE_VSNPRINTF
	int	vsnprintf (char *, size_t, const char *, va_list);
#endif

#ifndef HAVE_SNPRINTF
	int	snprintf (char *, size_t, const char *, ...);
#endif

#ifndef HAVE_SETSID
	int	setsid (void);
#endif

#endif /* _IRCAUX_H_ */
