/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxbandwidthgraph.h,v 1.1.6.3 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _BANDWIDTH_GRAPH_H_
#define _BANDWIDTH_GRAPH_H_

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define HX_TYPE_BANDWIDTH_GRAPH            (hx_bandwidth_graph_get_type ())
#define HX_BANDWIDTH_GRAPH(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), HX_TYPE_BANDWIDTH_GRAPH, HXBandwidthGraph))
#define HX_BANDWIDTH_GRAPH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), HX_TYPE_BANDWIDTH_GRAPH, HXBandwidthGraphClass))
#define HX_IS_BANDWIDTH_GRAPH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HX_TYPE_BANDWIDTH_GRAPH))
#define HX_IS_BANDWIDTH_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HX_TYPE_BANDWIDTH_GRAPH))
#define HX_BANDWIDTH_GRAPH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), HX_TYPE_BANDWIDTH_GRAPH, HXBandwidthGraphClass))

typedef struct _HXBandwidthGraph      HXBandwidthGraph;
typedef struct _HXBandwidthGraphClass HXBandwidthGraphClass;

struct _HXBandwidthGraph
{
    GtkWidget widget;

    guint y_tick_count;
    guint head_room;
    gdouble seconds_per_tick;

    guint ideal_bandwidth;
    
    GList* points;

    GdkGC* gc;

    GdkPixmap* pixmap;

    gdouble cutoff_time;
    
    GdkColor background_color;
    GdkColor grid_color;
    GdkColor line_color;
};

struct _HXBandwidthGraphClass
{
    GtkWidgetClass parent_class;
};

GtkWidget* hx_bandwidth_graph_new       (void);
GType      hx_bandwidth_graph_get_type  (void) G_GNUC_CONST;
void       hx_bandwidth_graph_add_value (HXBandwidthGraph* graph,
                                         guint             bandwidth);
void       hx_bandwidth_graph_update    (HXBandwidthGraph* graph);

void       hx_bandwidth_graph_set_ideal_bandwidth(HXBandwidthGraph* graph,
                                                  guint             bandwidth);

G_END_DECLS

#endif
