/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxflsrc.h,v 1.11.2.1 2004/07/09 02:05:57 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _HX_FILE_SOURCE_
#define _HX_FILE_SOURCE_

#include "hxbsrc.h"
#include "hxsrc.h"

// forward decl..
class CHXString;

struct IHXFileMimeMapperResponse;
struct IHXFormatResponse;
struct IHXPluginSearchEnumerator;

#include "hxcom.h"
#include "ihxpckts.h"
#include "chxpckts.h"
#include "hxfiles.h"
#include "recognizer.h"

class HXFileSource : public HXSource, 
		      public IHXFormatResponse,
                      public IHXHTTPRedirectResponse
{
public:
			 HXFileSource(void);

    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     * IHXPendingStatus methods
     */

    /************************************************************************
     *	Method:
     *	    IHXPendingStatus::GetStatus
     *	Purpose:
     *	    Called by the user to get the current pending status from an object
     */
    STDMETHOD(GetStatus)	(THIS_
				REF(UINT16) uStatusCode, 
				REF(IHXBuffer*) pStatusDesc, 
				REF(UINT16) ulPercentDone);

    /*
     *	IHXRegistryID methods
     */

    /************************************************************************
     *	Method:
     *	    IHXRegistryID::GetID
     *	Purpose:
     *	    Get registry ID(hash_key) of the objects(player, source and stream)
     *
     */
    STDMETHOD(GetID)		(THIS_
				REF(UINT32) /*OUT*/  ulRegistryID);

    /************************************************************************
     *	Method:
     *	    IHXInfoLogger::LogInformation
     *	Purpose:
     *	    Logs any user defined information in form of action and 
     *	    associated data.
     */
    STDMETHOD(LogInformation)		(THIS_				
					const char* /*IN*/ pAction,
					const char* /*IN*/ pData);


    /************************************************************************
     *	Method:
     *	    IHXSourceBufferingStats::GetCurrentBuffering
     *	Purpose:
     *	    Get the current buffering information
     */

    STDMETHOD(GetCurrentBuffering) (THIS_ 
                                    UINT16  uStreamNumber,
                                    REF(INT64)  llLowestTimestamp, 
                                    REF(INT64)  llHighestTimestamp,
                                    REF(UINT32) ulNumBytes,
                                    REF(BOOL)   bDone);
    void	ReSetup();

	    HX_RESULT 	Setup(const CHXURL* pURL, BOOL bAltURL);

    virtual HX_RESULT	DoCleanup(EndCode endCode = END_STOP);

    virtual HX_RESULT	DoSeek(ULONG32 seekTime);
    
    virtual HX_RESULT	DoPause(void);

    virtual HX_RESULT	DoResume(void);

    virtual HX_RESULT	StartInitialization(void);

    virtual UINT16	GetNumStreams(void);

    virtual HX_RESULT	GetStreamInfo(ULONG32 ulStreamNumber,
				      STREAM_INFO*& theStreamInfo);

    virtual HX_RESULT	GetEvent(UINT16 usStreamNumber, CHXEvent * &theEvent);

    virtual BOOL	IsStatisticsReady(void);

#if defined(HELIX_FEATURE_ASM)
    virtual BOOL	IsSimulatedNetworkPlayback()  {return (m_pSimulatedSourceBandwidth != NULL);};
#endif /* HELIX_FEATURE_ASM */

	    BOOL	IsSourceDone(void);

    /*
     *	IHXFormatResponse methods
     */

    STDMETHOD(InitDone)			(THIS_
					HX_RESULT	status);

    STDMETHOD(FileHeaderReady)		(THIS_
					HX_RESULT	status,
					IHXValues*	pHeader);

    STDMETHODIMP	StreamHeaderReady(HX_RESULT status, IHXValues* pHeader);
    STDMETHODIMP	PacketReady(HX_RESULT status, IHXPacket* pPacket);
    STDMETHODIMP	StreamDone(UINT16   unStreamNumber);


    STDMETHODIMP	SeekDone(HX_RESULT status);

    /************************************************************************
     *	Method:
     *	    IHXHTTPRedirectResponse::RedirectDone
     *	Purpose:
     *	    return the redirect URL
     */
    STDMETHOD(RedirectDone)		(THIS_ IHXBuffer* pURL);
    
    // tell about end of source...
    virtual void	SetEndOfClip(BOOL bForcedEndofClip = FALSE);

	    void	AdjustClipBandwidthStats(BOOL bActivate = FALSE);

	    BOOL	CanBeResumed(void);
	    void	CheckForDefaultUpgrade(HX_RESULT status);
            HX_RESULT   ContinueWithFileHeader(HX_RESULT status, IHXValues* pHeader);
    virtual HX_RESULT	ContinueWithFileHeaderExt(HX_RESULT status, IHXValues* pHeader);
    virtual HX_RESULT	StreamHeaderReadyExt(IHXValues* pHeader);

    virtual HX_RESULT	UpdateRegistry(UINT32 ulRegistryID);

    virtual HX_RESULT	FillRecordControl();

protected:
    LONG32			m_lRefCount;

    virtual 		~HXFileSource(void);

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    virtual HX_RESULT	UpdateStatistics(void);

    virtual HX_RESULT	_ProcessIdle(BOOL atInterrupt = 0);
    virtual HX_RESULT	_ProcessIdleExt(BOOL atInterrupt = 0);
	    
	    HX_RESULT   FillBuffers(void);

	    void	ReBuffer(void);

	    void	ReportError(HX_RESULT theErr);
	    void	CleanupFileObjects();
	    HX_RESULT	InitializeFileFormat();
	    void	CalculateCurrentBuffering(void);
            void        GetFileDone(HX_RESULT rc, IHXBuffer* pFile);

            HX_RESULT HandleSDPData(IHXValues* pHeader);

    UINT32		    m_ulLastBufferingReturned;
    UINT32		    m_ulInitialTime;
    INT64		    m_llFillEndTime;
    INT64		    m_llLastFillEndTime;
    UINT32		    m_ulMaxPreRoll;  
    UINT16		    m_uNumStreamsToBeFilled : 16;
    HX_BITFIELD		    m_bInFillMode : 1;
    HX_BITFIELD		    m_bInitialPacket : 1;
    HX_BITFIELD		    m_bFastStartInProgress : 1;
    HX_BITFIELD		    m_bAddDefaultUpgrade : 1;
    HX_BITFIELD		    m_bCurrentFileFormatUnkInUse: 1;
    HX_BITFIELD		    m_bValidateMetaDone: 1;
    char*		    m_pDefaultUpgradeString;

    IHXFileSystemObject*   m_pFSObject;
    IHXFileFormatObject*   m_pFFObject;
    IHXFileFormatObject*   m_pRAMFFObject;
    IHXFileResponse*	    m_pFileResponse;
    IHXPluginSearchEnumerator*	    m_pFileFormatEnumerator;
    IUnknown*		    m_pCurrentFileFormatUnk;

    //////////////////////////////////////////////////////
    // The following members and encapsulated classes are
    // used to determine the mime-type of the file we are
    // asked to read.
public:
    void FinishSetup(HX_RESULT status, const char* pMimeType);
    void AttempToLoadFilePlugin(const char* pMimeType);
    HX_RESULT ExtendedSetup(const char* pszURL);

protected:
    IHXFileObject*		m_pFileObject;
    IHXRequestHandler*		m_pRequestHandler;
    char*			m_pMimeType;		    
    char*			m_pExtension;		    

    class CMimeFinderFileResponse : public IHXFileMimeMapperResponse,
                                    public IHXFileRecognizerResponse
    {
    private:
	HXFileSource*	m_pSource;
	LONG32		m_lRefCount;
    public:
	CMimeFinderFileResponse(HXFileSource* pSource)
	    { 
		m_pSource = pSource; 
		m_lRefCount = 0;
	    };

	// IUnknown methods
	STDMETHOD(QueryInterface)	(THIS_
					REFIID riid,
					void** ppvObj);

	STDMETHOD_(ULONG32,AddRef)  (THIS);
	STDMETHOD_(ULONG32,Release) (THIS);
    
	// IHXFileMimeMapperResponse methods
	STDMETHOD(MimeTypeFound) (THIS_
				  HX_RESULT   status,
				  const char* pMimeType);
	
        // IHXFileRecognizerResponse methods
        STDMETHOD(GetMimeTypeDone) (THIS_ HX_RESULT status, IHXBuffer* pMimeType);
    };

    CMimeFinderFileResponse*	m_pMimeFinderResponse;

#if defined(HELIX_FEATURE_ASM)
    class SourceBandwidthInfo : public IHXSourceBandwidthInfo
    {
    private:
	LONG32		m_lRefCount;
    public:
	SourceBandwidthInfo() {m_lRefCount = 0;};
	~SourceBandwidthInfo() {};
	/*
	 *	IUnknown methods
	 */
	STDMETHOD(QueryInterface)	(THIS_
				    REFIID riid,
				    void** ppvObj);

	STDMETHOD_(ULONG32,AddRef)	(THIS);

	STDMETHOD_(ULONG32,Release)	(THIS);

	/*
	 *	IHXSourceBandwidthInfo methods
	 */
	STDMETHOD(InitBw)		(THIS_
				    IHXBandwidthManagerInput* pBwMgr);

	STDMETHOD(SetTransmitRate)	(THIS_
				    UINT32 ulBitRate);

    };

    SourceBandwidthInfo*    m_pSimulatedSourceBandwidth;
#endif /* HELIX_FEATURE_ASM */

    UINT32  GetEventBeginTime(INT64 llPacketTime, UINT32 streamPreRoll);
    
    class CFileReader : public IHXFileResponse
    {
    public:
        CFileReader(HXFileSource* pOwner);
        ~CFileReader();

        STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
        STDMETHOD_(ULONG32,AddRef)(THIS);
        STDMETHOD_(ULONG32,Release)(THIS);

        // IHXFileResponse methods
        STDMETHOD(InitDone)  (THIS_ HX_RESULT status);
        STDMETHOD(SeekDone)  (THIS_ HX_RESULT status);
        STDMETHOD(ReadDone)  (THIS_ HX_RESULT status, IHXBuffer *pBuffer);
        STDMETHOD(WriteDone) (THIS_ HX_RESULT status);
        STDMETHOD(CloseDone) (THIS_ HX_RESULT status);

        HX_RESULT   GetFile(IHXFileObject* /*IN*/ pFile);
        void        Close(void);

    protected:
        BOOL            m_bGetFilePending;
        IHXBuffer*      m_pBuffer;
        HXFileSource*   m_pOwner;
        IHXFileObject*  m_pFile;
        LONG32          m_lRefCount;
    };

    friend class CFileReader;

    CFileReader*                m_pFileReader;
    CHXFileRecognizer*          m_pFileRecognizer;
};

#endif // _HX_FILE_SOURCE


