package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/satori/uuid"
	"net/http"
)

// DataLakeStoreAccountState enumerates the values for data lake store account
// state.
type DataLakeStoreAccountState string

const (
	// Active specifies the active state for data lake store account state.
	Active DataLakeStoreAccountState = "Active"
	// Suspended specifies the suspended state for data lake store account
	// state.
	Suspended DataLakeStoreAccountState = "Suspended"
)

// DataLakeStoreAccountStatus enumerates the values for data lake store account
// status.
type DataLakeStoreAccountStatus string

const (
	// Creating specifies the creating state for data lake store account
	// status.
	Creating DataLakeStoreAccountStatus = "Creating"
	// Deleted specifies the deleted state for data lake store account status.
	Deleted DataLakeStoreAccountStatus = "Deleted"
	// Deleting specifies the deleting state for data lake store account
	// status.
	Deleting DataLakeStoreAccountStatus = "Deleting"
	// Failed specifies the failed state for data lake store account status.
	Failed DataLakeStoreAccountStatus = "Failed"
	// Patching specifies the patching state for data lake store account
	// status.
	Patching DataLakeStoreAccountStatus = "Patching"
	// Resuming specifies the resuming state for data lake store account
	// status.
	Resuming DataLakeStoreAccountStatus = "Resuming"
	// Running specifies the running state for data lake store account status.
	Running DataLakeStoreAccountStatus = "Running"
	// Succeeded specifies the succeeded state for data lake store account
	// status.
	Succeeded DataLakeStoreAccountStatus = "Succeeded"
	// Suspending specifies the suspending state for data lake store account
	// status.
	Suspending DataLakeStoreAccountStatus = "Suspending"
)

// EncryptionConfigType enumerates the values for encryption config type.
type EncryptionConfigType string

const (
	// ServiceManaged specifies the service managed state for encryption config
	// type.
	ServiceManaged EncryptionConfigType = "ServiceManaged"
	// UserManaged specifies the user managed state for encryption config type.
	UserManaged EncryptionConfigType = "UserManaged"
)

// EncryptionProvisioningState enumerates the values for encryption
// provisioning state.
type EncryptionProvisioningState string

const (
	// EncryptionProvisioningStateCreating specifies the encryption
	// provisioning state creating state for encryption provisioning state.
	EncryptionProvisioningStateCreating EncryptionProvisioningState = "Creating"
	// EncryptionProvisioningStateSucceeded specifies the encryption
	// provisioning state succeeded state for encryption provisioning state.
	EncryptionProvisioningStateSucceeded EncryptionProvisioningState = "Succeeded"
)

// EncryptionState enumerates the values for encryption state.
type EncryptionState string

const (
	// Disabled specifies the disabled state for encryption state.
	Disabled EncryptionState = "Disabled"
	// Enabled specifies the enabled state for encryption state.
	Enabled EncryptionState = "Enabled"
)

// FirewallAllowAzureIpsState enumerates the values for firewall allow azure
// ips state.
type FirewallAllowAzureIpsState string

const (
	// FirewallAllowAzureIpsStateDisabled specifies the firewall allow azure
	// ips state disabled state for firewall allow azure ips state.
	FirewallAllowAzureIpsStateDisabled FirewallAllowAzureIpsState = "Disabled"
	// FirewallAllowAzureIpsStateEnabled specifies the firewall allow azure ips
	// state enabled state for firewall allow azure ips state.
	FirewallAllowAzureIpsStateEnabled FirewallAllowAzureIpsState = "Enabled"
)

// FirewallState enumerates the values for firewall state.
type FirewallState string

const (
	// FirewallStateDisabled specifies the firewall state disabled state for
	// firewall state.
	FirewallStateDisabled FirewallState = "Disabled"
	// FirewallStateEnabled specifies the firewall state enabled state for
	// firewall state.
	FirewallStateEnabled FirewallState = "Enabled"
)

// TierType enumerates the values for tier type.
type TierType string

const (
	// Commitment100TB specifies the commitment 100tb state for tier type.
	Commitment100TB TierType = "Commitment_100TB"
	// Commitment10TB specifies the commitment 10tb state for tier type.
	Commitment10TB TierType = "Commitment_10TB"
	// Commitment1PB specifies the commitment 1pb state for tier type.
	Commitment1PB TierType = "Commitment_1PB"
	// Commitment1TB specifies the commitment 1tb state for tier type.
	Commitment1TB TierType = "Commitment_1TB"
	// Commitment500TB specifies the commitment 500tb state for tier type.
	Commitment500TB TierType = "Commitment_500TB"
	// Commitment5PB specifies the commitment 5pb state for tier type.
	Commitment5PB TierType = "Commitment_5PB"
	// Consumption specifies the consumption state for tier type.
	Consumption TierType = "Consumption"
)

// TrustedIDProviderState enumerates the values for trusted id provider state.
type TrustedIDProviderState string

const (
	// TrustedIDProviderStateDisabled specifies the trusted id provider state
	// disabled state for trusted id provider state.
	TrustedIDProviderStateDisabled TrustedIDProviderState = "Disabled"
	// TrustedIDProviderStateEnabled specifies the trusted id provider state
	// enabled state for trusted id provider state.
	TrustedIDProviderStateEnabled TrustedIDProviderState = "Enabled"
)

// DataLakeStoreAccount is data Lake Store account information
type DataLakeStoreAccount struct {
	autorest.Response               `json:"-"`
	ID                              *string             `json:"id,omitempty"`
	Name                            *string             `json:"name,omitempty"`
	Type                            *string             `json:"type,omitempty"`
	Location                        *string             `json:"location,omitempty"`
	Tags                            *map[string]*string `json:"tags,omitempty"`
	Identity                        *EncryptionIdentity `json:"identity,omitempty"`
	*DataLakeStoreAccountProperties `json:"properties,omitempty"`
}

// DataLakeStoreAccountListResult is data Lake Store account list information
// response.
type DataLakeStoreAccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DataLakeStoreAccount `json:"value,omitempty"`
	NextLink          *string                 `json:"nextLink,omitempty"`
}

// DataLakeStoreAccountListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DataLakeStoreAccountListResult) DataLakeStoreAccountListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DataLakeStoreAccountProperties is data Lake Store account properties
// information
type DataLakeStoreAccountProperties struct {
	ProvisioningState           DataLakeStoreAccountStatus  `json:"provisioningState,omitempty"`
	State                       DataLakeStoreAccountState   `json:"state,omitempty"`
	CreationTime                *date.Time                  `json:"creationTime,omitempty"`
	EncryptionState             EncryptionState             `json:"encryptionState,omitempty"`
	EncryptionProvisioningState EncryptionProvisioningState `json:"encryptionProvisioningState,omitempty"`
	EncryptionConfig            *EncryptionConfig           `json:"encryptionConfig,omitempty"`
	FirewallState               FirewallState               `json:"firewallState,omitempty"`
	FirewallRules               *[]FirewallRule             `json:"firewallRules,omitempty"`
	TrustedIDProviderState      TrustedIDProviderState      `json:"trustedIdProviderState,omitempty"`
	TrustedIDProviders          *[]TrustedIDProvider        `json:"trustedIdProviders,omitempty"`
	LastModifiedTime            *date.Time                  `json:"lastModifiedTime,omitempty"`
	Endpoint                    *string                     `json:"endpoint,omitempty"`
	DefaultGroup                *string                     `json:"defaultGroup,omitempty"`
	NewTier                     TierType                    `json:"newTier,omitempty"`
	CurrentTier                 TierType                    `json:"currentTier,omitempty"`
	FirewallAllowAzureIps       FirewallAllowAzureIpsState  `json:"firewallAllowAzureIps,omitempty"`
}

// DataLakeStoreAccountUpdateParameters is data Lake Store account information
// to update
type DataLakeStoreAccountUpdateParameters struct {
	Tags                                  *map[string]*string `json:"tags,omitempty"`
	*UpdateDataLakeStoreAccountProperties `json:"properties,omitempty"`
}

// DataLakeStoreFirewallRuleListResult is data Lake Store firewall rule list
// information.
type DataLakeStoreFirewallRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]FirewallRule `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// DataLakeStoreFirewallRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DataLakeStoreFirewallRuleListResult) DataLakeStoreFirewallRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DataLakeStoreTrustedIDProviderListResult is data Lake Store trusted identity
// provider list information.
type DataLakeStoreTrustedIDProviderListResult struct {
	autorest.Response `json:"-"`
	Value             *[]TrustedIDProvider `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// DataLakeStoreTrustedIDProviderListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DataLakeStoreTrustedIDProviderListResult) DataLakeStoreTrustedIDProviderListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EncryptionConfig is the encryption configuration for the account.
type EncryptionConfig struct {
	Type             EncryptionConfigType `json:"type,omitempty"`
	KeyVaultMetaInfo *KeyVaultMetaInfo    `json:"keyVaultMetaInfo,omitempty"`
}

// EncryptionIdentity is the encryption identity properties.
type EncryptionIdentity struct {
	Type        *string    `json:"type,omitempty"`
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	TenantID    *uuid.UUID `json:"tenantId,omitempty"`
}

// ErrorDetails is data Lake Store error details information
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
}

// FirewallRule is data Lake Store firewall rule information
type FirewallRule struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// FirewallRuleProperties is data Lake Store firewall rule properties
// information
type FirewallRuleProperties struct {
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	EndIPAddress   *string `json:"endIpAddress,omitempty"`
}

// KeyVaultMetaInfo is metadata information used by account encryption.
type KeyVaultMetaInfo struct {
	KeyVaultResourceID   *string `json:"keyVaultResourceId,omitempty"`
	EncryptionKeyName    *string `json:"encryptionKeyName,omitempty"`
	EncryptionKeyVersion *string `json:"encryptionKeyVersion,omitempty"`
}

// Resource is the Resource model definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// SubResource is the Resource model definition for a nested resource.
type SubResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// TrustedIDProvider is data Lake Store Trusted Identity Provider information
type TrustedIDProvider struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*TrustedIDProviderProperties `json:"properties,omitempty"`
}

// TrustedIDProviderProperties is data Lake Store trusted identity provider
// properties information
type TrustedIDProviderProperties struct {
	IDProvider *string `json:"idProvider,omitempty"`
}

// UpdateDataLakeStoreAccountProperties is data Lake Store account properties
// information to be updated.
type UpdateDataLakeStoreAccountProperties struct {
	FirewallState          FirewallState              `json:"firewallState,omitempty"`
	TrustedIDProviderState TrustedIDProviderState     `json:"trustedIdProviderState,omitempty"`
	DefaultGroup           *string                    `json:"defaultGroup,omitempty"`
	NewTier                TierType                   `json:"newTier,omitempty"`
	FirewallAllowAzureIps  FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
}

// UpdateFirewallRuleParameters is data Lake Analytics firewall rule update
// parameters
type UpdateFirewallRuleParameters struct {
	*UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// UpdateFirewallRuleProperties is data Lake Analytics firewall rule properties
// information
type UpdateFirewallRuleProperties struct {
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	EndIPAddress   *string `json:"endIpAddress,omitempty"`
}

// UpdateTrustedIDProviderParameters is data Lake Store Trusted Identity
// Provider update parameters
type UpdateTrustedIDProviderParameters struct {
	*UpdateTrustedIDProviderProperties `json:"properties,omitempty"`
}

// UpdateTrustedIDProviderProperties is data Lake Store trusted identity
// provider property update information
type UpdateTrustedIDProviderProperties struct {
	IDProvider *string `json:"idProvider,omitempty"`
}
