/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import com.gallery.GalleryRemote.GR2Exception;
import com.gallery.GalleryRemote.GalleryComm2;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.util.GRI18n;
import java.io.IOException;
import java.util.Arrays;

public class GalleryComm2_5
extends GalleryComm2 {
    private static final String MODULE = "GalComm2";
    public static final String SCRIPT_NAME = "main.php?g2_controller=remote.GalleryRemote&g2_form[cmd]=no-op";
    public static final boolean ZEND_DEBUG = false;
    private static int[] capabilities2;
    private static int[] capabilities3;
    private static int[] capabilities4;
    private static int[] capabilities6;
    private static int[] capabilities7;
    private static int[] capabilities8;

    protected GalleryComm2_5(Gallery g) {
        super(g);
        this.scriptName = "main.php";
        capabilities2 = new int[]{1, 2, 3, 4, 7};
        capabilities3 = new int[]{1, 2, 3, 4, 6, 7};
        capabilities4 = new int[]{1, 2, 3, 4, 6, 7, 9};
        capabilities6 = new int[]{1, 2, 3, 4, 5, 6, 7, 9};
        capabilities7 = new int[]{1, 2, 3, 4, 5, 6, 7, 9, 15};
        capabilities8 = new int[]{1, 2, 3, 4, 5, 6, 7, 9, 15, 2};
        Arrays.sort(capabilities2);
        Arrays.sort(capabilities3);
        Arrays.sort(capabilities4);
        Arrays.sort(capabilities6);
        Arrays.sort(capabilities7);
        Arrays.sort(capabilities8);
        g.setGalleryVersion(2);
    }

    public void incrementViewCount(StatusUpdate su, Picture p) {
        this.doTask(new IncrementViewCountTask(su, p), true);
    }

    public NVPair[] fudgeParameters(NVPair[] data) {
        NVPair[] data_modified = new NVPair[data.length];
        for (int i = 0; i < data.length; ++i) {
            NVPair nvPair = data[i];
            data_modified[i] = new NVPair("g2_" + nvPair.getName(), nvPair.getValue(), nvPair.safeGetEncoding());
        }
        return data_modified;
    }

    public NVPair[] fudgeFormParameters(NVPair[] form_data) {
        NVPair[] form_data_modified = new NVPair[form_data.length + 1];
        for (int i = 0; i < form_data.length; ++i) {
            form_data_modified[i] = form_data[i] != null ? new NVPair("g2_form[" + form_data[i].getName() + "]", form_data[i].getValue(), form_data[i].safeGetEncoding()) : null;
        }
        form_data_modified[form_data.length] = new NVPair("g2_controller", "remote.GalleryRemote");
        Log.log(3, MODULE, "Overriding form data: " + Arrays.asList(form_data_modified));
        return form_data_modified;
    }

    void handleCapabilities() {
        this.capabilities = this.serverMinorVersion >= 8 ? capabilities8 : (this.serverMinorVersion >= 7 ? capabilities7 : (this.serverMinorVersion >= 6 ? capabilities6 : (this.serverMinorVersion >= 4 ? capabilities4 : (this.serverMinorVersion >= 3 ? capabilities3 : capabilities2))));
    }

    class IncrementViewCountTask
    extends GalleryComm2.GalleryTask {
        Picture p;

        IncrementViewCountTask(StatusUpdate su, Picture p) {
            super(su);
            this.p = p;
        }

        void runTask() {
            try {
                NVPair[] form_data = new NVPair[]{new NVPair("cmd", "increment-view-count"), new NVPair("protocol_version", "2.3"), new NVPair("itemId", this.p.getItemId())};
                Log.log(3, GalleryComm2_5.MODULE, "increment-view-count parameters: " + Arrays.asList(form_data));
                form_data = GalleryComm2_5.this.fudgeFormParameters(form_data);
                GalleryProperties p = GalleryComm2_5.this.requestResponse(form_data, this.su, this);
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2_5.MODULE, gr2e);
                Object[] params2 = new Object[]{gr2e.getMessage()};
                GalleryComm2_5.this.error(this.su, GRI18n.getString(GalleryComm2_5.MODULE, "error", params2));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2_5.MODULE, ioe);
                Object[] params2 = new Object[]{ioe.toString()};
                GalleryComm2_5.this.error(this.su, GRI18n.getString(GalleryComm2_5.MODULE, "error", params2));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2_5.MODULE, me);
                Object[] params2 = new Object[]{me.toString()};
                GalleryComm2_5.this.error(this.su, GRI18n.getString(GalleryComm2_5.MODULE, "error", params2));
            }
        }
    }
}

